**Summarizes weighted means of variables in dataset;
%macro summary_means(input_data=,
										 variables=,
										 row_subset=,
										 population_name=All,
										 weight=,
										 outlib=WORK,
										 outname=);
										 
	%local num_variables i;
										 
	%let num_variables = %sysfunc(countw(&variables., %str( )));
										 
	**Calculate means;
	proc univariate data=&input_data. noprint;
		%if &row_subset. ^= %str() %then %do;
			where &row_subset.;
		%end;
		
		var &variables.;
		
		%if &weight. ^= %str() %then %do;
			weight &weight.;
		%end;
		
		output out=_outmeans mean=variable1-variable&num_variables.;
	run;
	
	**Create summary dataset;
	data &outlib..&outname. (keep = population variable statistic value);
		set _outmeans;
		
		length population $200.;
		length variable $32.;
		length statistic $200.;
		
		population = "&population_name.";
		
		%do i = 1 %to &num_variables.;
		
			variable = scan("&variables.", &i., " ");
			statistic = "Mean";
			value = variable&i.;
			
			output;
		%end;
	run;
%mend summary_means;

**Summarizes weighted quantiles of variables in dataset;
%macro summary_quantiles(input_data=,
												 variables=,
												 row_subset=,
												 population_name=All,
												 weight=,
												 quantiles=5 25 50 75 95,
												 outlib=WORK,
												 outname=);
												 
	%local num_variables i
				 num_quantiles j;
												 
	%let num_variables = %sysfunc(countw(&variables., %str( )));
	%let num_quantiles = %sysfunc(countw(&quantiles., %str( )));
	
	**Calculate quantiles;
	proc univariate data=&input_data. noprint;
		%if &row_subset. ^= %str() %then %do;
			where &row_subset.;
		%end;
		
		var &variables.;
		
		%if &weight. ^= %str() %then %do;
			weight &weight.;
		%end;
		
		output out=_outquantiles pctlpts=&quantiles. pctlpre=variable1-variable&num_variables. pctlname=_q1-_q&num_quantiles.;
	run;
	
	**Create summary dataset;
	data &outlib..&outname. (keep = population variable statistic value);
		set _outquantiles;
		
		length population $200.;
		length variable $32.;
		length statistic $200.;
		
		population = "&population_name.";
		
		%do i = 1 %to &num_variables.;
		
			variable = scan("&variables.", &i., " ");
			
			%do j = 1 %to &num_quantiles.;
			
				statistic = cat(scan("&quantiles.", &j., " "), "%");
				value = variable&i._q&j.;
				
				output;
			%end;
		%end;
	run;
%mend summary_quantiles;

**Summarizes proportions of observations in dataset above/below thresholds;
%macro summary_proportions(input_data=,
													 row_subset=,
													 population_name=All,
													 weight=,
													 lower_thresholds=,
													 upper_thresholds=,
													 outlib=WORK,
													 outname=);
													 
	%local lower_threshold_variables upper_threshold_variables
				 lower_threshold_values upper_threshold_values
				 num_lower num_upper i;
													 
	**extract thresholds;
	%if &lower_thresholds. ^= %str() %then %do;
	
		data _NULL_;
			set &lower_thresholds. end=last;
			
			length lower_threshold_variables $32767.;
			length lower_threshold_values $32767.;
			
			if _N_ = 1 then do;
				
				lower_threshold_variables = "";
				lower_threshold_values = "";
			end;
			
			lower_threshold_variables = catx(" ", lower_threshold_variables, variable);
			lower_threshold_values = catx(" ", lower_threshold_values, threshold);
			
			if last = 1 then do;
			
				call symputx("lower_threshold_variables", lower_threshold_variables);
				call symputx("lower_threshold_values", lower_threshold_values);
				call symputx("num_lower", _N_);
			end;
		run;
	%end;
	
	%if &upper_thresholds. ^= %str() %then %do;
		
		data _NULL_;
			set &upper_thresholds. end=last;
			
			length upper_threshold_variables $32767.;
			length upper_threshold_values $32767.;
			
			if _N_ = 1 then do;
				
				upper_threshold_variables = "";
				upper_threshold_values = "";
			end;
			
			upper_threshold_variables = catx(" ", upper_threshold_variables, variable);
			upper_threshold_values = catx(" ", upper_threshold_values, threshold);
			
			if last = 1 then do;
			
				call symputx("upper_threshold_variables", upper_threshold_variables);
				call symputx("upper_threshold_values", upper_threshold_values);
				call symputx("num_upper", _N_);
			end;
		run;
	%end;
	
	**create indicators;
	data _threshold_indicators;
		set &input_data.;
		
		%if &lower_thresholds. ^= %str() %then %do;
		
			%do i = 1 %to &num_lower.;
			
				%let variable = %sysfunc(scan(&lower_threshold_variables., &i., %str( )));
				%let threshold = %sysfunc(scan(&lower_threshold_values., &i., %str( )));
				
				_lower_ind&i. = (&variable. > &threshold.);
			%end;
		%end;
		
		%if &upper_thresholds. ^= %str() %then %do;
		
			%do i = 1 %to &num_upper.;
			
				%let variable = %sysfunc(scan(&upper_threshold_variables., &i., %str( )));
				%let threshold = %sysfunc(scan(&upper_threshold_values., &i., %str( )));
				
				_upper_ind&i. = (&variable. < &threshold.);
			%end;
		%end;
	run;
	
	**calculate proportions;
	proc univariate data=_threshold_indicators noprint;
		%if &row_subset. ^= %str() %then %do;
			where &row_subset.;
		%end;
		
		var %if &lower_thresholds. ^= %str() %then %do;
					_lower_ind1-_lower_ind&num_lower.
				%end;
				%if &upper_thresholds. ^= %str() %then %do;
					_upper_ind1-_upper_ind&num_upper.
				%end;
				;
				
		%if &weight. ^= %str() %then %do;
			weight &weight.;
		%end;
		
		output out=_outprop mean=%if &lower_thresholds. ^= %str() %then %do;
														 	 _lower_ind1-_lower_ind&num_lower.
														 %end;
														 %if &upper_thresholds. ^= %str() %then %do;
														 	 _upper_ind1-_upper_ind&num_upper.
														 %end;
														 ;
	run;
	
	**Create summary dataset;
	data &outlib..&outname. (keep = population variable statistic value);
		set _outprop;
		
		length population $200.;
		length variable $32.;
		length statistic $200.;
		
		population = "&population_name.";
		
		%if &lower_thresholds. ^= %str() %then %do;
		
			%do i = 1 %to &num_lower.;
			
				variable = cat(scan("&lower_threshold_variables.", &i., " "), " > ", scan("&lower_threshold_values.", &i., " "));
				statistic = "Proportion";
				value = _lower_ind&i.;
				
				output;
			%end;
		%end;
		
		%if &upper_thresholds. ^= %str() %then %do;
		
			%do i = 1 %to &num_upper.;
			
				variable = cat(scan("&upper_threshold_variables.", &i., " "), " < ", scan("&upper_threshold_values.", &i., " "));
				statistic = "Proportion";
				value = _upper_ind&i.;
				
				output;
			%end;
		%end;
	run;
%mend summary_proportions;
