**Rounds weights in each post-stratification cell to nearest integer, remainders are balanced to reduce rounding error;
%macro integerize_weights(weight_data=,
													weights=,
													cell=);
													
	%local num_weights;
													
	data _NULL_;
		set &weight_data.;
		if _N_ = 1;
		
		call symputx("num_weights", N(of &weights.));
	run;
													
	%if &cell. ^= %str() %then %do;
		proc sort data=&weight_data.; by &cell.; run;
	%end;
	
	data &weight_data.;
		set &weight_data.;
		%if &cell. ^= %str() %then %do;
			by &cell.;
		%end;
		
		retain raw1-raw&num_weights. int1-int&num_weights.;
		
		array weight{&num_weights.} &weights.;
		array raw{&num_weights.} raw1-raw&num_weights.;
		array int{&num_weights.} int1-int&num_weights.;
		
		do i = 1 to &num_weights.;
		
			%if &cell. ^= %str() %then %do;
				if first.&cell. then do;
			%end;
			%else %do;
				if _N_ = 1 then do;
			%end;
			
				raw{i} = 0;
				int{i} = 0;
			end;
			
			raw{i} = raw{i} + weight{i};
			weight{i} = round(raw{i}) - int{i};
			int{i} = int{i} + weight{i};
		end;
	run;
%mend integerize_weights;