% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_quantiles.R
\name{weighted_quantiles}
\alias{weighted_quantiles}
\title{Weighted quantiles}
\usage{
weighted_quantiles(x, w, probs)
}
\arguments{
\item{x}{A numeric vector.}

\item{w}{Numeric vector of weights the same length as \code{x}.}

\item{probs}{Numeric vector of quantiles to compute. Can range from 0 to 1.}
}
\value{
A numeric vector of length \code{length(probs)} with the computed
quantiles of \code{x}.
}
\description{
Calculates weighted quantiles.
}
\details{
Weighted quantiles are calculated using the empirical distribution
function with weights, averaging at discontinuities. This is equivalent to
weighted percentiles with PROC UNIVARIATE in SAS.
}
\examples{
#Weighted percentiles of reported energy intake
weighted_quantiles(x=nhcvd$TKCAL, w=nhcvd$WTDRD1, probs=c(0.05, 0.1, 0.25, 0.5, 0.75, 0.9, 0.95))
}
