% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summary_difference}
\alias{summary_difference}
\title{Differences Between Two Populations}
\usage{
summary_difference(population1, population2)
}
\arguments{
\item{population1, population2}{Data frames of populations to compare. Must
have the following columns:
\itemize{
\item population: Name of the population.
\item variable: Name of the variable being summarized.
\item statistic: Name of the summary statistic.
\item value: Value of the summary statistic.
}}
}
\value{
A data frame with the following columns:
\itemize{
\item population: Name of the population difference, composed from \code{population} columns of \code{population1} and \code{population2}.
\item variable: Name of the variable being summarized.
\item statistic: Name of the summary statistic.
\item value: Difference between the \code{value} columns of \code{population1} and \code{population2}.
}
}
\description{
Calculates the differences in summary statistics between two
populations.
}
\details{
This utility function is designed to work with the output of the
other summary functions in the \code{ncimultivar} package. Differences will be
calculated for rows in the two input populations that have matching
\code{variable} and \code{statistic} columns. Differences will not be calculated for
rows in either population with no match.
}
\examples{
#Subset NHANES data
nhanes.subset <- nhcvd[nhcvd$SDMVSTRA \%in\% c(48, 60, 72),]

#Use NCI method to simulate usual intakes of sodium using sex as a covariate
boxcox.lambda.data <- boxcox_survey(input.data=nhanes.subset,
                                    row.subset=(nhanes.subset$DAY == 1),
                                    variable="TSODI",
                                    id="SEQN",
                                    repeat.obs="DAY",
                                    weight="WTDRD1",
                                    covariates="RIAGENDR")

minimum.amount.data <- calculate_minimum_amount(input.data=nhanes.subset,
                                                row.subset=(nhanes.subset$DAY == 1),
                                                daily.variables="TSODI")

pre.mcmc.data <- nci_multivar_preprocessor(input.data=nhanes.subset,
                                           daily.variables="TSODI",
                                           boxcox.lambda.data=boxcox.lambda.data,
                                           minimum.amount.data=minimum.amount.data)

mcmc.output <- nci_multivar_mcmc(pre.mcmc.data=pre.mcmc.data,
                                 id="SEQN",
                                 weight="WTDRD1",
                                 repeat.obs="DAY",
                                 daily.variables="TSODI",
                                 default.covariates="RIAGENDR",
                                 num.mcmc.iterations=1000,
                                 num.burn=500,
                                 num.thin=1)

mcmc.input.data <- pre.mcmc.data$mcmc.input
population.base <- mcmc.input.data[!duplicated(mcmc.input.data$SEQN),]

distrib.output <- nci_multivar_distrib(multivar.mcmc.model=mcmc.output,
                                       distrib.population=population.base,
                                       id="SEQN",
                                       weight="WTDRD1",
                                       num.simulated.u=100,
                                       additional.output="RIAGENDR")

#summary statistics for male and female subjects
summary.male <- nci_multivar_summary(input.data=distrib.output,
                                     row.subset=(distrib.output$RIAGENDR == 0),
                                     weight="WTDRD1",
                                     population.name="Male",
                                     variables="usual.intake.TSODI")
summary.male

summary.female <- nci_multivar_summary(input.data=distrib.output,
                                       row.subset=(distrib.output$RIAGENDR == 1),
                                       weight="WTDRD1",
                                       population.name="Female",
                                       variables="usual.intake.TSODI")
summary.female

#calculate differences between statistics in male and female subsets
summary.differences <- summary_difference(population1=summary.male,
                                          population2=summary.female)
summary.differences
}
