% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nhcvd}
\alias{nhcvd}
\title{NHANES 2005-2010 Data with Disease Outcomes}
\format{
A data frame with 19789 rows and 124 variables:
\describe{
\item{SEQN}{Respondent sequence number}
\item{DAY}{Interview sequence}
\item{DayOfWk}{Intake day of the week}
\item{Weekend}{0=Monday-Thursday, 1=Friday-Sunday}
\item{TKCAL}{Energy (kcal)}
\item{TPROT}{Protein (g)}
\item{TCARB}{Carbohydrate (g)}
\item{TSUGR}{Total sugars (g)}
\item{TFIBE}{Dietary fiber (g)}
\item{TTFAT}{Total fat (g)}
\item{TSFAT}{Total saturated fatty acids (g)}
\item{TMFAT}{Total monounsaturated fatty acids (g)}
\item{TPFAT}{Total polyunsaturated fatty acids (g)}
\item{TCHOL}{Cholesterol (mg)}
\item{TATOC}{Vitamin E as alpha-tocopherol (mg)}
\item{TATOA}{Added alpha-tocopherol (Vitamin E) (mg)}
\item{TRET}{Retinol (mcg)}
\item{TVARA}{Vitamin A, RAE (mcg)}
\item{TBCAR}{Beta-carotene (mcg)}
\item{TCRYP}{Beta-cryptoxanthin (mcg)}
\item{TLYCO}{Lycopene (mcg)}
\item{TLZ}{Lutein + zeaxanthin (mcg)}
\item{TVB1}{Thiamin (Vitamin B1) (mg)}
\item{TVB2}{Riboflavin (Vitamin B2) (mg)}
\item{TNIAC}{Niacin (mg)}
\item{TVB6}{Vitamin B6 (mg)}
\item{TFOLA}{Total folate (mcg)}
\item{TFA}{Folic acid (mcg)}
\item{TFF}{Food folate (mcg)}
\item{TFDFE}{Folate, DFE (mcg)}
\item{TCHL}{Total choline (mg)}
\item{TVB12}{Vitamin B12 (mcg)}
\item{TB12A}{Added vitamin B12 (mcg)}
\item{TVC}{Vitamin C (mg)}
\item{TVK}{Vitamin K (mcg)}
\item{TCALC}{Calcium (mg)}
\item{TPHOS}{Phosphorus (mg)}
\item{TMAGN}{Magnesium (mg)}
\item{TIRON}{Iron (mg)}
\item{TZINC}{Zinc (mg)}
\item{TCOPP}{Copper (mg)}
\item{TSODI}{Sodium (mg)}
\item{TPOTA}{Potassium (mg)}
\item{TSELE}{Selenium (mcg)}
\item{TCAFF}{Caffeine (mg)}
\item{TTHEO}{Theobromine (mg)}
\item{TALCO}{Alcohol (g)}
\item{TMOIS}{Moisture (g)}
\item{TS040}{SFA 4:0 (Butanoic) (g)}
\item{TS060}{SFA 6:0 (Hexanoic) (g)}
\item{TS080}{SFA 8:0 (Octanoic) (g)}
\item{TS100}{SFA 10:0 (Decanoic) (g)}
\item{TS120}{SFA 12:0 (Dodecanoic) (g)}
\item{TS140}{SFA 14:0 (Tetradecanoic) (g)}
\item{TS160}{SFA 16:0 (Hexadecanoic) (g)}
\item{TS180}{SFA 18:0 (Octadecanoic) (g)}
\item{TM161}{MFA 16:1 (Hexadecenoic) (g)}
\item{TM181}{MFA 18:1 (Octadecenoic) (g)}
\item{TM201}{MFA 20:1 (Eicosenoic) (g)}
\item{TM221}{MFA 22:1 (Docosenoic) (g)}
\item{TP182}{PFA 18:2 (Octadecadienoic) (g)}
\item{TP183}{PFA 18:3 (Octadecatrienoic) (g)}
\item{TP184}{18:4 (Octadecatetraenoic) (g)}
\item{TP204}{PFA 20:4 (Eicosatetraenoic) (g)}
\item{TP205}{PFA 20:5 (Eicosapentaenoic) (g)}
\item{TP225}{PFA 22:5 (Docosapentaenoic) (g)}
\item{TP226}{PFA 22:6 (Docosahexaenoic) (g)}
\item{F_CITMLB}{Intact fruits (whole or cut) of citrus, melons, and berries (cup eq.)}
\item{F_OTHER}{Intact fruits (whole or cut); excluding citrus, melons, and berries (cup eq.)}
\item{F_JUICE}{Fruit juices, citrus and non citrus (cup eq.)}
\item{F_TOTAL}{Total intact or cut fruits and fruit juices (cup eq.)}
\item{V_DRKGR}{Dark green vegetables (cup eq.)}
\item{V_REDOR_TOMATO}{Tomatoes and tomato products (cup eq.)}
\item{V_REDOR_OTHER}{Other red and orange vegetables, excluding tomatoes and tomato products (cup eq.)}
\item{V_REDOR_TOTAL}{Total red and orange vegetables (tomatoes + other red and orange) (cup eq.)}
\item{V_STARCHY_POTATO}{White potatoes (cup eq.)}
\item{V_STARCHY_OTHER}{Other starchy vegetables, excluding white potatoes (cup eq.)}
\item{V_STARCHY_TOTAL}{Total starchy vegetables (white potatoes + other starchy) (cup eq.)}
\item{V_OTHER}{Other vegetables not in the vegetable components listed above (cup eq.)}
\item{V_TOTAL}{Total dark green, red and orange, starchy, and other vegetables; excludes legumes (cup eq.)}
\item{V_LEGUMES}{Legumes computed as vegetables (cup eq.)}
\item{G_WHOLE}{Whole grains (oz. eq.)}
\item{G_REFINED}{Refined or non-whole grains (oz. eq.)}
\item{G_TOTAL}{Total whole and refined grains (oz. eq.)}
\item{PF_MEAT}{Beef, veal, pork, lamb, game meat; excludes organ meats and cured meat (oz. eq.)}
\item{PF_CUREDMEAT}{Cured/luncheon meat made from beef, pork, or poultry (oz. eq.)}
\item{PF_ORGAN}{Organ meat from beef, veal, pork, lamb, game, and poultry (oz. eq.)}
\item{PF_POULT}{Chicken, turkey, Cornish hens, and game birds; excludes organ meats and cured meat (oz. eq.)}
\item{PF_SEAFD_HI}{Seafood (finfish, shellfish and other seafood) high in n-3 fatty acids (oz. eq.)}
\item{PF_SEAFD_LOW}{Seafood (finfish, shellfish and other seafood) low in n-3 fatty acids (oz. eq.)}
\item{PF_MPS_TOTAL}{Total meat, poultry, seafood, organ meats, and cured meat (oz. eq.)}
\item{PF_EGGS}{Eggs (chicken, duck, goose, quail) and egg substitutes (oz. eq.)}
\item{PF_SOY}{Soy products, excluding calcium fortified soy milk and immature soybeans (oz. eq.)}
\item{PF_NUTSDS}{Peanuts, tree nuts, and seeds, excludes coconut (oz. eq.)}
\item{PF_LEGUMES}{Legumes computed as protein foods (oz. eq.)}
\item{PF_TOTAL}{Total meat, poultry, seafood, organ meats, cured meat, eggs, soy, and nuts and seeds; excludes legumes (oz. eq.)}
\item{D_MILK}{Fluid milk and calcium fortified soy milk (cup eq.)}
\item{D_YOGURT}{Yogurt (cup eq.)}
\item{D_CHEESE}{Cheese (cup eq.)}
\item{D_TOTAL}{Total milk, yogurt, cheese, and whey (cup eq.)}
\item{OILS}{Oils (g)}
\item{SOLID_FATS}{Solid fats (g)}
\item{ADD_SUGARS}{Foods defined as added sugars (tsp. eq.)}
\item{A_DRINKS}{Alcoholic beverages (no. of drinks)}
\item{WTDRD1}{Day 1 Dietary sample weight}
\item{RIAGENDR}{Gender (0=Male, 1=Female)}
\item{RIDAGEYR}{Age in years (Range 20-85)}
\item{RIDRETH1}{Race/Ethnicity (1=Mexican-American, 2=Other Hispanic, 3=Non-Hispanic White, 4=Non-Hispanic Black, 5=Other Race)}
\item{DMDEDUC2}{Education (1=<9th Grade, 2=9th-11th Grade, 3=High School Graduate, 4=Some College, 5=College Graduate or Above)}
\item{BMXBMI}{Body Mass Index}
\item{BPSY_AVG}{Systolic Blood Pressure (Averaged)}
\item{BPDI_AVG}{Diastolic Blood Pressure (Averaged)}
\item{HTN_STAT}{Hypertension (1=Diagnosed by doctor, 2=Undiagnosed, but high on exam, 3=No indication of hypertension)}
\item{HTN_BIN}{Hypertension Binary (0=No, 1=Yes)}
\item{CVDSTAT}{History of Cardiovascular Disease (0=No, 1=Yes)}
\item{EDUBIN}{Education Binary (0=High School Graduate or Below, 1=Some College or Above)}
\item{RACE_REC}{Race/Ethnicity Alternate Code (1=Mexican-American, 2=Non-Hispanic White, 3=Non-Hispanic Black, 4=All Other)}
\item{SMK_REC}{Smoking Status (1=Current, 2=Former, 3=Never)}
\item{DIABSTAT}{Diabetes (0=No, 1=Yes)}
\item{KIDSTAT}{Chronic Kidney Disease (0=No, 1=Yes)}
\item{HEAV_ALC}{Heavy Alcohol User (0=No, 1=Yes)}
\item{SDMVPSU}{Masked Variance Pseudo-PSU}
\item{SDMVSTRA}{Masked Variance Pseudo-Stratum}
\item{PSCELL}{Post-Stratification Cell}
}
}
\usage{
nhcvd
}
\description{
This dataset was derived from the 2005-2006, 2007-2008, and 2009-2010 NHANES
cycles. It contains all of the foods and nutrients needed to compute Healthy
Eating Index (HEI) scores as well as disease outcome variables. It is
suitable for variance estimation with balanced repeated replication (BRR).
}
\references{
\url{https://wwwn.cdc.gov/nchs/nhanes/default.aspx}
}
\keyword{datasets}
