% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nci_multivar_mcmc.R
\name{nci_multivar_mcmc}
\alias{nci_multivar_mcmc}
\title{Fit MCMC measurement error model}
\usage{
nci_multivar_mcmc(
  pre.mcmc.data,
  id,
  weight = NULL,
  repeat.obs,
  episodic.variables = NULL,
  episodic.indicators = NULL,
  episodic.amounts = NULL,
  daily.variables = NULL,
  daily.amounts = NULL,
  default.covariates = NULL,
  episodic.indicator.covariates = NULL,
  episodic.amount.covariates = NULL,
  daily.amount.covariates = NULL,
  individual.covariates = list(),
  default.intercept = TRUE,
  episodic.indicator.intercept = NULL,
  episodic.amount.intercept = NULL,
  daily.amount.intercept = NULL,
  individual.intercept = list(),
  never.consumer.variable = NULL,
  never.consumer.indicator = NULL,
  never.consumer.amount = NULL,
  never.consumer.covariates = NULL,
  never.consumer.intercept = TRUE,
  mcmc.seed = NULL,
  num.mcmc.iterations = 12000,
  num.burn = 2000,
  num.post = 0,
  num.thin = 25,
  sigma.u.prior = NULL,
  sigma.u.constant = FALSE,
  save.u.main = FALSE,
  save.all.u = FALSE,
  do.log.likelihood = FALSE,
  log.file.name = NULL,
  log.threshold = 1,
  log.to.console = TRUE
)
}
\arguments{
\item{pre.mcmc.data}{A list or \code{nci.multivar.preprocessor} object with the
following elements:
\itemize{
\item mcmc.input: A data frame with all variables needed for the MCMC model.
\item backtransformation: A data frame with the following columns:
\itemize{
\item variable: The name of the variable.
\item tran_lambda: The value of the lambda used to transform the variable.
\item minamount: Half of the minimum non-zero value of the variable.
\item tran_center: The mean of the Box-Cox transformed variable before standardization.
\item tran_scale: The standard deviation of the Box-Cox transformed variable before standardization divided by \code{sqrt(2)}.
\item biomarker: Flag indicating whether the variable is a biomarker assumed to be unbiased on the transformed scale.
}
}}

\item{id}{Variable that identifies each subject.}

\item{weight}{Variable with weighting for each subject.}

\item{repeat.obs}{Variable that distinguishes repeat observations for each
subject.}

\item{episodic.variables}{Vector of episodic variables.}

\item{episodic.indicators}{Vector of consumption indicators for episodic
variables. Not needed if \code{pre.mcmc.data} is an\code{nci.multivar.preprocessor}
object.}

\item{episodic.amounts}{Vector of consumption amount variables for episodic
variables. Not needed if \code{pre.mcmc.data} is an \code{nci.multivar.preprocessor}
object.}

\item{daily.variables}{Vector of daily variables.}

\item{daily.amounts}{Vector of consumption amount variables for daily
variables. Not needed if \code{pre.mcmc.data} is an \code{nci.multivar.preprocessor}
object.}

\item{default.covariates}{Vector of covariates to be used for episodic
indicators, episodic amounts, and daily amounts. Does not affect the
never-consumer model if present.}

\item{episodic.indicator.covariates}{Vector of covariates to be used for
episodic indicators. If specified, overwrites \code{default.covariates} for
episodic indicators.}

\item{episodic.amount.covariates}{Vector of covariates to be used for
episodic amounts. If specified, overwrites \code{default.covariates} for
episodic amounts.}

\item{daily.amount.covariates}{Vector of covariates to be used for daily
amounts. If specified, overwrites \code{default.covariates} for daily amounts.}

\item{individual.covariates}{Named list of vectors of covariates to be used
for individual indicators and amounts. Each name is the indicator or amount
that the covariate list will be used for. Overrides \code{default.covariates},
\code{episodic.indicator.covariates}, \code{episodic.amount.covariates}, and
\code{daily.amount.covariates} for each named variable.}

\item{default.intercept}{Flag to include an intercept in the models for
episodic indicators, episodic amounts, and daily amounts. Does not affect
the never-consumer model if present. (default = \code{TRUE})}

\item{episodic.indicator.intercept}{Flag to include an intercept in the model
for episodic indicators. If specified, overwrites \code{default.intercept} for
episodic indicators.}

\item{episodic.amount.intercept}{Flag to include an intercept in the model
for episodic amounts. If specified, overwrites \code{default.intercept} for
episodic amounts.}

\item{daily.amount.intercept}{Flag to include an intercept in the model for
daily amounts. If specified, overwrites \code{default.intercept} for daily
amounts.}

\item{individual.intercept}{Named list of flags to include intercepts in the
model for individual indicators and amounts. Each name is the indicator or
amount that the intercept will be used for. Overrides \code{default.intercept},
\code{episodic.indicator.intercept}, \code{episodic.amount.intercept}, and
\code{daily.amount.intercept} for each named variable.}

\item{never.consumer.variable}{One episodic variable to allow
never-consumers. Can be a variable already listed as episodic or a new
variable.}

\item{never.consumer.indicator}{Consumption indicator variable for the
never-consumer variable. Not needed if \code{pre.mcmc.data} is an
\code{nci.multivar.preprocessor} object.}

\item{never.consumer.amount}{Consumption amount variable for the
never-consumer variable. Not needed if \code{pre.mcmc.data} is an
\code{nci.multivar.preprocessor} object.}

\item{never.consumer.covariates}{Vector of covariates to be used for the
never-consumer model. Not affected by \code{default.covariates} and must be
specified separately.}

\item{never.consumer.intercept}{Flag to include intercept in the
never-consumer model. Not affected by \code{default.intercept} and must be
specified separately. (default = \code{TRUE})}

\item{mcmc.seed}{Integer starting seed for the random number generator. If
\code{NULL}, uses a randomly generated integer from -10^7 to 10^7, exclusive.
(default = \code{NULL})}

\item{num.mcmc.iterations}{Integer specifying the total number (including
burn-in) of iterations in the MCMC chain. (default = \code{12000})}

\item{num.burn}{Integer specifying the number of burn-in iterations in the
MCMC chain. Must be smaller than \code{num.mcmc.iterations}. (default = \code{2000})}

\item{num.post}{Integer specifying the number of random effect ('u') matrix
draws done after the MCMC chain is finished, conditional on the posterior
mean of the parameters. Used for regression calibration, see "Regression
Calibration". (default = \code{0})}

\item{num.thin}{Integer specifying the number of iterations between MCMC
samples used for calculating posterior means. (default = \code{25})}

\item{sigma.u.prior}{Matrix specifying a prior covariance matrix for the
random effects ('u'). Must be a valid covariance matrix with dimensions
equal to the total number of episodic indicators, episodic amounts, and
daily amounts.}

\item{sigma.u.constant}{Flag specifying if the covariance matrix of the
random effects ('u') should remain the same for each iteration (default =
\code{FALSE}).}

\item{save.u.main}{Flag specifying if random effects ('u') matrices should be
saved from the main MCMC chain. If \code{TRUE}, saves 'u' matrix every
\code{num.thin} iterations after \code{num.burn}. This is used for fitting models
with techniques such as multiple imputation. Does not affect conditional
'u' matrices drawn after the MCMC chain. (default = \code{FALSE})}

\item{save.all.u}{Flag specifying if random effects ('u') matrices are saved
for every iteration. Greatly increases disk space needed to store output
object. Has no effect if \code{save.u.main} is FALSE. (default = \code{FALSE})}

\item{do.log.likelihood}{Flag specifying if an estimate of the log-likelihood
should be calculated after the MCMC chain has finished. See the
'Log-likelihood' section for details. (default = \code{FALSE})}

\item{log.file.name}{Name of the file to log notes, warnings, and errors. If
\code{NULL}, no log file will be output. (default = \code{NULL})}

\item{log.threshold}{Integer specifying which messages to output to the log:
\itemize{
\item 1: All notes, warnings, and errors (default)
\item 2: Only warnings and errors
\item 3: Only errors
}}

\item{log.to.console}{Flag specifying whether log messages should be printed
to the R console in addition to the log file (default = \code{TRUE}).}
}
\value{
An \code{nci.multivar.mcmc} object with the following elements:
\itemize{
\item log.likelihood: The estimated marginal log-likelihood of the model, \code{NA} if \code{do.log.likelihood} is FALSE.
\item beta: Fixed effect coefficients at every MCMC iteration.
\item sigma.u: Random effect covariance matrix at every MCMC iteration.
\item sigma.e: Residual error covariance matrix at every MCMC iteration.
\item alpha1: Coefficients of never-consumer model at every MCMC iteration, NULL if no variables allow never-consumers.
\item consumer.probabilities: Probability that each subject is a consumer of the never-variable at every MCMC iteration, NULL if no variables allow never-consumers.
\item u.matrices.main: Random effect ('u') matrices saved from the main MCMC chain.
\item u.matrices.post: Random effect ('u') matrices drawn after the MCMC chain conditional on the posterior means of the parameters.
\item mcmc.subjects: Vector of subject IDs for each unique subject in the data.
\item subject.weighting: Vector of Weighting of each unique subject in the data.
\item num.episodic: Number of episodic variables in the model.
\item num.daily: Number of daily variables in the model.
\item num.trace: Number of main chain MCMC traces saved.
\item num.mcmc.iterations: Total number of iterations in the MCMC chain including burn-in, same as \code{num.mcmc.iterations} parameter.
\item num.burn: Number of burn-in iterations that will be discarded when calculating posterior means, same as \code{num.burn} parameter.
\item num.thin: Number of iterations between MCMC samples used for calculating posterior means, same as \code{num.thin} parameter.
\item num.post: Number of 'u' matrices drawn after the MCMC chain conditional on the posterior means of the parameters, same as \code{num.post} parameter.
\item saved.u.main: Numeric vector of MCMC iterations that have saved 'u' matrices, \code{NULL} if no main MCMC chain 'u' matrices are saved.
\item backtransformation: A data frame with metadata for variable backtransformation, same as \code{backtransformation} element of the \code{pre.mcmc.data} parameter.
\item episodic.variables: Episodic variables used in the model. The never-consumer variable (if any) is always first.
\item episodic.indicators: Indicators for episodic variables in the model. The indicator for the never-consumer variable (if any) is always first.
\item episodic.amounts: Standardized consumption amounts for episodic variables in the model. The amount for the never-consumer variable (if any) is always first.
\item daily.variables: Daily variables used in the model.
\item daily.amounts: Standardized consumption amounts for daily variables in the model.
\item covariates: List of vectors of names of covariates for each indicator and amount.
\item intercepts: List of flags for whether an intercept is included for each indicator and amount.
\item never.consumers.first.episodic: Flag for whether a variable with never-consumers allowed was specified.
\item never.consumer.covariates: Vector of names of covariates for never-consumer model, \code{NULL} if never-consumers are not present.
\item never.consumer.intercept: Flag for whether an intercept is included in the never-consumer model, \code{NULL} if never-consumers are not present.

The object also contains the following attribute:
\item mcmc.seed: The random number generator seed used to generate the results, see the \code{mcmc.seed} parameter for details.
}
}
\description{
Fits a measurement error model for one or more episodic and/or
daily variables using an MCMC method.
}
\section{About the model}{
 The model fit by this function is a multivariate
mixed-effects model with fixed effects ('beta') and a random intercept for
each variable ('u'). Each daily variable has a single continuous outcome
variable for the amount consumed. Each episodic variable has two model
parts, a binary indicator of consumption and a continuous variable for
amount consumed. A probit link function is used for modeling the binary
indicator. The parts of the model (daily amounts, episodic indicators, and
episodic amounts) can have separate covariate lists. The random intercepts
are assumed to have multivariate Gaussian distribution with covariance
matrix 'Sigma-u'. The residual error is also assumed to have a multivariate
Gaussian distribution with covariance matrix 'Sigma-e'.
}

\section{MCMC procedure}{
 The model is fit using a Gibbs sampler MCMC
procedure. At each iteration, each parameter is updated sequentially using
its distribution conditional on the other parameters. The conditional
distributions and priors are outlined in Zhang, et al. (2011). After a
specified burn-in period, subsequent samples of each parameter are averaged
to calculate a posterior mean. The posterior means are the point estimates
for the parameters. To ensure that the samples used to calculated the
posterior mean are independent, the samples can be 'thinned'. For example,
a thinning number of 5 means that every 5th sample after the burn-in period
is used to calculate the posterior mean. When doing regression calibration,
additional draws of the random intercept ('u') matrix can be made
conditional on the posterior means of beta, Sigma-u, and Sigma-e. This is
useful when performing measurement error correction with regression
calibration.
}

\section{Never-consumers}{
 The model can allow some subjects to be
never-consumers of one episodic variable. If an episodic variable with
never-consumers is specified, then the probability that each subject has
any consumption is included as an additional part of the model for that
variable. As with the other model parts, the never-consumer part of the
model has its own covariate matrix and coefficients. To distiguish the
coefficients from the regular fixed effect coefficients, they are referred
to as 'alpha1'. Only one variable can be allowed to have never-consumers.
}

\section{Log-likelihood}{
 An estimate of the log-likelihood marginalized over
the random effects ('u') can be output after the MCMC iterations have
finished. The random effects are integrated out using the Laplace
approximation. The posterior mode of the random effects is found by the
BFGS algorithm with derivatives approximated by the central difference
method. Since the model is fit using an MCMC method, the marginal
log-likelihood is never used in fitting the model. The log-likelihood
output by this function corresponds well to the log-likelihood found by
maximum likelihood for univariate and bivariate models. For
higher-dimensional models and models allowing never-consumers that cannot
be fit using maximum likelihood, the estimated likelihood is experimental
and other measures of model fit should be considered. Estimating the
log-likelihood increases computation time, especially as the number of
variables increases.
}

\section{Regression Calibration}{
 The model fit by \code{nci_multivar_mcmc()} can
be used in regression calibration for measurement error correction. When
doing regression calibration, random effect ('u') matrices must be drawn
after the MCMC chain conditional on the posterior means of the parameters.
This can be done by setting \code{num.post} to the number of post-MCMC 'u' draws
to be made. Use \code{vignette("regression_calibration",
  package="ncimultivar")} for a full regression calibration workflow.
}

\examples{
#subset NHANES data
nhanes.subset <- nhcvd[nhcvd$SDMVSTRA \%in\% c(48, 60, 72),]

boxcox.sodium <- boxcox_survey(input.data=nhanes.subset,
                               row.subset=(nhanes.subset$DAY == 1),
                               variable="TSODI",
                               id="SEQN",
                               repeat.obs="DAY",
                               weight="WTDRD1",
                               covariates="RIDAGEYR")

boxcox.g.whole <- boxcox_survey(input.data=nhanes.subset,
                                row.subset=(nhanes.subset$DAY == 1),
                                variable="G_WHOLE",
                                is.episodic=TRUE,
                                id="SEQN",
                                repeat.obs="DAY",
                                weight="WTDRD1",
                                covariates="RIDAGEYR")

boxcox.lambda.data <- rbind(boxcox.sodium, boxcox.g.whole)

minimum.amount.data <- calculate_minimum_amount(input.data=nhanes.subset,
                                                row.subset=(nhanes.subset$DAY == 1),
                                                episodic.variables="G_WHOLE",
                                                daily.variables="TSODI")

pre.mcmc.data <- nci_multivar_preprocessor(input.data=nhanes.subset,
                                           episodic.variables="G_WHOLE",
                                           daily.variables="TSODI",
                                           continuous.covariates="RIDAGEYR",
                                           boxcox.lambda.data=boxcox.lambda.data,
                                           minimum.amount.data=minimum.amount.data)

mcmc.output <- nci_multivar_mcmc(pre.mcmc.data=pre.mcmc.data,
                                 id="SEQN",
                                 weight="WTDRD1",
                                 repeat.obs="DAY",
                                 episodic.variables="G_WHOLE",
                                 daily.variables="TSODI",
                                 default.covariates="std.RIDAGEYR",
                                 num.mcmc.iterations=1000,
                                 num.burn=500,
                                 num.thin=1)

names(mcmc.output)
}
