% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_gelman_rubin.R
\name{gelman_rubin}
\alias{gelman_rubin}
\title{Gelman-Rubin Test for MCMC Convergence}
\usage{
gelman_rubin(
  num.chains = 5,
  pre.mcmc.data,
  id,
  weight = NULL,
  repeat.obs,
  episodic.variables = NULL,
  episodic.indicators = NULL,
  episodic.amounts = NULL,
  daily.variables = NULL,
  daily.amounts = NULL,
  default.covariates = NULL,
  episodic.indicator.covariates = NULL,
  episodic.amount.covariates = NULL,
  daily.amount.covariates = NULL,
  individual.covariates = list(),
  default.intercept = TRUE,
  episodic.indicator.intercept = NULL,
  episodic.amount.intercept = NULL,
  daily.amount.intercept = NULL,
  individual.intercept = list(),
  never.consumer.variable = NULL,
  never.consumer.indicator = NULL,
  never.consumer.amount = NULL,
  never.consumer.covariates = NULL,
  never.consumer.intercept = TRUE,
  initial.mcmc.seed = NULL,
  num.mcmc.iterations = 12000,
  num.burn = 2000,
  num.thin = 25,
  sigma.u.prior = NULL,
  sigma.u.constant = FALSE
)
}
\arguments{
\item{num.chains}{Integer number of MCMC chains to run. (default = 5)}

\item{pre.mcmc.data}{A list or \code{nci.multivar.preprocessor} object with the
following elements:
\itemize{
\item mcmc.input: A data frame with all variables needed for the MCMC model.
\item backtransformation: A data frame with the following columns:
\itemize{
\item variable: The name of the variable.
\item tran_lambda: The value of the lambda used to transform the variable.
\item minamount: Half of the minimum non-zero value of the variable.
\item tran_center: The mean of the Box-Cox transformed variable before standardization.
\item tran_scale: The standard deviation of the Box-Cox transformed variable before standardization divided by \code{sqrt(2)}.
\item biomarker: Flag indicating whether the variable is a biomarker assumed to be unbiased on the transformed scale.
}
}}

\item{id}{Variable that identifies each subject.}

\item{weight}{Variable with weighting for each subject.}

\item{repeat.obs}{Variable that distinguishes repeat observations for each
subject.}

\item{episodic.variables}{Vector of episodic variables.}

\item{episodic.indicators}{Vector of consumption indicators for episodic
variables. Not needed if \code{pre.mcmc.data} is an\code{nci.multivar.preprocessor}
object.}

\item{episodic.amounts}{Vector of consumption amount variables for episodic
variables. Not needed if \code{pre.mcmc.data} is an \code{nci.multivar.preprocessor}
object.}

\item{daily.variables}{Vector of daily variables.}

\item{daily.amounts}{Vector of consumption amount variables for daily
variables. Not needed if \code{pre.mcmc.data} is an \code{nci.multivar.preprocessor}
object.}

\item{default.covariates}{Vector of covariates to be used for episodic
indicators, episodic amounts, and daily amounts. Does not affect the
never-consumer model if present.}

\item{episodic.indicator.covariates}{Vector of covariates to be used for
episodic indicators. If specified, overwrites \code{default.covariates} for
episodic indicators.}

\item{episodic.amount.covariates}{Vector of covariates to be used for
episodic amounts. If specified, overwrites \code{default.covariates} for
episodic amounts.}

\item{daily.amount.covariates}{Vector of covariates to be used for daily
amounts. If specified, overwrites \code{default.covariates} for daily amounts.}

\item{individual.covariates}{Named list of vectors of covariates to be used
for individual indicators and amounts. Each name is the indicator or amount
that the covariate list will be used for. Overrides \code{default.covariates},
\code{episodic.indicator.covariates}, \code{episodic.amount.covariates}, and
\code{daily.amount.covariates} for each named variable.}

\item{default.intercept}{Flag to include an intercept in the models for
episodic indicators, episodic amounts, and daily amounts. Does not affect
the never-consumer model if present. (default = \code{TRUE})}

\item{episodic.indicator.intercept}{Flag to include an intercept in the model
for episodic indicators. If specified, overwrites \code{default.intercept} for
episodic indicators.}

\item{episodic.amount.intercept}{Flag to include an intercept in the model
for episodic amounts. If specified, overwrites \code{default.intercept} for
episodic amounts.}

\item{daily.amount.intercept}{Flag to include an intercept in the model for
daily amounts. If specified, overwrites \code{default.intercept} for daily
amounts.}

\item{individual.intercept}{Named list of flags to include intercepts in the
model for individual indicators and amounts. Each name is the indicator or
amount that the intercept will be used for. Overrides \code{default.intercept},
\code{episodic.indicator.intercept}, \code{episodic.amount.intercept}, and
\code{daily.amount.intercept} for each named variable.}

\item{never.consumer.variable}{One episodic variable to allow
never-consumers. Can be a variable already listed as episodic or a new
variable.}

\item{never.consumer.indicator}{Consumption indicator variable for the
never-consumer variable. Not needed if \code{pre.mcmc.data} is an
\code{nci.multivar.preprocessor} object.}

\item{never.consumer.amount}{Consumption amount variable for the
never-consumer variable. Not needed if \code{pre.mcmc.data} is an
\code{nci.multivar.preprocessor} object.}

\item{never.consumer.covariates}{Vector of covariates to be used for the
never-consumer model. Not affected by \code{default.covariates} and must be
specified separately.}

\item{never.consumer.intercept}{Flag to include intercept in the
never-consumer model. Not affected by \code{default.intercept} and must be
specified separately. (default = \code{TRUE})}

\item{initial.mcmc.seed}{Numeric starting seed for the random number
generator. If specified, the seed will be incremented for each MCMC
replicate. If \code{NULL}, uses a randomly generated integer from -10^7 to 10^7,
exclusive for each replicate. (default = \code{NULL})}

\item{num.mcmc.iterations}{Integer specifying the total number (including
burn-in) of iterations in the MCMC chain. (default = \code{12000})}

\item{num.burn}{Integer specifying the number of burn-in iterations in the
MCMC chain. Must be smaller than \code{num.mcmc.iterations}. (default = \code{2000})}

\item{num.thin}{Integer specifying the number of iterations between MCMC
samples used for calculating posterior means. (default = \code{25})}

\item{sigma.u.prior}{Matrix specifying a prior covariance matrix for the
random effects ('u'). Must be a valid covariance matrix with dimensions
equal to the total number of episodic indicators, episodic amounts, and
daily amounts.}

\item{sigma.u.constant}{Flag specifying if the covariance matrix of the
random effects ('u') should remain the same for each iteration (default =
\code{FALSE}).}
}
\value{
A numeric vector of Gelman-Rubin statistics for each MCMC parameter.
}
\description{
Tests an MCMC model specification for convergence using the
Gelman-Rubin test. A model is fit multiple times with the specified
parameters using different random seeds each time.
}
\details{
The Gelman-Rubin test works by creating multiple MCMC chains with
different random seeds and calculating the within-chain and between-chain
variation (Gelman and Rubin, 1992). If the model parameters converge, there
should be little to no difference between different chains which will cause
the between-chain variance to fall to zero. This means that convergence can
be assessed by comparing the total variance of the model parameters to the
within-chain variance.

The Gelman-Rubin statistic is the square root of the ratio between the
total variance and the within-chain variance of a parameter. If the
Gelman-Rubin statistic is close to 1, then the model has converged for that
parameter. A cutoff of 1.1 for convergence is suggested by Gelman, et al.
(2004).
}
\examples{
#' #subset NHANES data
nhanes.subset <- nhcvd[nhcvd$SDMVSTRA \%in\% c(48, 60, 72),]

boxcox.lambda.data <- boxcox_survey(input.data=nhanes.subset,
                                    row.subset=(nhanes.subset$DAY == 1),
                                    variable="TSODI",
                                    id="SEQN",
                                    repeat.obs="DAY",
                                    weight="WTDRD1",
                                    covariates="RIDAGEYR")

minimum.amount.data <- calculate_minimum_amount(input.data=nhanes.subset,
                                                row.subset=(nhanes.subset$DAY == 1),
                                                daily.variables="TSODI")

pre.mcmc.data <- nci_multivar_preprocessor(input.data=nhanes.subset,
                                           daily.variables="TSODI",
                                           continuous.covariates="RIDAGEYR",
                                           boxcox.lambda.data=boxcox.lambda.data,
                                           minimum.amount.data=minimum.amount.data)

gr.statistics <- gelman_rubin(num.chains=5,
                              pre.mcmc.data=pre.mcmc.data,
                              id="SEQN",
                              weight="WTDRD1",
                              repeat.obs="DAY",
                              daily.variables="TSODI",
                              default.covariates="std.RIDAGEYR",
                              num.mcmc.iterations=1000,
                              num.burn=500,
                              num.thin=1)

gr.statistics
}
