% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhanes_utilities.R
\name{fix_nhanes_strata}
\alias{fix_nhanes_strata}
\title{Fix NHANES Strata for BRR}
\usage{
fix_nhanes_strata(input.data)
}
\arguments{
\item{input.data}{A data.frame with NHANES data. It must contain the
following variables:
\itemize{
\item SDMVSTRA: Strata
\item SDMVPSU: Primary Sampling Unit (PSU)
}}
}
\value{
A data.frame identical to \code{input.data} with \code{SDMVPSU} modified so
that selected strata have exactly 2 PSUs.
}
\description{
Corrects specific NHANES strata that do not have exactly 2
primary sampling units (PSUs) so that balanced repeated replication (BRR)
weights can be generated for the data.
}
\details{
Some NHANES cycles have strata that contain 3 primary sampling units
(PSUs). Since balanced repeated replication (BRR) requires exactly 2 PSUs
for all strata, PSUs in these strata must be reconfigured for BRR to be
used. This function corrects specific NHANES strata that have 3 PSUs. Two
of the three PSUs in each of the strata to be corrected were randomly
selected to be combined. the If the function detects other strata that it
was not able to correct, a warning is given to the user.

This function currently corrects the following strata/PSU combinations:
\itemize{
\item SDMVSTRA = 1, Combine SDMVPSU 1 and 2
\item SDMVSTRA = 86, Combine SDMVPSU 2 and 3
\item SMDVSTRA = 90, Combine SDMVPSU 2 and 3
\item SMDVSTRA = 91, Combine SDMVPSU 1 and 3
\item SDMVSTRA = 92, Combine SDMVPSU 2 and 3
\item SDMVSTRA = 156, Combine SDMVPSU 1 and 3
}
}
\examples{
nhanes.data <- fix_nhanes_strata(nhcvd)
}
