% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_parameters.R
\name{extract_parameters}
\alias{extract_parameters}
\title{Extract NCI Multivar MCMC Parameters}
\usage{
extract_parameters(multivar.mcmc.model)
}
\arguments{
\item{multivar.mcmc.model}{An \code{nci.multivar.mcmc} object.}
}
\value{
A list with the following elements:
\itemize{
\item mean: A named vector of posterior means for each MCMC parameter.
\item covariance: A matrix of variances and covariances for each pair of MCMC parameters.
}
}
\description{
Extract posterior means and covariances from an
\code{nci.multivar.mcmc} object.
}
\details{
This function calculates the posterior means and covariances of
parameters using the MCMC samples in an \code{nci.multivar.mcmc} object. Means
and covariances are calculated for the fixed effect coefficients ('beta'),
random effect covariance ('Sigma-u'), and residual error covariance
('Sigma-e') for all models. For models allowing never-consumers, the
never-consumer model coefficients ('alpha1') and mean consumer probability
are also included. The calculations use samples after the burn-in period,
spaced apart by the thinning number. It is important to note that the
covariance matrix returned by this function is the covariance matrix of the
Monte Carlo process, and it is distinct from the covariances that would be
found from replication techniques such as bootstrap or BRR.
}
\examples{
#subset NHANES data
nhanes.subset <- nhcvd[nhcvd$SDMVSTRA \%in\% c(48, 60, 72),]

boxcox.lambda.data <- boxcox_survey(input.data=nhanes.subset,
                                    row.subset=(nhanes.subset$DAY == 1),
                                    variable="TSODI",
                                    id="SEQN",
                                    repeat.obs="DAY",
                                    weight="WTDRD1",
                                    covariates="RIDAGEYR")

minimum.amount.data <- calculate_minimum_amount(input.data=nhanes.subset,
                                                row.subset=(nhanes.subset$DAY == 1),
                                                daily.variables="TSODI")

pre.mcmc.data <- nci_multivar_preprocessor(input.data=nhanes.subset,
                                           daily.variables="TSODI",
                                           continuous.covariates="RIDAGEYR",
                                           boxcox.lambda.data=boxcox.lambda.data,
                                           minimum.amount.data=minimum.amount.data)

mcmc.output <- nci_multivar_mcmc(pre.mcmc.data=pre.mcmc.data,
                                 id="SEQN",
                                 weight="WTDRD1",
                                 repeat.obs="DAY",
                                 daily.variables="TSODI",
                                 default.covariates="std.RIDAGEYR",
                                 num.mcmc.iterations=1000,
                                 num.burn=500,
                                 num.thin=1)

mcmc.parameters <- extract_parameters(mcmc.output)

#posterior means
mcmc.parameters$mean

#posterior covariance matrix
mcmc.parameters$covariance
}
