% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_parameters.R
\name{draw_parameters}
\alias{draw_parameters}
\title{Draw Parameter Samples from an MCMC Chain}
\usage{
draw_parameters(multivar.mcmc.model, num.draws = 10, draw.spacing = NULL)
}
\arguments{
\item{multivar.mcmc.model}{An \code{nci.multivar.mcmc} object.}

\item{num.draws}{An integer specifying the number of parameter samples to
draw from the MCMC chain. (default = \code{10})}

\item{draw.spacing}{An integer specifying the number of iterations between
samples. If \code{NULL}, defaults to 5 times the thinning value of
\code{multivar.mcmc.model}. (default = \code{NULL})}
}
\value{
A list of parameter samples as separate \code{nci.multivar.mcmc} objects.
}
\description{
This function extracts samples of model parameters from an MCMC
chain at a specified interval.
}
\details{
Drawing parameter values from an MCMC chain after the burn-in period
is equivalent to drawing from the parameters' posterior distribution. The
variation in the MCMC chain is used to sample different parameter values as
opposed to finding a covariance matrix. Using the MCMC chain has the
advantage of using the actual posterior distribution of the parameters
instead of making an assumption. Accurately sampling parameter values is
required for measurement error correction methods such as multiple
imputation.

The function starts by drawing the parameter set from the first iteration
after burn-in, and then draws parameter sets every \code{draw.spacing}
iterations until \code{num.draws} sets have been drawn. If random effects ('u')
matrices from the main MCMC chain are saved, \code{draw.spacing} must be a
multiple of the original thinning value of \code{multivar.mcmc.model}.
}
\examples{
#subset NHANES data
nhanes.subset <- nhcvd[nhcvd$SDMVSTRA \%in\% c(50, 51, 52),]

boxcox.lambda.data <- boxcox_survey(input.data=nhanes.subset,
                                    row.subset=(nhanes.subset$DAY == 1),
                                    variable="TSODI",
                                    id="SEQN",
                                    repeat.obs="DAY",
                                    weight="WTDRD1",
                                    covariates="RIDAGEYR")

minimum.amount.data <- calculate_minimum_amount(input.data=nhanes.subset,
                                                row.subset=(nhanes.subset$DAY == 1),
                                                daily.variables="TSODI")

pre.mcmc.data <- nci_multivar_preprocessor(input.data=nhanes.subset,
                                           daily.variables="TSODI",
                                           continuous.covariates="RIDAGEYR",
                                           boxcox.lambda.data=boxcox.lambda.data,
                                           minimum.amount.data=minimum.amount.data)

mcmc.output <- nci_multivar_mcmc(pre.mcmc.data=pre.mcmc.data,
                                 id="SEQN",
                                 weight="WTDRD1",
                                 repeat.obs="DAY",
                                 daily.variables="TSODI",
                                 default.covariates="std.RIDAGEYR",
                                 num.mcmc.iterations=1000,
                                 num.burn=500,
                                 num.thin=1)

parameter.samples <- draw_parameters(multivar.mcmc.model=mcmc.output,
                                     num.draws=10)

#first three parameter samples
parameter.samples[[1]]$beta
parameter.samples[[1]]$sigma.u
parameter.samples[[1]]$sigma.e

parameter.samples[[2]]$beta
parameter.samples[[2]]$sigma.u
parameter.samples[[2]]$sigma.e

parameter.samples[[3]]$beta
parameter.samples[[3]]$sigma.u
parameter.samples[[3]]$sigma.e
}
