% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_covariate_test.R
\name{covariate_test}
\alias{covariate_test}
\title{Significance Testing for MCMC Covariates}
\usage{
covariate_test(
  pre.mcmc.data,
  id,
  repeat.obs,
  base.weight = NULL,
  episodic.variables = NULL,
  episodic.indicators = NULL,
  episodic.amounts = NULL,
  daily.variables = NULL,
  daily.amounts = NULL,
  default.covariates = NULL,
  episodic.indicator.covariates = NULL,
  episodic.amount.covariates = NULL,
  daily.amount.covariates = NULL,
  individual.covariates = list(),
  default.intercept = TRUE,
  episodic.indicator.intercept = NULL,
  episodic.amount.intercept = NULL,
  daily.amount.intercept = NULL,
  individual.intercept = list(),
  never.consumer.variable = NULL,
  never.consumer.indicator = NULL,
  never.consumer.amount = NULL,
  never.consumer.covariates = NULL,
  never.consumer.intercept = TRUE,
  initial.mcmc.seed = NULL,
  num.mcmc.iterations = 12000,
  num.burn = 2000,
  num.thin = 25,
  sigma.u.prior = NULL,
  sigma.u.constant = FALSE,
  rep.weights,
  brr = FALSE,
  fay.factor = 1,
  df,
  test.covariates
)
}
\arguments{
\item{pre.mcmc.data}{A list or \code{nci.multivar.preprocessor} object with the
following elements:
\itemize{
\item mcmc.input: A data frame with all variables needed for the MCMC model.
\item backtransformation: A data frame with the following columns:
\itemize{
\item variable: The name of the variable.
\item tran_lambda: The value of the lambda used to transform the variable.
\item minamount: Half of the minimum non-zero value of the variable.
\item tran_center: The mean of the Box-Cox transformed variable before standardization.
\item tran_scale: The standard deviation of the Box-Cox transformed variable before standardization divided by \code{sqrt(2)}.
\item biomarker: Flag indicating whether the variable is a biomarker assumed to be unbiased on the transformed scale.
}
}}

\item{id}{Variable that identifies each subject.}

\item{repeat.obs}{Variable that distinguishes repeat observations for each
subject.}

\item{base.weight}{Variable with the original weighting for each subject.}

\item{episodic.variables}{Vector of episodic variables.}

\item{episodic.indicators}{Vector of consumption indicators for episodic
variables. Not needed if \code{pre.mcmc.data} is an\code{nci.multivar.preprocessor}
object.}

\item{episodic.amounts}{Vector of consumption amount variables for episodic
variables. Not needed if \code{pre.mcmc.data} is an \code{nci.multivar.preprocessor}
object.}

\item{daily.variables}{Vector of daily variables.}

\item{daily.amounts}{Vector of consumption amount variables for daily
variables. Not needed if \code{pre.mcmc.data} is an \code{nci.multivar.preprocessor}
object.}

\item{default.covariates}{Vector of covariates to be used for episodic
indicators, episodic amounts, and daily amounts. Does not affect the
never-consumer model if present.}

\item{episodic.indicator.covariates}{Vector of covariates to be used for
episodic indicators. If specified, overwrites \code{default.covariates} for
episodic indicators.}

\item{episodic.amount.covariates}{Vector of covariates to be used for
episodic amounts. If specified, overwrites \code{default.covariates} for
episodic amounts.}

\item{daily.amount.covariates}{Vector of covariates to be used for daily
amounts. If specified, overwrites \code{default.covariates} for daily amounts.}

\item{individual.covariates}{Named list of vectors of covariates to be used
for individual indicators and amounts. Each name is the indicator or amount
that the covariate list will be used for. Overrides \code{default.covariates},
\code{episodic.indicator.covariates}, \code{episodic.amount.covariates}, and
\code{daily.amount.covariates} for each named variable.}

\item{default.intercept}{Flag to include an intercept in the models for
episodic indicators, episodic amounts, and daily amounts. Does not affect
the never-consumer model if present. (default = \code{TRUE})}

\item{episodic.indicator.intercept}{Flag to include an intercept in the model
for episodic indicators. If specified, overwrites \code{default.intercept} for
episodic indicators.}

\item{episodic.amount.intercept}{Flag to include an intercept in the model
for episodic amounts. If specified, overwrites \code{default.intercept} for
episodic amounts.}

\item{daily.amount.intercept}{Flag to include an intercept in the model for
daily amounts. If specified, overwrites \code{default.intercept} for daily
amounts.}

\item{individual.intercept}{Named list of flags to include intercepts in the
model for individual indicators and amounts. Each name is the indicator or
amount that the intercept will be used for. Overrides \code{default.intercept},
\code{episodic.indicator.intercept}, \code{episodic.amount.intercept}, and
\code{daily.amount.intercept} for each named variable.}

\item{never.consumer.variable}{One episodic variable to allow
never-consumers. Can be a variable already listed as episodic or a new
variable.}

\item{never.consumer.indicator}{Consumption indicator variable for the
never-consumer variable. Not needed if \code{pre.mcmc.data} is an
\code{nci.multivar.preprocessor} object.}

\item{never.consumer.amount}{Consumption amount variable for the
never-consumer variable. Not needed if \code{pre.mcmc.data} is an
\code{nci.multivar.preprocessor} object.}

\item{never.consumer.covariates}{Vector of covariates to be used for the
never-consumer model. Not affected by \code{default.covariates} and must be
specified separately.}

\item{never.consumer.intercept}{Flag to include intercept in the
never-consumer model. Not affected by \code{default.intercept} and must be
specified separately. (default = \code{TRUE})}

\item{initial.mcmc.seed}{Numeric starting seed for the random number
generator. If specified, the seed will be incremented for each MCMC
replicate. If \code{NULL}, uses a randomly generated integer from -10^7 to 10^7,
exclusive for each replicate. (default = \code{NULL})}

\item{num.mcmc.iterations}{Integer specifying the total number (including
burn-in) of iterations in the MCMC chain. (default = \code{12000})}

\item{num.burn}{Integer specifying the number of burn-in iterations in the
MCMC chain. Must be smaller than \code{num.mcmc.iterations}. (default = \code{2000})}

\item{num.thin}{Integer specifying the number of iterations between MCMC
samples used for calculating posterior means. (default = \code{25})}

\item{sigma.u.prior}{Matrix specifying a prior covariance matrix for the
random effects ('u'). Must be a valid covariance matrix with dimensions
equal to the total number of episodic indicators, episodic amounts, and
daily amounts.}

\item{sigma.u.constant}{Flag specifying if the covariance matrix of the
random effects ('u') should remain the same for each iteration (default =
\code{FALSE}).}

\item{rep.weights}{Vector of variables with the replicate weights
for each subject.}

\item{brr}{Flag specifying whether replicate weights are for balanced
repeated replication (BRR). (default = \code{FALSE})}

\item{fay.factor}{Numeric between 0 and 1 specifying the Fay factor used to
generate the BRR weights used in the function. Applies only when \code{brr} is
\code{TRUE}. (default = \code{1})}

\item{df}{Integer specifying the number of degrees of freedom for Hotelling's
T^2 test.}

\item{test.covariates}{Vector of covariates to be tested.}
}
\value{
A single joint p-value for all of the covariates in
\code{test.covariates}.
}
\description{
Tests the significance of covariates in an MCMC model using
replication techniques.
}
\details{
The variance/covariance matrix of the beta parameters in the MCMC
model is found by fitting MCMC model replicates with bootstrap or balanced
repeated replication (BRR). The original weighting variable for the dataset
is given in \code{base.weight} and the replicate weighting variables are given
in \code{rep.weights}. For survey datasets that BRR is applicable to, BRR
weights can be generated by \code{\link[=brr_weights]{brr_weights()}}. When using BRR, the value of
\code{fay.factor} must match the Fay factor used to generate the weights.

The covariates to test are specified in \code{test.covariates}. Elements of
\code{test.covariates} that are not present in the model are ignored. The
\code{test.covariates} can include covariates from the episodic indicator,
episodic amount, and daily amount parts of the model. This function does
not test never-consumer covariates.

The \code{df} parameter is the number of degrees of freedom to use for the
Hotelling's t-squared test. For survey datasets, this is the total number
of PSUs across all strata minus the number of strata.
}
\examples{
#subset NHANES data
nhanes.subset <- nhcvd[nhcvd$SDMVSTRA \%in\% c(48, 60, 72),]

#generate BRR weights for the dataset
brr.data <- brr_weights(input.data=nhanes.subset,
                        id="SEQN",
                        strata="SDMVSTRA",
                        psu="SDMVPSU",
                        cell="PSCELL",
                        weight="WTDRD1",
                        fay.factor=0.7)

boxcox.lambda.data <- boxcox_survey(input.data=brr.data,
                                    row.subset=(brr.data$DAY == 1),
                                    variable="TSODI",
                                    id="SEQN",
                                    repeat.obs="DAY",
                                    weight="RepWt_0",
                                    covariates="RIDAGEYR")

minimum.amount.data <- calculate_minimum_amount(input.data=brr.data,
                                                row.subset=(brr.data$DAY == 1),
                                                daily.variables="TSODI")

pre.mcmc.data <- nci_multivar_preprocessor(input.data=brr.data,
                                           daily.variables="TSODI",
                                           continuous.covariates="RIDAGEYR",
                                           boxcox.lambda.data=boxcox.lambda.data,
                                           minimum.amount.data=minimum.amount.data)

#testing whether age is significant in the model for sodium
df <- length(unique(brr.data$SDMVSTRA))
pval.age <- covariate_test(pre.mcmc.data=pre.mcmc.data,
                           id="SEQN",
                           repeat.obs="DAY",
                           base.weight="RepWt_0",
                           daily.variables="TSODI",
                           default.covariates="std.RIDAGEYR",
                           num.mcmc.iterations=1000,
                           num.burn=500,
                           num.thin=1,
                           rep.weights=paste0("RepWt_", 1:4),
                           brr=TRUE,
                           fay.factor=0.7,
                           df=df,
                           test.covariates="std.RIDAGEYR")
pval.age
}
