% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessor_functions.R
\name{calculate_minimum_amount}
\alias{calculate_minimum_amount}
\title{Find minimum consumption amounts}
\usage{
calculate_minimum_amount(
  input.data,
  row.subset = NULL,
  episodic.variables = NULL,
  daily.variables = NULL
)
}
\arguments{
\item{input.data}{A data frame.}

\item{row.subset}{Logical vector of the same length as \code{nrow(input.data)}
indicating which rows of \code{input.data} to use for calculating the minimum
amounts.}

\item{episodic.variables}{Vector of episodic variables.}

\item{daily.variables}{Vector of daily variables.}
}
\value{
A data frame with the following variables:
\itemize{
\item variable: The name of the variable.
\item minamount: Half of the minimum non-zero amount consumed for the variable.
}
}
\description{
Calculate minimum non-zero amount of each food and nutrient on
consumption days.
}
\details{
For each food and nutrient a minimum amount of consumption is set at
half of the smallest non-zero amount consumed. For nutrients, this amount
replaces zero values so that the Box-Cox transformation is valid. For both
foods and nutrients, the minimum amount is also used in
\code{\link[=nci_multivar_distrib]{nci_multivar_distrib()}} as a lower bound on the backtransformed amount
consumed.
}
\examples{
#subset NHANES data
nhanes.subset <- nhcvd[nhcvd$SDMVSTRA \%in\% c(48, 60, 72),]

minimum.amount.data <- calculate_minimum_amount(input.data=nhanes.subset,
                                                row.subset=(nhanes.subset$DAY == 1),
                                                episodic.variables="G_WHOLE",
                                                daily.variables="TSODI")
minimum.amount.data
}
