% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicate_weights.R
\name{brr_weights}
\alias{brr_weights}
\title{Generate BRR weights for a survey dataset}
\usage{
brr_weights(
  input.data,
  id,
  strata,
  psu,
  cell = NULL,
  weight = NULL,
  fay.factor = 1
)
}
\arguments{
\item{input.data}{A data frame.}

\item{id}{Variable that identifies each subject.}

\item{strata}{Variable that identifies the strata that an observation is in.}

\item{psu}{Variable that identifies which PSU within a strata that an
observation is in. There must be exactly two unique values of this variable
for each value of \code{strata}.}

\item{cell}{Variable that identifies which post-stratification cell that an
observation is in. Used to perform post-stratification adjustment of
replicate weights. If \code{NULL}, no post-stratification adjustment is
performed. (default = \code{NULL}).}

\item{weight}{Base weighting variable for the dataset. If \code{NULL}, all
observations are treated as having an equal weight of 1. (default = \code{NULL})}

\item{fay.factor}{A number between 0 and 1 that adjusts the weight of PSUs
for Fay's method. The default value of 1 performs standard BRR.}
}
\value{
A \code{data.frame} containing all of the variables in \code{input.data} plus
the following columns:
\itemize{
\item \code{RepWt_0}: The base weight.
\item \code{RepWt_1}-\code{RepWt_N}: BRR weights for replicates 1 to N.

Weights are integerized for compatibility with modeling functions.
}
}
\description{
This function creates balanced repeated replication (BRR)
weights for variance estimation in survey data.
}
\section{About BRR}{
 Balanced repeated replication (BRR) is a variance
estimation technique used for stratified survey data. Like ordinary
bootstrap, BRR uses a set of replicates resampled from the original data.
BRR differs from bootstrap in that BRR replicates are structured rather
than randomly sampled. In order for BRR to work properly, the survey data
must be structured so that each strata has exactly two primary sampling
units (PSUs). A Hadamard matrix is used to structure each replicate so that
one PSU from each strata is used per replicate. The size of the Hadamard
matrix determines the number of BRR replicate weights, and it is usually
close to the number of strata. This means that in BRR is often more
efficient than bootstrap in datasets where it can be used.
}

\section{Fay's method}{
 Standard BRR uses only half of the PSUs in the dataset
for each replicate. Fay's method uses the full dataset for each replicate
but adjusts the weighting of each PSU based on a value between 0 and 1
called the Fay factor 'f'. If a PSU would be taken out of the sample in
standard BRR, it is instead given a weight of 1 - f when using Fay's
method. Likewise, PSUs that would be kept in the sample are instead given a
weight of 1 + f. A Fay factor of 1 is equivalent to using standard BRR.
}

\section{Post-stratification}{
 The design of a survey study usually will have
expected proportions that different groups should have in the full
population. Post-stratification adjustment is used to adjust observation
weights so that the influence of each group (called a post-stratification
cell) in an analysis is proportional to the group's actual proportion in
the population.
}

\examples{
brr.data <- brr_weights(input.data=nhcvd,
                        id="SEQN",
                        strata="SDMVSTRA",
                        psu="SDMVPSU",
                        cell="PSCELL",
                        weight="WTDRD1",
                        fay.factor=0.7)

#base weight and first 8 BRR replicate weights
head(brr.data[,paste0("RepWt_", 0:8)])
}
