% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicate_weights.R
\name{boot_weights}
\alias{boot_weights}
\title{Generate bootstrap weights for a survey dataset}
\usage{
boot_weights(
  input.data,
  id,
  strata,
  psu,
  cell = NULL,
  weight = NULL,
  num.reps = 200,
  boot.seed = NULL
)
}
\arguments{
\item{input.data}{A data frame.}

\item{id}{Variable that identifies each subject.}

\item{strata}{Variable that identifies the strata that an observation is in.}

\item{psu}{Variable that identifies which PSU within a strata that an
observation is in.}

\item{cell}{Variable that identifies which post-stratification cell that an
observation is in. Used to perform post-stratification adjustment of
replicate weights. If \code{NULL}, no post-stratification adjustment is
performed. (default = \code{NULL}).}

\item{weight}{Base weighting variable for the dataset. If \code{NULL}, all
observations are treated as having an equal weight of 1. (default = \code{NULL})}

\item{num.reps}{Number of bootstrap replicate weights. (default = 200).}

\item{boot.seed}{Integer starting seed for the random number generator. If
\code{NULL}, uses a randomly generated integer from -10^7 to 10^7, exclusive.
(default = \code{NULL})}
}
\value{
A \code{data.frame} containing all of the variables in \code{input.data} plus
the following columns:
\itemize{
\item \code{RepWt_0}: The base weight.
\item \code{RepWt_1}-\code{RepWt_N}: BRR weights for replicates 1 to N.

Weights are integerized for compatibility with modeling functions.

The output also contains the following attribute:
\item \code{boot.seed}: The random number generator seed used to generate the replicate weights.
}
}
\description{
This function creates bootstrap weights for variance estimation
in survey data.
}
\section{About Bootstrap}{
 Bootstrapping is a resampling technique that can be
used for variance estimation in survey data. Each bootstrap replicate
weight set is equivalent to sampling the primary sampling units (PSUs) in
the original dataset with replacement. The strata can have an arbitrary
number of PSUs within them. Often, each individual subject is treated as
its own PSU. Many replicates need to be performed to provide accurate
estimates of the variance. In practice, this is generally around 200-500
replicates. The ideal number can vary depending on the dataset, and survey
datasets will sometimes specify how many bootstrap replicates are
recommended.
}

\section{Post-stratification}{
 The design of a survey study usually will have
expected proportions that different groups should have in the full
population. Post-stratification adjustment is used to adjust observation
weights so that the influence of each group (called a post-stratification
cell) in an analysis is proportional to the group's actual proportion in
the population.
}

\examples{
boot.data <- boot_weights(input.data=sim_g_whole,
                          id="ID",
                          strata="STRATA",
                          psu="ID",
                          num.reps=25,
                          boot.seed=999)

#base weight and first 8 bootstrap replicate weights
head(boot.data[,paste0("RepWt_", 0:8)])
}
