#Performs case-insensitive matching of variable names to the names of a dataset.
match_variables <- function(variables, dataset) {

  if(is.character(dataset)) {

    dataset.names <- dataset
  } else if(is.matrix(dataset)) {

    dataset.names <- colnames(dataset)
  } else {

    dataset.names <- names(dataset)
  }

  matched <- character(length(variables))
  for(i in seq_along(variables)) {

    exact <- dataset.names[variables[i] == dataset.names]
    case <- dataset.names[toupper(variables[i]) == toupper(dataset.names)]
    if(length(exact) == 1) {

      matched[i] <- exact
    } else if(length(exact) == 0 && length(case) == 1) {

      matched[i] <- case
    } else {

      matched[i] <- NA
    }
  }

  return(matched)
}

#Performs case-insensitive matching of indicators and amounts to corresponding variables in backtransformation data.
match_backtran <- function(variables, backtran) {

  if(is.character(backtran)) {

    backtran.variables <- backtran
  } else {

    backtran.variables <- backtran$variable
  }

  matched <- character(length(variables))
  for(i in seq_along(variables)) {

    exact <- backtran.variables[vapply(backtran.variables, function(back) grepl(back, variables[i], ignore.case=FALSE), logical(1))]
    case <- backtran.variables[vapply(backtran.variables, function(back) grepl(back, variables[i], ignore.case=TRUE), logical(1))]
    if(length(exact) == 1) {

      matched[i] <- exact
    } else if(length(exact) == 0 && length(case) == 1) {

      matched[i] <- case
    } else {

      matched[i] <- NA
    }
  }

  return(matched)
}
