#Creates logger object to write errors to file or console.
create_logger <- function(log.file, log.to.console, log.threshold=1) {

  #clear log file
  if(!is.null(log.file)) {

    log.connection <- open(log.file, open="w")
    close(log.connection)
  }

  log.record <- data.frame(error.code=numeric(0), section=character(0), message=character(0))

  logger <- list(file=log.file,
                 console=log.to.console,
                 threshold=log.threshold,
                 record=log.record)

  return(logger)
}

#Writes messages to the log.
write_log <- function(logger, message) {

  if(!is.null(logger$file)) {

    log.connection <- open(logger$file, open="a")
    writeLines(message, con=log.connection)
    close(log.connection)
  }

  if(logger$console) {

    writeLines(message, con=stderr())
  }
}

#Adds notes, warnings, and errors to logger object.
update_logger <- function(logger, error.code, section, message) {

  new.record <- data.frame(error.code=error.code, section=section, message=message)
  logger$record <- rbind(logger$record, new.record)

  if(error.code >= logger$threshold) {

    if(error.code <= 1) {

      error.class <- "NOTE"
    } else if(error.code == 2) {

      error.class <- "WARNING"
    } else {

      error.class <- "ERROR"
    }

    message <- paste0(error.class, ": ", message)

    write_log(logger, message)
  }

  return(logger)
}
