# ncimultivar 1.0.5

## New Features

* Added boot_weights() function to generate bootstrap replicate weight sets.
* Added default behavior to brr_weights() and boot_weights() when not using a base weight or post-stratification cell variable.
* Added simulated population of whole grain intakes 'sim_g_whole' as an additional included dataset.

## Changes

* Changed text of 'statistic' column in summary_predictions() output to show the name of the 'id' variable.
* Reorganized code and explanations in vignettes to make them easier to read.


# ncimultivar 1.0.4

## Bug Fixes

* fix_nhanes_strata() no longer combines PSUs if a third PSU is not detected.

## Changes

* The MCMC model in the multiple imputation vignette now uses the regression outcome as a covariate.
* The seed for nci_multivar_distrib() in the multiple imputation vignette is now incremented for every parameter draw within a replicate.


# ncimultivar 1.0.3

## New Features

* Added gelman_rubin() function to test MCMC convergence using the Gelman-Rubin test.
* Added fix_nhanes_strata() function to correct specific NHANES strata that do not have exactly 2 PSUs.

## Changes

* Cleaned up parameter documentation for all functions.
* Cleaned up explanation text and add guidance on choosing MCMC iteration parameters to the vignettes.
* Changed MCMC iteration numbers in vignettes and examples so that each MCMC has at least 400 thinned samples to reflect best practices.
* Consolidated save.u.main and u.main.iter in the nci_multivar_mcmc() output object:
  * Removed save.u.main
  * Renamed u.main.iter to saved.u.main
* Changed Gelman-Rubin code in trace plot vignette to use the gelman_rubin() function.


# ncimultivar 1.0.2

## New Features

* The covariate_test() function now accepts all options for specifying variables and covariates that nci_multivar_mcmc() does.

## Bug Fixes

* Fixed an issue where the 'u' matrices stored from the main MCMC chain in nci_multivar_mcmc() could be offset by some iterations.
* Fixed an incorrect index in nci_multivar_mcmc() that could cause a crash with certain combinations of burn-in and thinning.
* Fixed an issue where covariate_test() would not select beta parameters correctly if a chosen covariate was a substring of another covariate.

## Changes

* The burn_and_thin() function is now "non-destructive" to the original 'nci.multivar.mcmc' object. All traces are kept in the object, so iterations can be increased again after they have been decreased.
* Added the following elements to the nci_multivar_mcmc() output object:
  * num.post: Number of post-MCMC 'u' matrix draws conditional on posterior means
  * save.u.main: Flag for whether main MCMC chain 'u' matrices have been stored
  * u.main.iter: Vector of iterations that contain stored main MCMC chain 'u' matrices 
* The 'degrees.of.freedom' parameter in covariate_test() has been renamed to 'df' to match degrees-of-freedom variables in other R functions.
* The 'bootstrap.weights' paramter in covariate_test() has been renamed to 'rep.weights' to reflect that fact that it can be used for replicate methods besides bootstrapping.
* Updated vignettes to reflect current feature set and with more in-depth explanations.


# ncimultivar 1.0.1

## Bug Fixes

* Fixed an issue where proportions below a threshold in nci_multivar_summary() were being calculated as proportions above the threshold instead.
* Fixed an error where dietary supplements could be extracted incorrectly in nci_multivar_distrib().
* Fixed an issue that caused some errors in Sigma-u prior specification to be missed by the error-checking code.
* Fixed a bug in nci_multivar_distrib() where U matrix rows would not be simulated for subjects that are in the MCMC but not in the distrib population when MCMC U matrices are used.

## Changes

* Removed unnecessary parameter 'variables' in trace_plots().
* Revised internal nci_multivar_mcmc() algorithm to be slightly more efficient for models with never-consumers.
* Log-likelihood calculations now use a different optimization algorithm to scale better with multivariate models.


# ncimultivar 1.0.0

## New Features

* Documentation and examples were added for all user-facing functions and the included NHANES data, accessible using help() and example().
* The brr_weights() function was created to generate balanced repeated replication (BRR) weights using strata, primary sampling unit (PSU), and post-stratification cell data.
* The existing BRR weights in the included NHANES data have been removed. Vignettes have been updated with information on how to use brr_weights() to generate weights for NHANES data.
* Winsorization reports generated by boxcox_survey() now show the name of the input variable. 
* Saving main MCMC chain random effect (‘u’) matrices with nci_multivar_mcmc() now only saves matrices for thinned iterations after burn-in by default to save disk space. 
* The draw_parameters() function will now throw an error if ‘u’ matrices are requested but not present for the iterations to be drawn.
* A parameter was added to nci_multivar_mcmc() to restore the original functionality of saving ‘u’ matrices for every iteration. 
* If ‘u’ matrices are requested either from the main MCMC chain or from post-MCMC conditional draws, the error log now reports an estimate of the disk space that will be used.
* An approximation of the log-likelihood can now be requested as part of the output when fitting a model with nci_multivar_mcmc(). Likelihoods for models with multiple episodic variables or never-consumers of an episodic variable are experimental.
* The burn_and_thin() function was added to modify the burn-in and thinning parameters for calculating means and variances of an existing MCMC model.
* Covariate lists and intercepts can now be specified for individual indicators and amounts in nci_multivar_mcmc().
* The initial seeds for nci_multivar_mcmc() and nci_multivar_distrib() are now returned in the output objects.
* Added a summary_predictions() function that extracts the linear predictors from regression models into a data frame that can be used with the other summary functions.

## Bug Fixes

* Non-consumption days are now correctly removed when selecting a lambda and finding outliers with boxcox_survey().
* Fixed incorrect Winsorization thresholds when using boxcox_survey() with an episodic variable.
* Fixed a crash that could occur when the thinning parameter was specified incorrectly in nci_multivar_mcmc(). The function now logs the error and exits gracefully.
* The consumer probability parameter trace for never-consumer models in nci_multivar_mcmc() now outputs the mean consumer probability at each iteration as intended.
* Beta parameters for a single variable no longer lose their name in the output of extract_parameters().

## Changes

* The names of some parameters were modified so that variables with the same role will be named the same way across functions.
* Vignettes were restructured to reduce computation time while still demonstrating the same functions. 

* The order of some random number calls was changed in the internal code of nci_multivar_mcmc(). This may cause output to slightly vary from the previous version with the same seed.
* The error log from nci_multivar_mcmc() now prints to the console by default instead of writing to a file. The output can still be redirected to file as it was previously by explicitly specifying a file.
* Added additional error checks in nci_multivar_mcmc() to ensure that only one subject identifier and repeat observation variable are given.
* Added error checks in nci_multivar_mcmc() for intercepts and never-consumer covariates.
* The output of nci_multivar_mcmc() now lists covariates and intercepts for each indicator and amount. The never-consumer covariates and intercept are now in separate elements of the output object.
* The parameter traces in the output of nci_multivar_mcmc() now use slightly different data structures to save memory and simplify processing.
* The output of extract_parameters() now has the same ordering as trace_plots().
* Non-functional covariate list parameters were removed from nci_multivar_distrib(). Covariate data is extracted directly from the output object of nci_multivar_mcmc().
* Plots created by trace_plots() and nci_multivar_summary() no longer output PDFs by default. PDFs can still be generated by using pdf() outside the function. An example of this can be seen by running example(“trace_plots”).

## Other

* Internal functions that are not intended to be called by end users are now hidden.


# ncimultivar 0.2.0

## New Features

* Winsorization thresholds can now be found in the presence of covariates. 
* The Winsorization report is now part of the boxcox_survey() output as an attribute.
* Added a parameter “is.episodic” to boxcox_survey() which Winsorizes values below the minimum threshold to zero for episodic variables.
* Added a report of subjects with influential within-subject variance to boxcox_survey(). The testing is based on an F-test, and the threshold p-value can be corrected for multiple comparisons using the same methods as the built-in stats::p.adjust() R function.
* Created a helper function to draw parameter sets for measurement error correction using multiple imputation. A vignette was added demonstrating this function.
* Added an extract_parameters() function to output the posterior means and Monte Carlo variance/covariance matrix of the parameters from an MCMC model.
* Added covariate_test() function to test for the significance of beta coefficients using bootstrap or balanced repeated replication (BRR).

## Bug Fixes

* Fixed a data processing error that could occur when input data to nci_multivar_mcmc() was not sorted by the repeat observation variable.
* Fixed a crash in boxcox_survey() that occurred when data imported using the “haven” R package was used as the input.
* The nci_multivar_distrib() output now correctly maintains the data types of the output variables when the subject ID is a character variable.
* For variables specified as daily, nci_multivar_preprocessor() now replaces zero values with half the minimum non-zero amount.

## Changes

* The boxcox_survey() function now requires a subject ID variable and repeat observation variable if the Winsorization or influential within-subject variance reports are requested.
* The summary_regression() function has been renamed to summary_coefficients().
* The “num.iterations” element of the nci_multivar_mcmc() output has been renamed to “num.mcmc.iterations” to be consistent with the input parameter name.
* Changed the name of the “winsorize” parameter in boxcox_survey() to “do.winsorization”.

## Other

* Added an explanation of nci_multivar_mcmc() log files to the daily nutrient vignette.
* Updated the install.packages() call in the README file to a version that is applicable to all operating systems.

