(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Input 
GenRandomData  twinfitcore.m
FitEM              twinfitem.m*)

BeginPackage["twinfitvar`","twinfitem`","twinfitcore`"]  

TwinFitH::usage="TwinFitH[datavec]"
TwinFitVarComp::usage="TwinFitVarComp[dataset,censoringstart,numcatfin]"
TwinFitVarFormulaCheck::usage="TwinFItVarCheck[parsym]"

Clear[TwinFitVarComp,TwintFitVarFormulaCheck,TwinFitH]

Begin["Private`"]


TwinFitH[datavec_,maxboot_:10]:=
Module[{censoringstart,numcatfin,hvec,show},
  censoringstart="during";
  numcatfin=1;
  show=False;
  hmat=TwinFitVarBootOne[#,censoringstart,numcatfin,maxboot]& /@ datavec;
  colname={"dataset","type","est","se","low","upp"};
 Print@TableForm[hmat,TableHeadings->{None,colname}];
 Return[Null]]



TwinFitVarBootOne[dataset_,censoringstart_,numcatfin_,maxboot_]:=
Module[{data,datatype,dataname,datafilename,est, hvec,alpha,res},
  {data,datatype,dataname,datafilename}=dataset;
  If[datatype=="obs", datacore = data];
  If[datatype=="em",    datacore =FitEM[data,censoringstart,numcatfin]];
 est=TwinH[datacore];
 Print[dataname," ",datatype, " ",est];
hvec=Table[TwinFitVarRandom[dataset,censoringstart,numcatfin],{i,1,maxboot}];
 alpha=.025;
{mean,se,low,upp}=BootAnalysis[hvec,maxboot,alpha];
res={dataname,datatype,est,mean,se,low,upp};
Return[res]]

TwinFitVarRandom[dataset_,censoringstart_,numcatfin_]:=
 Module[{  data,datatype,dataname,datafilename,dataR,h},
   {data,datatype,dataname,datafilename}=dataset;
       dataR=GenRandomData[data,datatype];
       If[datatype=="obs", datacore = dataR];
        If[datatype=="em",    datacore =FitEM[dataR,censoringstart,numcatfin]];
         h=TwinH[datacore];
Return[h]]

TwinH[datacore_]:=
Module[{m2,m1,m0,d2,d1,d0,rMZ,varrMZ,rDZ,varrDZ,serMZ,serDZ,h,varh,seh,tab},
{m2,m1,m0,d2,d1,d0}=datacore;
{rMZ,varrMZ}=TetrachoricCorrelationZ[{m2,m1,m0}];
{rDZ,varrDZ}=TetrachoricCorrelationZ[{d2,d1,d0}];
 h= 2 (rMZ-rDZ);
Return[h]]


BootAnalysis[vec_,maxboot_,alpha_:.025]:=
 Module[{matx,meanvec,sevec,lowvec,uppvec,res,low,upp,bounds},
      mean=Mean[vec];
      se=Sqrt@Variance[vec];
      lowC=Max[1,Floor[maxboot alpha]];
      uppC=Min[maxboot,Ceiling[maxboot (1-alpha)]];
      low=LowerCI[lowC,vec];
      upp=UpperCI[uppC,vec];
      res= {mean,se,low,upp};
Return[res]]
 
 
  LowerCI[lowCI_,y_]:=(Sort[y])[[lowCI]]
  UpperCI[uppCI_,y_]:=(Sort[y])[[uppCI]]






TwinFitVarComp[dataset_]:= TwinFitVarComp[dataset,"during",1]


TwinFitVarComp[dataset_,censoringstart_,numcatfin_,show_:True]:=
Module[{data,datatype,dataname,datafilename},
       {data,datatype,dataname,datafilename}=dataset;
        If[datatype=="obs", datacore = data];
        If[datatype=="em",    datacore =FitEM[data,censoringstart,numcatfin]];
         hvec=VarComp[datacore,show];
Return[hvec]]






VarComp[datacore_,show_]:=
Module[{m2,m1,m0,d2,d1,d0,rMZ,varrMZ,rDZ,varrDZ,serMZ,serDZ,h,varh,seh,tab},
{m2,m1,m0,d2,d1,d0}=datacore;
{rMZ,varrMZ}=TetrachoricCorrelationZ[{m2,m1,m0}];
{rDZ,varrDZ}=TetrachoricCorrelationZ[{d2,d1,d0}];
serMZ=Sqrt[varrMZ];
serDZ=Sqrt[varrDZ];
(*heritability*)
 h= 2 (rMZ-rDZ);
varh= 4 (varrMZ+ varrDZ);
seh=Sqrt[varh];
rowMZ=GenRow[rMZ,serMZ];
rowDZ=GenRow[rDZ,serDZ];
rowh=GenRow[h,seh];
mat={rowMZ,rowDZ,rowh};
matr=Round[mat 10000]/10000//N;
rowname={"rMZ","rDZ", "heritability"};
colname={"est","se", "low", "up"};
tab=TableForm[matr,TableHeadings->{rowname,colname}];
If[show,Print["    ",tab]];
Return[rowh]]

GenRow[est_,se_]:={est,se, est -1.96 se, est+1.96 se}

TetrachoricCorrelationZ[{x2_,x1_,x0_}]:=
Module[{n00,n10,n01,n11,c,r,n,p1,p2,t1,t2,varden,varnum,var, res},
(*correlation*)
	n11=x2;
	n10=x1/2;
	n01=x1/2;
	n00=x0;
	c=((n00 n11)^.5 - (n01 n10)^.5) / ((n00 n11)^.5 + (n01 n10)^.5);
	r= Sin[(Pi/2) c];
(*variance*)
	n=n00+n01+n10+n11;
	p1=(n00+n01)/n;
	p2=(n00 +n10)/n;
	t1=InvCDF[p1];
	t2=InvCDF[p2];
	varden=(n PDF[BinormalDistribution[r], {t1,t2}])^2;
	varnum=1/(1/n00+ 1/n01 + 1/n10+ 1/n11);
	var=varnum/varden;
	res={r,var};
Return[res]]


 InverseNormal[mu_, sigma_, z_]:= mu + Sqrt[2] sigma InverseErf[2 z - 1]
 
 InvCDF[alpha_]:= InverseNormal[0,1,alpha]
 




 (*-----------------------------Check results-----------------------------------------------------------------------*)
 
 TwinFitVarFormulaCheck[parsym_]:=
 Module[{a,b,c,s },
  {a,b,c,s}=parsym;
  Print["Frequencies of genotype pairs"];
   VarCheckFreq[s];
   Print["check simple VMZ and VDZ formulas"];
   VarCheckAdd[parsym];
Return[Null]]
 
 

VarCheckFreq[s_]:=
Module[{f1,f2,f3,f4,f5,f6,pve,qvec, rowname,colname, mat,
meanch,mean},
  fvec={s^2, 0, 0,0, 2 s (1-s),0,0,0,(1-s)^2};
  pvec=FreqCompSGB[s];
  qvec=FreqCompNeale[s];
   mat=Transpose[{pvec,qvec,pvec-qvec}]//Simplify;
   colname={"Baker", "Neale and Cardon", "difference"};
  rowname={"CC,CC","CC,Cc","CC,cc","Cc,CC","Cc,Cc","Cc,cc","cc,CC", "cc,Cc","cc,cc"};
  Print@TableForm[mat, TableHeadings->{rowname,colname}];
Return[Null]]


 
FreqCompSGB[s_]:=
Module[{f1,f2,f3,f4,f5,f6,pXXXX,pXXXx,pXXxx,pXxXX,pXxXx,pXxxx,pxxXX,pxxXx,pxxxx,pvec},
(*Baker et al formula*)
 f1 = s^4;
  f2 = s^2 2 s (1 - s) 2;
  f3 = s^2 (1 - s)^2  2;
  f4 = 2 s (1 - s) 2 s (1 - s);
  f5 = 2 s (1 - s) (1 - s)^2 2;
  f6 = (1 - s)^4;
  pXXXX= f1 + f2/4 +       f4/16              //Simplify;
 pXXXx=      f2/4 +       f4/8               //Simplify;
 pXXxx=                   f4/16              //Simplify;
 pXxXX=      f2/4 +       f4/8              //Simplify;
 pXxXx=      f2/4 + f3 +  f4/4  + f5/4       //Simplify;
 pXxxx=                   f4/8  + f5/4       //Simplify;
pxxXX=                   f4/16              //Simplify;
pxxXx=                   f4/8  + f5/4       //Simplify;
  pxxxx=                   f4/16 + f5/4 + f6 //Simplify;
  pvec={pXXXX,pXXXx,pXXxx,pXxXX,pXxXx,pXxxx,pxxXX,pxxXx,pxxxx};
Return[pvec]]

(*formula in literature as check*)

FreqCompNeale[s_]:=
Module[{f1,f2,f3,f4,f5,f6,u,v,qXXXX,qXXXx,qXXxx,qXxXX,qXxXx,qXxxx,qxxXX,qxxXx,qxxxx,qvec},
u=s;
v=(1-s);
qXXXX=    u^4 + u^3 v + (1/4) u^2 v^2    //Simplify;
qXXXx=    u^3 v + (1/2) u^2  v^2              //Simplify;
qXXxx=     (1/4) u^2 v^2                           //Simplify;
qXxXX=      u^3 v + (1/2) u^2 v^2             //Simplify;
qXxXx=       u^3 v + 3 u^2 v^2 + u v^3    //Simplify;
qXxxx=       (1/2) u^2 v^2 + u v^3            //Simplify;
qxxXX=       (1/4) u^2 v^2                        //Simplify;
qxxXx=         (1/2) u^2 v^2 + u v^3          //Simplify;
qxxxx=         (1/4) u^2 v^2 + u v^3 + v^4 //Simplify;
  qvec={qXXXX,qXXXx,qXXxx,qXxXX,qXxXx,qXxxx,qxxXX,qxxXx,qxxxx};
Return[qvec]]

(*--------------VARIANCE CHECK-------------------------*)

VarCheckAdd[parsym_]:=
Module[{VA,VD,VarMZ,VarDZ,VDZsum},
     {VA,VD,VarMZ}=VarCompMZ[parsym]//Simplify;
      VarDZ=VarCompDZ[parsym]//Simplify;
      VarDZsum= 1/2 VA + 1/4 VD//Simplify;
      Print["check VarDZ-(VA/2 + VD/4)  = ", Simplify[VarDZ-VarDZsum]];
         VarMZsum=  VA +  VD//Simplify;
      Print["check VarMZ-(VA + VD)  = ", Simplify[VarMZ-VarMZsum]];
Return[Null]]   



(*-----------------VARIANCE COMPONENTS*)

VarCompMZ[{a_,b_,c_,s_}]:=
Module[{fvec,yvec,xvec,My,Mx,Vy,Vx,Vxy,VD,VA,VMZ,alpha, beta,ypredvec},
  (*probabiliteis of genotypes*)
    fvec=FreqCompSGB[s];
(*yvec and xvec*)
    yvec={a,b,c,a,b,c,a,b,c};
    xvec={2,1,0,2,1,0,2,1,0};
 (*Means and variances*)
    My=Total[yvec fvec]//Simplify;
    Mx=Total[xvec fvec]//Simplify;   
   VMZ=Total[(yvec-My)^2 fvec]//Simplify;
 (*Least squares estimates*)
        Vx=Total[(xvec-Mx)^2 fvec]//Simplify;
        Vxy=Total[(xvec-Mx) (yvec-My) fvec];
        beta=Vxy/Vx;
        alpha=My- Mx beta;
        ypredvec=  alpha + beta xvec;
   (*variance components*)     
        VA=  Total[(ypredvec- My)^2 fvec]//Simplify;
        VD=  Total[(yvec- ypredvec)^2 fvec]//Simplify;
   Return[{VA,VD,VMZ}]]


VarCompDZ[{a_,b_,c_,s_}]:=
Module[{yvec1,yvec2,fvec,My1,My2,VDZ},
      fvec=FreqCompSGB[s];
      yvec1={a,a,a,b,b,b,c,c,c};
      yvec2={a,b,c,a,b,c,a,b,c};
  (*means and variances*)
   My1=Total[yvec1 fvec]//Simplify;
   My2=Total[yvec2 fvec]//Simplify;
   VDZ=Total[(yvec1-My1) (yvec2-My2) fvec]//Simplify;
Return[VDZ]]








End[] 
EndPackage[]




