(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Input*)

BeginPackage["twinfitsummary`"]  

TwinFitSummarySet::usage="TwinFitSummarySet[res,maxboot,modelvec]"

Clear[TwinFitSummarySet]


Begin["Private`"]

TwinFitSummarySet[resvec_,maxboot_,modelvec_]:=
Module[{mat0},
   If[maxboot==0,  TwinFitSummaryOrigModelSet[resvec,maxboot, modelvec]];
   If[maxboot==1,   Print["no bootstrap with 1 iteration"]];
    If[maxboot>=2, TwinFitSummaryBootModelSet[resvec,maxboot,modelvec]];	
Return[Null]]


TwinFitSummaryOrigModelSet[resvec_,maxboot_,modelvec_]:=
 Module[{mat0,matr,labelvec},
     mat0=TwinFitSummaryOrigModel[#,maxboot]& /@ resvec;
     GenerateTableOrig[mat0,modelvec];
Return[mat0]]



TwinFitSummaryOrigModel[res_,maxboot_]:=
 Module[{estvec,model,mat0,estvec0},     
    {model,mat0,matset}=res;
    estvec0=FindMinDevianceForProfile[mat0];
  Return[estvec0]]
  
  
  GenerateTableOrig[mat0_,modelvec_]:=
  Module[{devvec,rrvec,avec,bvec,cvec,svec,prevvec,fracvec,devmat,mat1,lablevec,mat2,devvecr},
         {devvec,rrvec,avec,bvec,cvec,svec,prevvec,fracvec}=Transpose[mat0];
     (*deviances*)
         Print["deviance"];
         devvecr=Round[devvec 10]/10//N;
         devmat={devvecr};
         tab1=TableForm[devmat,TableHeadings->{{"deviance"},modelvec}];
         Print[tab1];
      (*parameter estimates*)	
           mat1={avec,bvec,cvec,svec,prevvec,fracvec};
           Print["parameters estimates in percentages"];
          labelvec= {"a","b","c","s","prev","frac"};
          mat2=PaddedMat[mat1];
          tab2=TableForm[mat2,TableHeadings->{labelvec,modelvec}];
         Print[tab2];
   Return[Null]]
       
   
 
  
 (*---------------------------------------BOOT---------------------------------------*) 

TwinFitSummaryBootModelSet[resvec_,maxboot_,modelvec_]:=
Module[{range,bootresvec,matvec,mat,estmat,semat,dvec,rvec,avec,bvec,cvec,svec,prevvec,fracvec,tab1,mat1,mat1r,tab2,plotprev,plotfrac,plotvec,plotx,plotz,plotfigname},
       range=Range@Length[modelvec];
       {prevmax,fracmax}=GetBoundsModelSet[resvec,maxboot,modelvec];	
       bootresvec=TwinFitSummaryBootModel[resvec,maxboot,#,{prevmax,fracmax}]& /@ range;
       {matvec,plotprev,plotfrac}=Transpose[bootresvec];
        {dvec,rvec,avec,bvec,cvec,svec,prevvec,fracvec}=Transpose[matvec];
        plotvec=Transpose[{plotprev,plotfrac}];
        plotx=GraphicsGrid[plotvec];
        plotz=Show[plotx, ImageSize->Large];    
        plotfigname="twinfitfig1.tiff";
        Print["exporting ",plotfigname];
        Export[plotfigname,plotz];
        Print[plotz];
        (*deviances*)
           Print["deviance"];
           dvec1=Transpose[dvec][[1]];
           devvecr=Round[dvec1 10]/10//N;
            devmat={devvecr};
           tab1=TableForm[devmat,TableHeadings->{{"deviance"},modelvec}];
           Print[tab1];
      (*parameter estimates*)
           mat1={avec,bvec,cvec,svec,prevvec,fracvec};
            mat1r=CreateCI[#]& /@ mat1;
           Print["parameters estimates in percentages"];
          labelvec= {"a","b","c","s","prev","frac"};
            tab2=TableForm[mat1r,TableHeadings->{labelvec,modelvec}];
         Print[tab2];
   Return[Null]]
   
   
   
   GetBoundsModelSet[resvec_,maxboot_,modelvec_]:=
   Module[{range,bootresvec,matvec,mat,estmat,semat,dvec,rvec,avec,bvec,cvec,svec,prevvec,fracvec,tab1,mat1,mat1r,tab2,plotprev,plotfrac,plotvec,plotx},
          range=Range@Length[modelvec];
        mat= GetBoundsModel[resvec,maxboot,#]& /@ range;
         {prev,frac}=Transpose[mat];
         prevmax=Max[prev];
         fracmax=Max[frac];
      Return[{prevmax,fracmax}]]
   
   GetBoundsModel[resvec_,maxboot_,modelnum_]:=
    Module[ {dvec,rvec,avec,bvec,cvec,svec,prevvec,fracvec,plotfrac},
         res=resvec[[modelnum]];
        {model,mat0,matset}=res;
        estmat=FindMinDevianceForProfile[#]& /@ matset;
        {dvec,rvec,avec,bvec,cvec,svec,prevvec,fracvec}=Transpose[estmat];
       Return[{Max[prevvec],Max[fracvec]}]] 
       
 
 TwinFitSummaryBootModel[resvec_,maxboot_,modelnum_,{prevmax_,fracmax_}]:=
 Module[{estvec,estvec0,alpha,meanvec,lowvec,uppvec,model,mat0,matset,estmat,semat,resmat},
     res=resvec[[modelnum]];
     {model,mat0,matset}=res;
     showdetails=False;
     If[showdetails,
      Print[model];
      Print["    Original:      {number in profile, number of parameters} ",Dimensions[mat0]];
      Print["    Bootstrap:  {number iterations, number in profile, number of parameters} ", Dimensions[matset]]];
      estvec0=FindMinDevianceForProfile[mat0];
      estmat=FindMinDevianceForProfile[#]& /@ matset;
      {plotprev,plotfrac}=PlotHist[estmat,model,{prevmax,fracmax}];
      alpha=.05;
      Print["alpha = 5% on each side"];
      {meanvec,sevec,lowvec,uppvec}=BootAnalysisCoreX[estmat,maxboot,alpha];
      resmat=Transpose[{estvec0,meanvec,lowvec, uppvec}];
    Return[{resmat,plotprev,plotfrac}]]    
 
 
 
 BootAnalysisCoreX[mat_,maxboot_,alpha_:.025]:=
 Module[{matx,meanvec,sevec,lowvec,uppvec,res,low,upp,bounds},
     matx=Transpose[mat];
      meanvec=Mean[#]&  /@ matx;
      sevec=Sqrt[Variance[#]]& /@ matx;
      low=Max[1,Floor[maxboot alpha]];
      upp=Min[maxboot,Ceiling[maxboot (1-alpha)]];
      lowvec=LowerCI[low,#]& /@ matx;
      uppvec=UpperCI[upp,#]& /@ matx;
       res= {meanvec,sevec,lowvec,uppvec};
Return[res]]
 
 
  LowerCI[lowCI_,y_]:=(Sort[y])[[lowCI]]
  UpperCI[uppCI_,y_]:=(Sort[y])[[uppCI]]

 PlotHist[estmat_,model_,{prevmax_,fracmax_}]:=
 Module[ {dvec,rvec,avec,bvec,cvec,svec,prevvec,fracvec,plotfrac},
     {dvec,rvec,avec,bvec,cvec,svec,prevvec,fracvec}=Transpose[estmat];
     prevname=StringJoin["genetic prevalance ",model];
     fracname=StringJoin["heritabilty fraction prevalance ",model];     
     plotprev=Show[Histogram[prevvec], PlotRange->{{0,prevmax},All}, Frame->True, FrameLabel->{"genetic prevalence",None,model,None}];       
     plotfrac=Show[Histogram[fracvec],  PlotRange->{{0,fracmax},All},  Frame->True, FrameLabel->{"heritability fraction",None,model,None}];
  Return[{plotprev,plotfrac}]]     
 
 
 
 FindMinDevianceForProfile[mat_]:=
  Module[{mats,estvec,res},
         mats=Sort[mat];
           estvec=mats[[1]];
       Return[estvec]]


 CreateCI[vec_]:=CreateCIOne[#]& /@ vec 

 
 CreateCIOne[{est_,mean_,low_,upp_}]:= 
 Module[{estr,uppr,resx},
        estr=r100[est];
        meanr=r100[mean];
        lowr=r100[low];
        uppr=r100[upp];
        (*     resx=StringJoin[estr,  " ", meanr,"   (",    lowr,    ", ",    uppr, ")"];*)
      resx=StringJoin[estr,   " (",    lowr,    ", ",    uppr, ")"];
Return[resx]]

PaddedMat[mat_]:=PaddedVec[#]& /@ mat;
PaddedVec[vec_]:=PaddedForm[#,2]&  /@ vec
 r100[x_]:=ToString@PaddedForm[Round[x 100]/100//N, {3,2}]


End[] 
EndPackage[]



