(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Input
FitEM			twinfitem.m
TwinFitProfile 	  	 twinfitprofile.m
TwinFitPlotCore	  	 twinfitprofileplot.m
TwinFitEst			twinfitcore.m
TwinFitBoot		twinfitcore.m
GenProb		          twinfitprob.m
*)



BeginPackage["twinfitsim`","twinfitprob`", "twinfitprofile`","twinfitcore`","twinfitprofileplot`",
"twinfitsummary`","twinfitem`","twinfitfreq`","twinfitdata`","twinfitvar`","matrixlx`"]  

TwinFitSim::usage="TwinFitSim[parsym]"


Clear[TwinFitSim]


Begin["Private`"]




TwinFitSim[parsym_]:=
    Module[{model,parsym1,parsym2,parsym3,parsymset},
      
       parsym1={.99,.05,.10,.01}; 
              parsym2={.80,.1,.2,.05};
              parsym3={.70,.1,.2,.20};
       
       
       parsymset={parsym1,parsym2,parsym3};
       amin0=0;
         Print["Amin ",amin0];
          TwinFitSimSet[#,parsym,amin0]& /@ parsymset;        
       amin1=.7;
          Print["Amin ",amin1];
       TwinFitSimSet[#,parsym,amin1]& /@ parsymset;        
  Return[Null]]  
  
  
    
TwinFitSimSet[parsym0_,parsym_,amin_]:=
    Module[{model,a0,b0,c,s0,dev0,estvec0,
       prevAR,fracAR,prevAD,fracAD,prevAdd,fracAdd,vecAR0,vecAD0,vecAdd0,mat0},
        {a0,b0,c0,s0}=parsym0;
        dev0=0;
        {prevAR, fracAR}=ComputeFrac["AR",a0,b0,c0,s0];
        {prevAD, fracAD}=ComputeFrac["AD",a0,b0,c0,s0];
        {prevAdd, fracAdd}=ComputeFrac["Add",a0,b0,c0,s0];
        estvec0={dev0,a0,b0,c0,s0,prevAR,prevAD,prevAdd,fracAR,fracAD,fracAdd};
         
         vecAR0=TwinFitCheckParameters["AR",parsym0,parsym,amin];
         vecAD0=TwinFitCheckParameters["AD",parsym0,parsym,amin];
         vecAdd0=TwinFitCheckParameters["Add",parsym0,parsym,amin];
         mat0={vecAR0,vecAD0,vecAdd0};
         GenTab[mat0,estvec0];  
    Return[Null]]

    
      GenTab[mat_,estvec0_]:=
       Module[{colname,estvecP,estvec0r,mat1,rowname,tab},
             colname={"amin", "dev",   "a",   "b",   "c",   "s", "prev-AR","prev-AD","prev-Add","HF-AR","HF-AD","HF-Add"};
            estvecP=PaddedForm[#,{3,2}]&  /@ estvec0;
             estvec0r={"- "} ~Join~ estvecP; 
            mat1=Join[{estvec0r},mat];
            rowname={"True", "AR",  "AD",  "Add"};
            tab=TableForm[mat1,TableHeadings->{rowname,colname},TableSpacings->{1,1}];
            Print[tab];
       Return[Null]]
    
    
    TwinFitCheckParameters[model_,parsym0_,parsym_,amin0_]:=
    Module[{showconv,estvec},
       showconv=True;
       estvec=TwinFitCheckParametersCore[amin0,parsym0,{1000,1000},model,parsym,False,showconv];
    Return[estvec]]

     
     TwinFitCheckParametersCore[amin0_,parsym0_,{nM_,nD_},model_,parsym_,showprog_,showconv_:True]:=
     Module[{a0,b0,c0,s0,dev0,estvec0,datacore0, mat, mats, vec, 
     devX,RRX,a0X,b0X,c0X,s0X,   prevZ,fracZ,z,  estvec,  estvecr},
           {a0,b0,c0,s0}=parsym0;
           dev0=0;
           estvec0=ComputeFinalParameters[model,{dev0,a0,b0,c0,s0}];
           datacore0=GenDataCoreX[model,parsym0,{nM,nD}];   
              mat=TwinFitProfile[datacore0,parsym,model,showprog,amin0];
           mats=Sort[mat];
           vec=mats[[1]];
	  {devX,RRX,a0X,b0X,c0X,s0X,prevX,fracX}=vec;
	   {prevZ,fracZ}=ComputeFrac[model,a0X,b0X,c0X,s0X];	   
	   z=-1;
	   If[model=="AR",  estvec={amin0,devX,a0X,b0X,c0X,s0X,prevZ,z,z,fracZ,z,z}];
	   If[model=="AD",  estvec={amin0,devX,a0X,b0X,c0X,s0X,z,prevZ,z,z,fracZ,z}];
	   If[model=="Add",  estvec={amin0,devX,a0X,b0X,c0X,s0X,z,z,prevZ,z,z,fracZ}];
	   estvecr=PadRound[#] & /@ estvec;
	Return[estvecr]]

PadRound[x_]:=
  Module[{x1,x2},
  If[x>-1,
  x1=Round[x 1000]/1000//N;
  x2=PaddedForm[x1,{3,2}]];
  If[x==-1,
    x2="-"];
  Return[x2]]

 
GenDataCoreX[model_,{a0_,b0_,c0_,s0_},{nM_,nD_}]:=
Module[{par0,datacore,fMii, fMic, fMcc, fDii, fDic, fDcc,xMvec,xDvec},
       par0={a0,b0,c0,s0};
       res0=GenProb[par0,model];
        {fMii, fMic, fMcc, fDii, fDic, fDcc}=  GenProb[par0,model];
       xMvec={fMii, fMic, fMcc} nM;
       xDvec={fDii, fDic, fDcc}  nD;
       datacore=Join[xMvec,xDvec];
 Return[datacore]]    


ComputeFrac[model_,a0_,b0_,c0_,s0_]:=
Module[{prev0,v0,frac0,p1,p2,hM22,hM11, hM00,hD22,hD21,hD20,hD11,hD10,hD00},
   v0= b0 + (1-b0)c0/2;  
     If[model=="AR" || model=="ARN",  prev0=s0^2];
      If[model=="AD" || model=="ADN",  prev0=1 - (1-s0)^2];
      If[model=="Add",  prev0=(2-s0) s0 ];
      If[model=="AR" || model=="ARN" || model=="AD" || model=="ADN" || model=="AR3" || model=="AD3",      
               frac0=(prev0 a0) / ((prev0 a0 + (1-prev0) v0))];
        If[model=="Add",      
             {{hM22,hM11, hM00},{hD22,hD21,hD20,hD11,hD10,hD00}}=XFreqAdd[s0];
                 p1=a0/2;
                p2= a0;
       frac0=(hM22 p2 + hM11 p1) /(hM22 p2 + hM11 p1 + hM00 	  v0)]; 
       fracr=Round[frac0 100]/100//N;
       prevr=Round[prev0 1000]/1000//N;  
       fracr=PadRound[frac0];
       prevr=PadRound[prev0];
Return[{prev0,frac0}]]


 
 

End[] 
EndPackage[]


