(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Date 2014*)
(*Input
ComputePrev			twinfitprob.m
ComputeFinalParameters	 twinfitprob.m
GenProbAdd			 twinfitprob.m
GenProbMod			 twinfitprob.m *)


BeginPackage["twinfitprofileplot`", "twinfitem`", "twinfitprob`","twinfitfreq`","twinfitdata`","matrixlx`"]  

TwinFitProfilePlot::usage="TwinFitProfilePlot"
TwinFitProfilePlotSIM::usage="TwinFitProfilePlot"


Clear[TwinFitProfilePlot,TwinFitProfilePlotSIM]


Begin["Private`"]


 TwinFitProfilePlot[dataset_,parsym_,modelvec_,showprog_,censoringstart_,numcatfin_]:=
   Module[{data,datatype,dataname,datafilename,datacore},
       {data,datatype,dataname,datafilename}=dataset;
        If[datatype=="obs", datacore = data];
       If[datatype=="em",    datacore =FitEM[data,censoringstart,numcatfin]]; 
       TwinFitProfilePlotKey[datacore,parsym,modelvec,showprog,dataname];
    Return[Null]]



 TwinFitProfilePlotSIM[model_,parsym0_,parsym_]:=
   Module[{a0,b0,c0,s0,dev0,estvec0,datacore0,modelvec,showprog},
           {a0,b0,c0,s0}=parsym0;
           dev0=0;
           nM=1000;
           nD=1000;
           estvec0=ComputeFinalParameters[model,{dev0,a0,b0,c0,s0}];
           datacore0=GenDataCore["AR",parsym0,{nM,nD}];
           modelvec={"AR","AD","Add"};
           showprog=False;
          TwinFitProfilePlotKey[datacore0,parsym,modelvec,showprog,"sim"];
    Return[Null]]
    


TwinFitProfilePlotKey[datacore_,parsym_,modelvec_,showprog_,dataname_]:=
Module[{plotset,plotvecDEV,plotvecHF,plotvecPREV,devvec,hfvec,svec,pvec,rangeDEV,rangeHR,rangePREV,avec,labelmat,labelDEV,labelHF,labelPREV,
                   plotvecDEV0,plotvecHF0,plotvecPREV0,plotset1,plot},
        svec0={.0001,.0005, .0008, .001,.004, .006, .008, .01, .02 .05, .1, .2,.3,.4}; 
         avec0={.5,.6,.7,.8,.9};	
     plotset= TwinFitProfilePlotCore[datacore,parsym,#,showprog,avec0,svec0]&  /@ modelvec;
        {plotvecDEV,plotvecHF,plotvecPREV, devvec,hfvec,svec,pvec}=Transpose[plotset];
        {rangeDEV,rangeHR,rangePREV}=GenRange[devvec,hfvec,svec,pvec];
       labelmat=GenLabel[devvec,hfvec,svec,pvec,avec0,#]& /@ avec0;
	 {labelDEV,labelHF,labelPREV}=Transpose[labelmat];   
       plotvecDEV0=Show[#,labelDEV,PlotRange->rangeDEV]&  /@ plotvecDEV;
       plotvecHF0=Show[#,labelHF,PlotRange->rangeHF]& /@ plotvecHF;
       plotvecPREV0=Show[#,labelPREV,PlotRange->rangePREV]& /@ plotvecPREV;
       plotset1=Transpose@{plotvecPREV0,plotvecHF0};
       plot=Show[GraphicsGrid[plotset1],ImageSize->Large];
       plotname=StringJoin["twinfit",dataname,"plot.eps"];
      Print[plot];
      Print["exporting ",plotname];
      Export[plotname,plot];
     Return[Null]]


 TwinFitProfilePlotCore[datacore_,parsym_,model_,showprog_,avec0_,svec0_]:=
 Module[{smat,svecmin,svecmax,smin,smax,svec,plotvec,res},
      smat=TwinFitProfileS[datacore,parsym,model,showprog,#,svec0]& /@ avec0;
      {svecmin,svecmax}=Transpose[smat];
      smin=Min[svecmin];
     smax=Max[svecmax];
     svec=smin+(smax-smin) Range[9]/10//N;
     plotset=TwinFitProfileModelPlot[datacore,parsym,model,showprog,#,avec0,svec]& /@ avec0;
     {plotvecDEV,plotvecHF,plotvecPREV, devvec,hfvec,svec,pvec}=Transpose[plotset];  
       plotnameDEV=StringJoin[model,"   Deviance"];
      plotnameHF=StringJoin[model,"    Heritability Fraction"];
      plotnamePREV=StringJoin[model,"    Genetic Prevalence"];
    plotDEV=Show[plotvecDEV, Axes->None,Frame->True,FrameLabel->{"s","deviance",plotnameDEV,None}];
      plotHF=Show[plotvecHF,  Axes->None,Frame->True,FrameLabel->{"s","HF",plotnameHF,None}];
     plotPREV=Show[plotvecPREV, Axes->None, Frame->True,FrameLabel->{"s","prev",plotnamePREV,None}];
     res={plotDEV,plotHF,plotPREV,devvec,hfvec,svec,pvec};
     Return[res]]
   




 
 

TwinFitProfileS[datacore_,parsym_,model_,showprog_,a0_,svec0_]:=
 Module[{mat1,mat2,colname,svec,res},
    If[model=="AR" || model=="AD" || model=="ARN" || model=="ADN" || model=="AR3" || model=="AD3",  
     mat1=TwinFitProfileModCoreX[datacore,parsym,model,showprog,a0,#]& /@ svec0];
     If[model=="Add",  
     mat1=TwinFitProfileAddCoreX[datacore,parsym,showprog,a0,#]& /@ svec0];
    {smin,smax}=ProfileFocusX[mat1];
  Return[{smin,smax}]]
    


  
TwinFitProfileModelPlot[datacore_,parsym_,model_,showprog_,a0_,avec0_,svec0_]:=
 Module[{devvec,vvec,avec,bvec,cvec,svec,pvec,hfvec,
              mat,mat1,pairDEV,pairHF,plotDEV,plotHF,plotvec},
    If[model=="AR" || model=="AD" || model=="ARN" || model=="ADN" || model=="AR3" || model=="AD3",    
        mat=TwinFitProfileModCoreX[datacore,parsym,model,showprog,a0,#]& /@ svec0];
     If[model=="Add",  
           mat=TwinFitProfileAddCoreX[datacore,parsym,showprog,a0,#]& /@ svec0];
     
      color=GenColor[avec0,a0];
    (*ONLY DEVIANCES LESS THAN 10*)
    mat1=Select[mat,(#[[1]]<10)&];
    If[Length[mat1]==0,
       mat2=Sort[mat];
       vec2=mat2[[1]];
        mat3= {vec2},
        mat3=mat1];
        
    If[Length[mat3]>0,
      {devvec,vvec,avec,bvec,cvec,svec,pvec,hfvec}=Transpose[mat3];
       pairDEV=Transpose[{svec,devvec}];
     	pairHF=Transpose[{svec,hfvec}];
     	pairPREV=Transpose[{svec,pvec}];
     	plotDEV=ListPlot[pairDEV, Joined->True,PlotStyle->color];
     	plotHF=ListPlot[pairHF, Joined->True,PlotStyle->color];
     	plotPREV=ListPlot[pairPREV, Joined->True,PlotStyle->color],    
    (*else*)
     plotDEV={};
     plotHF={};
     plotPREV={};
     devvec={};
     hfvec={};
     svec={};
   pvec={}];
   plotvec={plotDEV,plotHF,plotPREV,devvec,hfvec,svec,pvec};
      Return[plotvec]]




TwinFitProfileModCoreX[datacore_,parsym_,model_,showprog_,a0_,s0_]:=
Module[{a,b,c,s,parsym0,devsym0,dev0,rule,res0,res},
       {a,b,c,s}=parsym;
       parsym0={a0,b,c,s0};
       devsym0=GenDevMod[parsym0,datacore, model];
       {dev0,rule}=Quiet@NMinimize[{devsym0, b>0 && b <1 && c>0 && c <1},{b,c}];
     {b0,c0}={b,c}/.rule;
     res=ComputeFinalParameters[model,{dev0,a0,b0,c0,s0}];
    Return[res]]



TwinFitProfileAddCoreX[datacore_,parsym_,showprog_,a0_,s0_]:=
Module[{a,b,c,s,parsym0,devsym0,dev0,rule,res0,res,aminx},
      {a,b,c,s}=parsym;
       parsym0={a0,b,c,s0};
         devsym0=GenDevAdd[parsym0,datacore, model];
         {dev0,rule}=Quiet@NMinimize[{devsym0,b>0 && b <1 && c>0 && c <1},{b,c}];
     {b0,c0}={b,c}/.rule;
     res=ComputeFinalParameters["Add",{dev0,a0,b0,c0,s0}];
   Return[res]]



  GenDevMod[parsym_,datacore_,model_]:=
  Module[{fvec,liksat,like,dev},
  	fvec=GenProbMod[parsym,model];
         liksat=GenLikSat[datacore];
        	lik=Apply[Plus,datacore Log[fvec]];
      	dev=2(liksat-lik)//Simplify;
 Return[dev]]

 
 GenDevAdd[parsym_,datacore_,model_]:=
 Module[{fvec,liksat,like,dev},
 	fvec=GenProbAdd[parsym];
        liksat=GenLikSat[datacore];
       	lik=Apply[Plus,datacore Log[fvec]];
     	dev=2(liksat-lik)//Simplify;
 Return[dev]]


 



(*--------------------------------------------------------------*)

GenLikSat[datacore_]:=
 Module[{xMii, xMic, xMcc, xDii, xDic, xDcc,nM,nD,
           fvec,vecM,vecD,fsatM,fsatD,liksatM,liksatD,liksat,lik, dev},
	{xMii, xMic, xMcc, xDii, xDic, xDcc}=datacore;		
 	nM=xMii+xMic+xMcc;
 	nD=xDii+xDic+xDcc;
  (*probabiliteis for saturated model*)
 	vecM={xMii,xMic,xMcc};
 	vecD={xDii,xDic,xDcc};
 	fsatM=vecM/nM;	
 	fsatD=vecD/nD;
 (*log-likelihood*)
 	liksatM=Apply[Plus,vecM Log[fsatM]];
 	liksatD=Apply[Plus,vecD Log[fsatD]];
 	liksat=liksatM+liksatD;	
Return[liksat]]


ProfileFocusX[mat_]:=
Module[{mats,res,devmin,mat1,svec,smin,smax,svec2},
    mats=Sort[mat];
    res=mats[[1]];
    devmin=res[[1]];
    mat1=Select[mat,(#[[1]] <= devmin +10)&];
    svec=(Transpose[mat1])[[-3]];
    smin=Min[svec];
    smax=Max[svec];
     res={smin,smax};
Return[res]]



  GenLine[devvec0_,hfvec0_,svec0_,pvec0_,s0_]:=
      Module[{devvec,hfvec,svec,devmax,hfmax,smax,devmin,hfmin,smin, vDEV,vHF,atextDEV,atextHF,color,res,as,aname,linedev,linehf},
             devvec=Flatten[devvec0];
             hfvec=Flatten[hfvec0];
             svec=Flatten[svec0];
             pvec=Flatten[pvec0];
             devmax=Max[devvec];
             hfmax=Max[hfvec];
             smax=Max[svec];
             rrmax=Max[pvec];
             devmin=Min[devvec];
             hfmin=Min[hfvec];
             smin=Min[svec];
             rrmin=Min[pvec];
             linedev=Graphics@Line[{{s0,devmin},{s0,devmax}}];
             linehf=Graphics@Line[{{s0,hfmin},{s0,hfmax}}];
             linerr=Graphics@Line[{{s0,0},{s0,rrmax}}];
             res={linedev,linehf,linerr};
           Return[res]]

   

   
   
   GenLabel[devvec0_,hfvec0_,svec0_,pvec0_,avec0_,a0_]:=
   Module[{devvec,hfvec,svec,devmax,hfmax,smax,devmin,hfmin,smin, vDEV,vHF,atextDEV,atextHF,color,res,as,aname},
         devvec=Flatten[devvec0];
          hfvec=Flatten[hfvec0];
          svec=Flatten[svec0];
          pvec=Flatten[pvec0];
          devmax=Max[devvec];
          hfmax=Max[hfvec];
          smax=Max[svec];
          rrmax=Max[pvec];
          devmin=Min[devvec];
           hfmin=Min[hfvec];
            smin=Min[svec];
          rrmin=Min[pvec];
          as=ToString[a0];
	    aname=StringJoin["a= ",as];   
           color=GenColor[avec0,a0];   
           vDEV= a0 (devmax-devmin) +devmin;
           vHF= a0  (hfmax-hfmin) + hfmin;
           vPREV= a0  (rrmax-rrmin) + rrmin;
           sdif=smax-smin;
           atextDEV= Graphics@{color,Text[aname, {.001,  vDEV},{-1,0}]};      
         atextHF= Graphics@{color,Text[aname, {.001,  vHF},{-1,0}]};      
         atextPREV= Graphics@{color,Text[aname, {.001,  vPREV},{-1,0}]};      
         res={atextDEV,atextHF,atextPREV};
        Return[res]]
 

GenRange[devvec0_,hfvec0_,svec0_,pvec0_]:=
Module[{devvec,hvec,pvec,devmax,hfmax,rrmax,devmin,hfmin,rrmin,rangeDEV,rangeHR,rangePREV},
   devvec=Flatten[devvec0];
     	            hfvec=Flatten[hfvec0];
     	            pvec=Flatten[pvec0];
     	            svec=Flatten[svec0];
     	            rrmax=Max[pvec];
     	            devmax=Max[devvec];
     	            hfmax=Max[hfvec];
     	            rrmax=Max[pvec];
                   devmin=Min[devvec];
     	             hfmin=Min[hfvec];
	            rrmin=Min[pvec];
	            smax=Max[svec];
	            smin=Min[svec];
	            sdif=smax-smin;
	            ranges={0,Automatic};
                   rangePREV={ranges, {rrmin,rrmax}};
                   rangeDEV={ranges,{devmin,devmax}};
                   rangeHF={ranges,{hfmin,hfmax}};
 Return[{rangeDEV,rangeHR,rangePREV}]]; 
 
 

GenColor[avec0_,a0_]:=
Module[{color},
      num=Flatten[Position[avec0,a0]][[1]];
        If[num==1, color=Orange];
    	  If[num==2, color=Red];
    	  If[num==3, color=Green];
    	  If[num==4, color=Blue];
          If[num==5, color=Purple];
Return[color]]
   

End[] 
EndPackage[]


