(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Date 2014*)
(*Input
ComputePrev			twinfitprob.m
ComputeFinalParameters	 twinfitprob.m
GenProbAdd			 twinfitprob.m
GenProbMod			 twinfitprob.m *)


BeginPackage["twinfitprofile`","twinfitprob`","twinfitfreq`","twinfitdata`","matrixlx`"]  


TwinFitProfile::usage="TwinFitProfile"
ProfileFocus::usage="ProfileFocus"

Clear[TwinFitProfile,ProfileFocus]


Begin["Private`"]


TwinFitProfile[datacore_,parsym_,model_,showprog_,amin_]:=  
  Module[{mat},
          If[model=="AR" || model=="AD" || model=="ARN" || model=="ADN" || model=="AR3" || model=="AD3",   
              mat=TwinFitProfileMod[datacore,parsym,model,showprog,amin]];
         If[model=="Add", 
	       mat=TwinFitProfileAdd[datacore,parsym,showprog,amin]];
      Return[mat]]


(*-------AR or AD-------------------*)

TwinFitProfileMod[datacore_,parsym_,model_,showprog_,amin_]:=
   Module[{mat1,mat2,svec1,svec2},
   svec1={.0005, .001,.004, .01, .05, .1, .2,.3,.4};
    mat1=TwinFitProfileModCore[datacore,parsym,model,#,showprog,amin]& /@ svec1;
   svec2=ProfileFocus[mat1];
    mat2=TwinFitProfileModCore[datacore,parsym,model,#,showprog,amin]& /@ svec2;
      PrintProfileTables[mat1,mat2,showprog];
     TwinFitProfilePlot[datacore,parsym,modelvec,showprog,censoringstart,numcatfin];
    Return[mat2]]
 

TwinFitProfileModCore[datacore_,parsym_,model_,s0_,showprog_,amin_]:=
Module[{a,b,c,s,parsym0,devsym0,dev0,rule,a0,b0,c0,res},
       {a,b,c,s}=parsym;
       parsym0={a,b,c,s0};
       devsym0=GenDevMod[parsym0,datacore, model];
       {dev0,rule}=Quiet@NMinimize[{devsym0, a>amin && a < 1 && b>0 && b <1 && c>0 && c <1},{a,b,c}];
     {a0,b0,c0}={a,b,c}/.rule;
     res=ComputeFinalParameters[model,{dev0,a0,b0,c0,s0}];
   Return[res]]


 GenDevMod[parsym_,datacore_,model_]:=
 Module[{fvec,liksat,like,dev},
 	fvec=GenProbMod[parsym,model];
        liksat=GenLikSat[datacore];
       	lik=Apply[Plus,datacore Log[fvec]];
     	dev=2(liksat-lik)//Simplify;
 Return[dev]]
 



(*---------------------------------------------Additive model------------------------------------*)


TwinFitProfileAdd[datacore_,parsym_,showprog_,amin_]:=
 Module[{svec1, mat1, svec2, mat2},
    svec1= .25 Range[50]/50;    
    mat1=TwinFitProfileAddCore[datacore,parsym,#,showprog,amin]& /@ svec1;
    svec2=ProfileFocus[mat1];
    mat2=TwinFitProfileAddCore[datacore,parsym,#,showprog,amin]& /@ svec2;
     PrintProfileTables[mat1,mat2,showprog];
 Return[mat2]]
  

TwinFitProfileAddCore[datacore_,parsym_,s0_,showprog_,amin_]:=
Module[{a,b,c,s,parsym0,devsym0,dev0,rule,res0,a0,b0,c0,res},
       {a,b,c,s}=parsym;
       parsym0={a,b,c,s0};
         devsym0=GenDevAdd[parsym0,datacore, model];
         {dev0,rule}=Quiet@NMinimize[{devsym0, a>amin  && a <1 && b>0 && b <1 && c>0 && c <1},{a,b,c}];
     {a0,b0,c0}={a,b,c}/.rule;
     res=ComputeFinalParameters["Add",{dev0,a0,b0,c0,s0}];
   Return[res]]


 
 

 
 GenDevAdd[parsym_,datacore_,model_]:=
 Module[{fvec,liksat,like,dev},
 	fvec=GenProbAdd[parsym];
        liksat=GenLikSat[datacore];
       	lik=Apply[Plus,datacore Log[fvec]];
     	dev=2(liksat-lik)//Simplify;
 Return[dev]]


 




(*--------------------------------------------------------------*)

GenLikSat[datacore_]:=
 Module[{xMii, xMic, xMcc, xDii, xDic, xDcc,nM,nD,
           fvec,vecM,vecD,fsatM,fsatD,liksatM,liksatD,liksat,lik, dev},
	{xMii, xMic, xMcc, xDii, xDic, xDcc}=datacore;		
 	nM=xMii+xMic+xMcc;
 	nD=xDii+xDic+xDcc;
  (*probabiliteis for saturated model*)
 	vecM={xMii,xMic,xMcc};
 	vecD={xDii,xDic,xDcc};
 	fsatM=vecM/nM;	
 	fsatD=vecD/nD;
 (*log-likelihood*)
 	liksatM=Apply[Plus,vecM Log[fsatM]];
 	liksatD=Apply[Plus,vecD Log[fsatD]];
 	liksat=liksatM+liksatD;	
Return[liksat]]



ProfileFocus[mat_]:=
Module[{mats,res,devmin,mat1,svec,smin,smax,svec2},
    mats=Sort[mat];
    res=mats[[1]];
    devmin=res[[1]];
    mat1=Select[mat,(#[[1]] <= devmin +10)&];
    svec=(Transpose[mat1])[[-3]];
    smin=Min[svec];
    smax=Max[svec];
     svec2=smin+(smax-smin) Range[40]/40//N;     
Return[svec2]]

PrintProfileTables[mat1_,mat2_,showprog_]:=
 Module[{colname},   
 If[showprog,
     colname={"dev","v","a", "b", "c", "s", "prev", "frac"};
       Print["initial profile"];
       Print@TableForm[mat1,TableHeadings->{None,colname}];
       Print["profile focus"];
       Print@TableForm[mat2,TableHeadings->{None,colname}]]; 
Return[Null]]


End[] 
EndPackage[]


