(*:Mathematica:: Version 8 *)
(*:Conteft:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Input
FreqAR3 	          twinfitfreq.m
FreqAD3 	           twinfitfreq.m
XFreqAR 	  	   twinfitfreq.m
XFreqAD 	   	   twinfitfreq.m
XFreqARN 	   twinfitfreq.m
XFreqADN 	   twinfitfreq.m
XFreqAdd		   twinfitfreq.m*)

 (*Export
 ComputePrev			twinfitprofile.m
 ComputeFinalParameters	 twinfitprofile.m
 GenProbAdd			 twinfitprofile.m
 GenProbMod			 twinfitprofile.m *)


BeginPackage["twinfitprob`","twinfitfreq`"]  

GenProb::usage="GenProb[{a,b,c,s},model]"
GenProbMod::usage="GenProb[{a,b,c,s},model]"
GenProbAdd::usage="GenProbAdd[{a,b,c,s}]"

ComputePrev::"ComputePrev[model,s0]"
ComputeFinalParameters::usage="ComputeFinalParameters[model,{dev0,a0,b0,c0,s0}]"
ComputeFinalFreq::usage="ComputeFinalFreq[model,s0]"

PlotLatentClass::usage="PlotLatentClass"
PlotLatentClassProbCombined::usage="PlotLatentClassProbCombined"


Clear[GenProbMod,ComputePrev,GenProbAdd, 
       PlotLatentClassProbCombined,PlotLatentClass,
         ComputeFinalParameters,ComputeFinalFreq]

Begin["Private`"]


GenProb[{a_,b_,c_,s_},model_]:=
  Module[{mat},
        If[model=="AR" || model=="AD" || model=="ARN" || model=="ADN" || model=="AR3"  || model=="AD3",  res=GenProbMod[{a,b,c,s},model]];
        If[model=="Add",  res=GenProbAdd[{a,b,c,s}]];
     Return[res]]


GenProbMod[{a_,b_,c_,s_},model_]:=
Module[{hM0,hM2,hD0,hD1,hD2,
           fMii0, fMic0, fMcc0, fMii2, fMic2, fMcc2,	 
             fDii0, fDic0, fDcc0, v,
             fDii1, fDic1, fDcc1,  fDii2, fDic2, fDcc2,
   	    fMii, fMic, fMcc, fDii, fDic, fDcc,fvec},
(*frequencies*)
	If[model=="AR",    {{hM2,hM0},{hD2,hD1,hD0}}=XFreqAR[s]];
	If[model=="ARN",  {{hM2,hM0},{hD2,hD1,hD0}}=XFreqARN[s]];
	If[model=="AD",    {{hM2,hM0},{hD2,hD1,hD0}}=XFreqAD[s]];
	If[model=="ADN",  {{hM2,hM0},{hD2,hD1,hD0}}=XFreqADN[s]];
	
	If[model=="AR3",  {{hM2,hM0},{hD2,hD1,hD0}}=FreqAR3[s]];  
	If[model=="AD3",  {{hM2,hM0},{hD2,hD1,hD0}}=FreqAD3[s]];  
	
(*MZ Latent class 0*)
     fMii0 =  hM0 b;
     fMic0 =  hM0 (1-b) c;
     fMcc0 =  hM0 (1-b)(1- c);
(*MZ Latent class 2*)
     fMii2 =  hM2 a^2;		  
    fMic2 =  hM2 a (1-a) 2;
    fMcc2 =  hM2 (1-a)^2; 
(*DZ Latent class 0 *)
 (*marginal probability*)
   v= b + (1-b)c/2;
   fDii0 =  hD0 b;				  
   fDic0 =  hD0  (1-b) c ;
    fDcc0 =  hD0 (1- b)(1-c);
(*DZ Latent class 1 *)
   fDii1 =  hD1 v a;
   fDic1 =  hD1  (v (1-a)+ (1-v) a) ;
    fDcc1 =  hD1 (1-v) (1-a);
(*DZ Latent class 2 *)
   fDii2 =  hD2 a^2;		  
    fDic2 =  hD2 a (1-a) 2;
    fDcc2 =  hD2 (1-a)^2;  
(*result*)  
    fMii=fMii0+fMii2;
    fMic=fMic0+fMic2;
   fMcc=fMcc0+fMcc2;
  fDii=fDii0+fDii1+fDii2;
  fDic=fDic0+fDic1+fDic2;
  fDcc=fDcc0+fDcc1+fDcc2;
  fvec={fMii, fMic, fMcc, fDii, fDic, fDcc};
Return[fvec]]





GenProbAdd[{a_,b_,c_,s_}]:=
Module[{e1,e2,p1,p2},
       p1=a/2;
       p2=a;
       res=GenProbAddCore[{p1,p2,b,c,s}];
     Return[res]]
     



     

GenProbAddCore[{p1_,p2_,b_,c_,s_}]:=
Module[{hM0,hM2,hD0,hD1,hD2,e1,e2,
       hM22,hM11,hM00,
            hD22,hD21,hD20,hD11,hD10,hD00,
           v,check,checkh,checkM,checkD,
   	    fM2, fM1, fM0, fD2, fD1, fD0,fvec},
        v= b + (1-b)c/2;
	 {{hM22,hM11, hM00},{hD22,hD21,hD20,hD11,hD10,hD00}}=XFreqAdd[s];
	
	fM2= hM22 p2 p2 +  hM11  p1 p1 + hM00 b;
	fM1= hM22 p2 (1-p2) 2 + hM11 p1 (1-p1)2 + hM00 (1- b) c;  
	fM0=hM22 (1-p2) (1-p2) + hM11 (1-p1) (1-p1) + hM00 (1-b) (1-c);
	
	
	fD2= hD22 p2 p2  + 
	        hD21 p2 p1 + 
	        hD20 p2 v + 
	        hD11 p1 p1 + 
	        hD10 p1 v + 
	        hD00 b;
	        
	fD1=hD22 p2 (1-p2)  2+
	       hD21 (p2 (1-p1) + p1 (1-p2)) + 
	       hD20 (p2 (1-v)  + v (1-p2)) + 
	       hD11 p1 (1-p1) 2 +  
	        hD10 (p1 (1-v) + (1-p1) v) + 
	        hD00 (1-b) c;	
	
	fD0=hD22 (1-p2) (1-p2) + 
	        hD21 (1-p2) (1-p1) + 
	        hD20 (1-p2) (1-v) + 
	        hD11 (1-p1) (1-p1) +
	        hD10 (1-p1) (1-v) + 
	        hD00 (1-b) (1-c);
  fvec={fM2, fM1, fM0, fD2, fD1, fD0};
 Return[fvec]]





ComputePrev[model_,s0_]:=
Module[{prev},
If[model=="AR" || model=="ARN",  prev=s0^2];
If[model=="AD" || model=="ADN",  prev=1 - (1-s0)^2];
If[model=="Add",  prev=(2-s0) s0 ];
Return[prev]]



(*-------------------------------------------------*)



ComputeFinalParameters[model_,{dev0_,a0_,b0_,c0_,s0_}]:=
Module[{prev0,v0,frac0,res0,afin,rr0,logrr0,logdev0},
      (*prevalence*)
        prev0=ComputePrev[model,s0];
    (*risk of event given not-susceptible*)
         v0= b0 + (1-b0)c0/2;  
    (*fraction of events suceptible*)  
  If[model=="AR" || model=="ARN" || model=="AD" || model=="ADN" || model=="AR3" || model=="AD3",      
       frac0=(prev0 a0) / ((prev0 a0 + (1-prev0) v0))];
  If[model=="Add",      
       {{hM22,hM11, hM00},{hD22,hD21,hD20,hD11,hD10,hD00}}=XFreqAdd[s0];
           p1=a0/2;
          p2= a0;
       frac0=(hM22 p2 + hM11 p1) /(hM22 p2 + hM11 p1 + hM00 	  v0)]; 
    (*output*)  
       If[v0>0, rr0=a0/v0, rr0=1];
       res0= {dev0,rr0,a0,b0,c0,s0,prev0,frac0};
    Return[res0]]
   
  
  ComputeFinalFreq[model_,s0_]:=
  Module[{prev0,v0,frac0,res0,tabM,tabD,colnameM,colnameD},
        If[model=="AR",    res0= XFreqAR[s0]];
       	If[model=="ARN",  res0= XFreqARN[s0]];
       	If[model=="AD",    res0= XFreqAD[s0]];
  	If[model=="ADN",  res0= XFreqADN[s0]];
  	If[model=="Add",  res0= XFreqAdd[s0]];
   {hvecM,hvecD}=res0;
   tabM={hvecM};
   tabD={hvecD};
   If[model=="AR" || model=="ARN" || model=="AD" || model=="ADN" || model=="AR3" || model=="AD3",  
      colnameM={"hM2","hM0"};
      colnameD={"hD2","hD1","hD0"}];
    If[model=="Add" ,  
          colnameM={"hM22","hM11","hM00"};  
          colnameD={"hD22","hD21","hD20","hD11","hD10","hD00"}];
     Print@TableForm[tabM,TableHeadings->{None,colnameM}];
     Print@TableForm[tabD,TableHeadings->{None,colnameD}];  
   Return[Null]]
   

PlotLatentClassProbCombined[s_]:=
Module[{plotvecAR,pltvecARN,plotvecAD,plotvecADN,plotvec,x},
   colorAR=Red;
   colorARN=Orange;
   colorAD=Blue;
   colorADN=Purple;
   colorAR3=Green;
   colorAD3=Black;
   
   plotvecAR=PlotLatentClassProbCombinedMod[s,"AR",colorAR];
   plotvecARN=PlotLatentClassProbCombinedMod[s,"ARN",colorARN];
   plotvecAD=PlotLatentClassProbCombinedMod[s,"AD",colorAD];
   plotvecADN=PlotLatentClassProbCombinedMod[s,"ADN",colorADN];
   plotvecAD3=PlotLatentClassProbCombinedMod[s,"AD3",colorAD3];
   plotvecAR3=PlotLatentClassProbCombinedMod[s,"AR3",colorAR3];
   plovec= {plotvecAR,plotvecARN,plotvecAD,plotvecADN,plotAR3,plotAD3};
   x=.1;
   textvecAR=Graphics@{colorAR,Text["AR",{x,.2},{-1,0}]};
   textvecARN=Graphics@{colorARN,Text["ARN",{x,.3},{-1,0}]};
   textvecAD=Graphics@{colorAD,Text["AR",{x,.4},{-1,0}]};
   textvecADN=Graphics@{colorADN,Text["ARN",{x,.5},{-1,0}]};
   textvecAR3=Graphics@{colorAR3,Text["AR3",{x,.6},{-1,0}]};
   textvecAD3=Graphics@{colorAD3,Text["AD3",{x,.7},{-1,0}]};

      
   plotvec=Flatten@{plotvecAR,plotvecARN,plotvecAD,plotvecADN,plotvecAR3,plotvecAD3};
    textvec=Flatten@{textvecAR,textvecARN,textvecAD,textvecADN,textvecAR3,textvecAD3};
   resvec=Join[plotvec,textvec];
   
   plot=Show[resvec,PlotRange->{{0,1},{0,1}},AspectRatio->1, ImageSize->Large, FrameLabel->{"s","prob",None,None}];
   Print[plot];
  
  
  Return[Null]] 

PlotLatentClassProbCombinedMod[s_,model_,color_]:=
Module[{hM0,hM2,hD0,hD1,hD2,dashD2,dashD1,
           plotM2,plotD2,plotD1},
(*frequencies*)
	If[model=="AR",    {{hM2,hM0},{hD2,hD1,hD0}}=XFreqAR[s]];
	If[model=="ARN",  {{hM2,hM0},{hD2,hD1,hD0}}=XFreqARN[s]];
	If[model=="AD",    {{hM2,hM0},{hD2,hD1,hD0}}=XFreqAD[s]];
	If[model=="ADN",  {{hM2,hM0},{hD2,hD1,hD0}}=XFreqADN[s]];
	
	If[model=="AD3",  {{hM2,hM0},{hD2,hD1,hD0}}=FreqAD3[s]];  
	If[model=="AR3",  {{hM2,hM0},{hD2,hD1,hD0}}=FreqAR3[s]];  
	
	Print[model, "  prev =  ", Simplify[hM2]];
         plotM2=Plot[hM2,{s,0,1},PlotStyle->color];
        dashD2=Dashing[{.01,.01}];
        dashD1=Dashing[{.03,.03}];
        
        plotD2=Plot[hD2,{s,0,1},PlotStyle->{color,dashD2}];
         plotD1=Plot[hD1,{s,0,1},PlotStyle->{color,dashD1}];
         
       Return[{plotM2,plotD2,plotD1}]]
       
         

PlotLatentClass[s_]:=
Module[{plotset,plotmat},
plotset=PlotClass[s,#]& /@ {"AR","ARN","AD","ADN"};
plotmat=Show[GraphicsGrid@Partition[plotset,2], ImageSize->Large];
  figname="fig2";
  namez=StringJoin["twinfit",figname,".eps"];
	   Print["     export ", namez];
	   Export[namez,plotmat];     
Print[plotmat];
Return[Null]]



PlotClass[s_,model_]:=
Module[{hM0,hM2,hD0,hD1,hD2,textM2,textM0,textD2,textD1,textD0,
        lineM2,lineM0,lineD2,lineD1,lineD0,x1,x2,y0,i,yM2,yM0,yD2,yD1,yD0,
        
          plotM2,plotD2,plotD1,plot},
(*frequencies*)
   If[model=="AR" || model=="ARN" || model=="AD" || model=="ADN",  	
  	If[model=="AR",    {{hM2,hM0},{hD2,hD1,hD0}}=XFreqAR[s]];
	If[model=="ARN",  {{hM2,hM0},{hD2,hD1,hD0}}=XFreqARN[s]];
	If[model=="AD",    {{hM2,hM0},{hD2,hD1,hD0}}=XFreqAD[s]];
	If[model=="ADN",  {{hM2,hM0},{hD2,hD1,hD0}}=XFreqADN[s]];
	If[model=="AR" || model=="ARN", x3=.1];
	If[model=="AD" || model=="ADN", x3=.7];
	x1=x3+.1+.09;
	x2=x3+.199+.09;
	y0=.7;
	i=-.1;
	yM2=y0;
	yM0=y0+i;
	yD2=y0+2 i;
	yD1=y0+3 i;
	yD0=y0+4 i;
	
	textM2=Graphics@Text["hM2(s)",{x3,yM2},{-1,0}];
	textM0=Graphics@Text["hM0(s)",{x3,yM0},{-1,0}];
	textD2=Graphics@Text["hD2(s)",{x3,yD2},{-1,0}];
	textD1=Graphics@Text["hD1(s)",{x3,yD1},{-1,0}];
	textD0=Graphics@Text["hD0(s)",{x3,yD0},{-1,0}];
	
	lineM2=Graphics@{Red,Line[{{x1,yM2 }, {x2,yM2}}]};
	lineM0=Graphics@{Dashing[{.01,.01}],Red,Line[{{x1,yM0}, {x2,yM0}}]};
	lineD2=Graphics@{Green,Line[{{x1,yD2}, {x2,yD2}}]};
	lineD1=Graphics@{Blue,Line[{{x1,yD1 } ,{x2,yD1}}]};
	lineD0=Graphics@{Dashing[{.01,.01}],Green,Line[{{x1,yD0}, {x2,yD0}}]};
	
  	
	
	
        plotM2=Plot[hM2,{s,0,1},PlotStyle->Red];
        plotM0=Plot[hM0,{s,0,1},PlotStyle->{Dashing[{.01,.01}],Red}];
        plotD2=Plot[hD2,{s,0,1},PlotStyle->Green];
        plotD1=Plot[hD1,{s,0,1},PlotStyle->Blue];
        plotD0=Plot[hD0,{s,0,1},PlotStyle->{Dashing[{.01,.01}],Green}];
        plot=Show[plotM2,plotM0,plotD2,plotD1,plotD0, 
        textM2,textM0,textD2,textD1,textD0,
        lineM2,lineM0,lineD2,lineD1,lineD0,
        
        Frame->True, FrameLabel->{"s", "class probability",model,None}]];
     If[model=="Add",  
         {{hM22,hM11, hM00},{hD22,hD21,hD20,hD11,hD10,hD00}}=XFreqAdd[s];
          plotM22=Plot[hM22,{s,0,1},PlotStyle->Red];
          plotM11=Plot[hM22,{s,0,1},PlotStyle->Orange];
         plotM00=Plot[hM00,{s,0,1},PlotStyle->{Dashing[{.01,.01}],Red}];
          plotD22=Plot[hD22,{s,0,1},PlotStyle->Green];
          plotD21=Plot[hD22,{s,0,1},PlotStyle->Green];
         plotD20=Plot[hD22,{s,0,1},PlotStyle->Green];
         plotD11=Plot[hD11,{s,0,1},PlotStyle->Blue];
         plotD10=Plot[hD11,{s,0,1},PlotStyle->Blue];
         plotD00=Plot[hD00,{s,0,1},PlotStyle->{Dashing[{.01,.01}],Green}];
         plot=Show[plotM22,plotM20,plotD2,plotD1,plotD0, Frame->True, FrameLabel->{"freq", "class prob",model,None}]];
         
        
    Return[plot]]    

   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
   
End[] 
EndPackage[]



