(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Input
FitEM			twinfitem.m
TwinFitProfile 	  	 twinfitprofile.m
TwinFitPlotCore	  	 twinfitprofileplot.m
TwinFitEst			twinfitcore.m
TwinFitBoot		twinfitcore.m
GenProb		          twinfitprob.m
*)


BeginPackage["twinfitheritability`","twinfitprob`", "twinfitprofile`","twinfitcore`","twinfitprofileplot`",
"twinfitsummary`","twinfitem`","twinfitfreq`","twinfitdata`","twinfitvar`","matrixlx`"]  

TwinFitPlotH::usage="TwinFitPlotH"


Clear[TwinFitPlotH]


Begin["Private`"]



 
 TwinFitPlotH[]:=
 Module[{plot11,plot12,plot21,plot22,plotset,plot},
    colorAR=Red;
 	colorAD=Darker[Green];
      	colorAdd=Blue;
      
     colorvec={colorAR,colorAD,colorAdd};
    plot11=PlotHAC[1,1,colorvec];
    plot12=PlotHAC[1,2,colorvec];
    plot21=PlotHAC[2,1,colorvec];
    plot22=PlotHAC[2,2,colorvec];
   plotset=GraphicsGrid[{{plot11,plot12},{plot21,plot22}}];
   plot=Show[plotset,ImageSize->Large];
    figname="fig2";
     namez=StringJoin["twinfit",figname,".eps"];
   	   Print["     export ", namez];
   	   Export[namez,plot]; 
   Print[plot];
 Return[Null]]
 
 
 
 
 PlotHAC[anum_,cnum_,colorvec_]:=
  Module[{plotset,set,plotvec,diag,plotx,modnum,bnum,snum,avec,bvec,cvec,svec,a0,c0,as,bs}	,   
     bnum=1;
     plotvec1=PlotHACModel[1,anum,cnum,colorvec];
     plotvec2=PlotHACModel[2,anum,cnum,colorvec];
     plotvec3=PlotHACModel[3,anum,cnum,colorvec];
       {textAR,textAD,textAdd,lineAR,lineAD,lineAdd}=GenKey[colorvec];
       diag=Graphics@{Line[{{0,0},{1,1}}]};
        {avec,bvec,cvec,svec}=GenParSet[1]; 
        a0=avec[[anum]];
       b0=bvec[[bnum]];
       c0=cvec[[cnum]];
       as=ToString[a0];
       cs=ToString[c0];
       bs=ToString[b0];
       name=StringJoin["a= ",as,"  b = ",bs,"  c= ",cs];
  plotx=Show[plotvec1,plotvec2,plotvec3,diag, textAR,textAD,textAdd,lineAR,lineAD,lineAdd,
  PlotRange->{{0,.2},{0,.2}}, Frame->True,AspectRatio->1,FrameLabel->{"HF","heritability",name,None}];
  Return[plotx]]

 PlotHACModel[modnum_,anum_,cnum_,colorvec_]:=
Module[{color,plotset,set},
   color=colorvec[[modnum]];
   bnum=1;
    set=Table[PlotHPair[modnum,anum,bnum,cnum,snum], {snum,5}];
     plot=ListPlot[set,  Joined->True,
     PlotStyle->{color}];
    Return[plot]] 
 

PlotHPair[modnum_,anum_,bnum_,cnum_,snum_]:=
     Module[{modvec,avec,cvec,svec,model,a0,b0,c0,s0,datacore0,prevZ,fracZ,h,pair},
             modvec={"AR","AD","Add"};
            {avec,bvec,cvec,svec}=GenParSet[modnum]; 
            model=modvec[[modnum]];
            a0=avec[[anum]];
            b0=bvec[[bnum]];
	    c0=cvec[[cnum]];
            s0=svec[[snum]];
           datacore0=GenDataCoreX[model,{a0,b0,c0,s0},{10000 ,10000}];   
           {prevZ,fracZ}=ComputeFrac[model,a0,b0,c0,s0];
            h=PlotHOne[datacore0];
            pair={fracZ,h};
       Return[pair]]
       

GenParSet[modnum_]:=
Module[{avec,bvec,cvec,svec},
           avec={.7,.99};
            bvec={.7,.9};
            cvec={.05,.3};
            If[modnum==1, svec={.05,.1,.2,.3,.4,.6}];
            If[modnum==2, svec={.001,.01,.05,.1,.16}];
            If[modnum==3, svec={.001,.02,.05,.1,.16}];
            
Return[{avec,bvec,cvec,svec}]];

 
PlotHPairX[model_,parsym0_]:=
     Module[{a0,b0,c0,s0,dev0,estvec0,datacore0,prevX,fracX,pair},
           {a0,b0,c0,s0}=parsym0;
           datacore0=GenDataCoreX[model,parsym0,{10000 ,10000}];   
         {prevZ,fracZ}=ComputeFrac[model,a0,b0,c0,s0];
          h=PlotHOne[datacore0];
          pair={fracZ,h};
       Return[pair]]
       

PlotHOne[datacore_]:=
Module[{m2,m1,m0,d2,d1,d0,rMZ,varrMZ,rDZ,varrDZ,serMZ,serDZ,h,varh,seh,tab},
{m2,m1,m0,d2,d1,d0}=datacore;
rMZ=TetrachoricCorrelation[{m2,m1,m0}];
rDZ=TetrachoricCorrelation[{d2,d1,d0}];
 h= 2 (rMZ-rDZ);
Return[h]]


TetrachoricCorrelation[{x2_,x1_,x0_}]:=
Module[{n00,n10,n01,n11,c,r},
	n11=x2;
	n10=x1/2;
	n01=x1/2;
	n00=x0;
	c=((n00 n11)^.5 - (n01 n10)^.5) / ((n00 n11)^.5 + (n01 n10)^.5);
	r= Sin[(Pi/2) c];
Return[r]]


GenDataCoreX[model_,{a0_,b0_,c0_,s0_},{nM_,nD_}]:=
Module[{par0,datacore,fMii, fMic, fMcc, fDii, fDic, fDcc,xMvec,xDvec},
       par0={a0,b0,c0,s0};
       res0=GenProb[par0,model];
        {fMii, fMic, fMcc, fDii, fDic, fDcc}=  GenProb[par0,model];
       xMvec={fMii, fMic, fMcc} nM;
       xDvec={fDii, fDic, fDcc}  nD;
       datacore=Join[xMvec,xDvec];
 Return[datacore]]    


ComputeFrac[model_,a0_,b0_,c0_,s0_]:=
Module[{prev0,v0,frac0,p1,p2,hM22,hM11, hM00,hD22,hD21,hD20,hD11,hD10,hD00},
   v0= b0 + (1-b0)c0/2;  
     If[model=="AR" || model=="ARN",  prev0=s0^2];
      If[model=="AD" || model=="ADN",  prev0=1 - (1-s0)^2];
      If[model=="Add",  prev0=(2-s0) s0 ];
      If[model=="AR" || model=="ARN" || model=="AD" || model=="ADN" || model=="AR3" || model=="AD3",      
               frac0=(prev0 a0) / ((prev0 a0 + (1-prev0) v0))];
        If[model=="Add",      
             {{hM22,hM11, hM00},{hD22,hD21,hD20,hD11,hD10,hD00}}=XFreqAdd[s0];
                 p1=a0/2;
                p2= a0;
       frac0=(hM22 p2 + hM11 p1) /(hM22 p2 + hM11 p1 + hM00 	  v0)]; 
       fracr=Round[frac0 100]/100//N;
       prevr=Round[prev0 1000]/1000//N;  
       fracr=PadRound[frac0];
       prevr=PadRound[prev0];
Return[{prev0,frac0}]]

GenKey[{colorAR_,colorAD_,colorAdd_}]:=
 Module[{x1,x2,x3,y0,i,yAR,yAD,yAdd,  textAR,textAD,textAdd,lineAR,lineAD,lineAdd},
   scale=.2;
   x3=.02 scale;
     x1=(x3+.1) scale;
     	x2=(x3+.199) scale;
    y0=.7 scale;
     	i=-.1 scale;
     	yAR=y0;
     	yAD=y0+i;
     	yAdd=y0+2 i;
     	     	textAR=Graphics@Text["AR",{x3,yAR},{-1,0}];
     	textAD=Graphics@Text["AD",{x3,yAD},{-1,0}];
     	textAdd=Graphics@Text["Add",{x3,yAdd},{-1,0}];
     	
     	lineAR=Graphics@{colorAR,Line[{{x1,yAR }, {x2,yAR}}]};
     	lineAD=Graphics@{colorAD,Line[{{x1,yAD}, {x2,yAD}}]};
     	lineAdd=Graphics@{colorAdd,Line[{{x1,yAdd}, {x2,yAdd}}]};
 Return[{textAR,textAD,textAdd,lineAR,lineAD,lineAdd}]]
 

End[] 
EndPackage[]


