(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  

BeginPackage["twinfitfreq`"]  

(*fast calculations*)
XFreqAR::usage="XFreqAR[s]"
XFreqAD::usage="XFreqAD[s]"
XFreqARN::usage="XFreqARN[s]"
XFreqADN::usage="XFreqADN[s]"
XFreqAdd::usage="XFreqAdd[s]"

(*original basic calculations*)
FreqARN::usage="FreqARN[s]"
FreqADN::usage="FreqADN[s]"
FreqAdd::usage="FreqAdd[s]"

(*Not used *)
FreqARNRan::usage="FreqARN[s,k]"
FreqAR3::usage="FreqAR3[s]"
FreqAD3::usage="FreqAD3[s]"
GenFreqVec::usage="GenFreqVec[s]"

(*for checking fast calculations*)
FreqCheck::usage="FreqCheck[s,n]"

Clear[XFreqAR,XFreqAD,XFreqAdd, FreqADN,FreqARN,
      XFreqARN,XFreqADN,FreqAdd,
       FreqAR3,FreqAD3,FreqCheck,GenFreqVec,FreqARNRan]


Begin["Private`"]

(*--------------Compact Form of Frequencies-------------------------*)

XFreqAR[s_]:=
Module[{hM0,hM2,hD0,hD1,hD2,res},
  hM2=s^2;
  hM0=1-hM2;			  
  hD2= (1/4) s^2 (1+s)^2;
  hD1= (1/2)  (3 -2s -s^2) s^2;
  hD0=1-hD1-hD2;
  res={{hM2,hM0},{hD2,hD1,hD0}};
Return[res]]

XFreqAD[s_]:=
Module[{hM0,hM2,hD0,hD1,hD2,res},
 hM2=1-(1-s)^2;
 hM0=1-hM2;			  
 hD2= 1-hD0-hD1;
 hD1= (1/2) (4-s) (1-s)^2 s;
 hD0= 1/4 (2 - 3 s + s^2)^2;
  res={{hM2,hM0},{hD2,hD1,hD0}};
Return[res]]
 

  
XFreqARN[s_]:= {{s^2, 1 - s^2}, {s^3, -2*(-1 + s)*s^2, 1 - 2*s^2 + s^3}}

XFreqADN[s_]:= {{-((-2 + s)*s), (-1 + s)^2}, {s + s^2 - s^3, 2*(-1 + s)^2*s, -(-1 + s)^3}}

XFreqAdd[s_]:=
{{s^2, -2*(-1 + s)*s, (-1 + s)^2}, 
 {(s^2*(1 + s)^2)/4, s^2 - s^4, 
  ((-1 + s)^2*s^2)/2, s - 2*s^3 + s^4, 
  -((-2 + s)*(-1 + s)^2*s), (2 - 3*s + s^2)^2/4}}

(*-------------------------------Derivation of frequencies------------------------*)


FreqAR[s_]:=
Module[{mvec,dvec,res},
  pmvec=FreqM[s,"AR"];
  pdvec=FreqD[s,"AR"];
  res={pmvec,pdvec}//Simplify;
Return[res]]

FreqAD[s_]:=
Module[{mvec,dvec,res},
  pmvec=FreqM[s,"AD"];
  pdvec=FreqD[s,"AD"];
  res={pmvec,pdvec}//Simplify;
Return[res]]

(*-------------------------------------------Many gene autosomal recessive-----------------*)

FreqARN[s_,n_]:=
Module[{t, gM2,gM0,gD2,gD1,gD0,
        pM2,pM1,pD2,pD1,pD0,
        pM2ninf,pM1ninf,pD2ninf,pD1ninf,pD0ninf,res},
  (*basic*) 
     t=s^(1/n);
     {gM2,gM0}=FreqM[t,"AR"];
     {gD2,gD1,gD0}=FreqD[t,"AR"];
(*ARN*)
    pD2=gD2^n;
    pD1= 2((gD2 + gD1/2)^n-  gD2^n);    
    pD0=1-pD2-pD1;
    pM2=gM2^n;
    pM0=1-pM2; 
(*as n approaches infinity*)
    pM2ninf=Limit[pM2,n->Infinity, Analytic->True]//Simplify;
    pM0ninf=Limit[pM0,n->Infinity, Analytic->True]//Simplify;
    pD2ninf=Limit[pD2,n->Infinity, Analytic->True]//Simplify;
    pD1ninf=Limit[pD1,n->Infinity, Analytic->True]//Simplify;
    pD0ninf=Limit[pD0,n->Infinity, Analytic->True]//Simplify;
    Print["AR MZ 2   ",pM2ninf];
    Print["AR MZ 0   ",pM0ninf];
    Print["AR DZ 2    ",pD2ninf];
    Print["AR DZ 1    ",pD1ninf];
    Print["AR DZ 0    ",pD0ninf];
    res={{pM2ninf,pM0ninf},{pD2ninf,pD1ninf,pD0ninf}};
Return[res]]

(*-------------------------------------------Many gene autosomal dominant-----------------*)


FreqADN[s_,n_]:=
Module[{t, gM2,gM0,gD2,gD1,gD0,
        pM2,pM1,pD2,pD1,pD0,
        pM2ninf,pM1ninf,pD2ninf,pD1ninf,pD0ninf,res},
(*basic*)        
   t=1-(1-s)^(1/n);
  {gM2,gM0}=FreqM[t,"AD"];
  {gD2,gD1,gD0}=FreqD[t,"AD"];
(*ADN*)
   pD0=gD0^n;
   pD1= 2((gD0 + gD1/2)^n-  (gD0^n)); 
    pD2=1-pD0-pD1;
   pM0=gM0^n;
   pM2=1-pM0;
(*as n approaches infinity*) 
  pM2ninf=Limit[pM2,n->Infinity, Analytic->True]//Simplify;
  pM0ninf=Limit[pM0,n->Infinity, Analytic->True]//Simplify;
  pD2ninf=Limit[pD2,n->Infinity, Analytic->True]//Simplify;
  pD1ninf=Limit[pD1,n->Infinity, Analytic->True]//Simplify;
   pD0ninf=Limit[pD0,n->Infinity, Analytic->True]//Simplify;
    Print["AD MZ 2      ",pM2ninf];
    Print["AD MZ 0   ",pM0ninf];
    Print["AD DZ 2   ",pD2ninf];
    Print["AD DZ 1     ",pD1ninf];
    Print["AD DZ 0     ",pD0ninf];
  res={{pM2ninf,pM0ninf},{pD2ninf,pD1ninf,pD0ninf}};
Return[res]]

(*----------------------three gene autosomal recessive-----------------*)

FreqAR3[s_,k_]:=
Module[{t,type,
        gM2a,gM0a,gD2a,gD1a,gD0a,
        gM2b,gM0b, gD2b,gD1b,gD0b,
        gM2c,gM0c, gD2c,gD1c,gD0c,
        pM2,pM1, pD2,pD1,pD0,
        res},
    t=s^(1/3);
   {gM2a,gM0a}=FreqM[(1/k) t, "AR"];
   {gM2b,gM0b}=FreqM[t,     "AR"];
   {gM2c,gM0c}=FreqM[k t,  "AR"];
   {gD2a,gD1a,gD0a}=FreqD[(1/k) t, "AR"];
  {gD2b,gD1b,gD0b}=FreqD[ t, "AR"];
  {gD2c,gD1c,gD0c}=FreqD[k t,"AR"];
   pD2=(gD2a gD2b gD2c);
   (*included factor of 2 because either twin*)
   pD1=2 (gD2a + gD1a/2) (gD2b + gD1b/2) (gD2c + gD1c/2)  -  2 (gD2a gD2b gD2c);
   pD0=1-pD2-pD1;
   pM2=Simplify@(gM2a gM2b gM2c);                
   pM0=1-pM2;    
   res={{pM2,pM0},{pD2,pD1,pD0}}//N;
   Return[res]]

(*----------------------three gene autosomal dominant-----------------*)

 
 FreqAD3[s_,k_]:=
 Module[{ta,tb,tc,t0x,
         gM2a,gM0a,gD2a,gD1a,gD0a,
         gM2b,gM0b, gD2b,gD1b,gD0b,
         gM2c,gM0c, gD2c,gD1c,gD0c,
         pM2,pM1, pD2,pD1,pD0,
        res},
  
  (*1-g(t))^6 = (1-s)^2)
  1-g(t)= (1-s)^ 1/3
  g(t)= 1- (1-s)^1/3*)
  
  t0x=1 -  (1-s)^(1/3);
  ta= (1/3) t0x;
 tb=  t0x;
 tc= 3 t0x;
 {gM2a,gM0a}=FreqM[ta,"AD"];
 {gM2b,gM0b}=FreqM[tb,"AD"];
 {gM2c,gM0c}=FreqM[tc,"AD"];
 {gD2a,gD1a,gD0a}=FreqD[ta,"AD"];
 {gD2b,gD1b,gD0b}=FreqD[tb,"AD"];
 {gD2c,gD1c,gD0c}=FreqD[tc,"AD"];          
   pD0=(gD0a gD0b gD0c);
  (*included factor of 2 because either twin*)
  pD1=2 (gD0a + gD1a/2) (gD0b + gD1b/2)(gD0c + gD1c/2)-      2 (gD0a gD0b gD0c);  
  pD2=1-pD0-pD1;
  pM0=gM0a gM0b gM0c;
   pM2=1-pM0//Simplify;
 res={{pM2,pM0},{pD2,pD1,pD0}}//N;
Return[res]]





(*-----------------------------CORE FREQUENCIES-------------------------*)

FreqM[s_,type_]:=
Module[{hvec},
 If[type=="AR", hvec={s^2,      1-s^2}];
 If[type=="AD", hvec={1-(1-s)^2, (1-s)^2}];  
Return[hvec]]
        

FreqD[s_,type_]:=
Module[{pXXXX,pXXXx,pXXxx,pXxXX,pXxXx,pXxxx,pxxXX,pxxXx,pxxxx,
    h2,h1,h0,hvec},
  {pXXXX,pXXXx,pXXxx,pXxXX,pXxXx,pXxxx,pxxXX,pxxXx,pxxxx}=GenFreqVec[s];
 If[type=="AR",
   h2=pXXXX;  
   h1=pXXXx+pXXxx+pXxXX+pxxXX; 
   h0=pXxXx+pXxxx+pxxXx+pxxxx];
 If[type=="AD",         
  h2=pXXXX+pXXXx+pXxXX+pXxXx;
  h1=pXXxx+pxxXX+pXxxx+pxxXx; 
  h0=pxxxx]; 
 hvec={h2,h1,h0}//Simplify;
Return[hvec]]

(*----------------------------------------Additive Model-------------------------------------------*)



FreqAdd[s_]:=
Module[{mvec,dvec,res},
  pmvec=FreqAddM[s];
  pdvec=FreqAddD[s];
  res={pmvec,pdvec}//Simplify;
Return[res]]


FreqAddM[s_]:=
Module[{hvec,h22,h11,h00,pM2,pM0,res},
 h22=s^2;
 h11=2 s (1-s);
 h00=(1-s)^2;
 res={h22, h11,h00};
 Return[res]]

FreqAddD[s_]:=
Module[{pXXXX,pXXXx,pXXxx,pXxXX,pXxXx,pXxxx,pxxXX,pxxXx,pxxxx,
  h22,h21,h20,h11,h10,h00,pnorm,pD2,pD1,pD0,res},
  {pXXXX,pXXXx,pXXxx,pXxXX,pXxXx,pXxxx,pxxXX,pxxXx,pxxxx}=GenFreqVec[s];
  h22=pXXXX;  
    h21=pXXXx+pXxXX;
    h20=pXXxx+pxxXX; 
    h11=pXxXx;
    h10=pXxxx+pxxXx;
    h00=pxxxx;
   res={h22,h21,h20,h11,h10,h00}//Simplify;
Return[res]]



(*---------------------key formulas-------------------------*)


GenFreqVec[s_]:=
Module[{f1,f2,f3,f4,f5,f6,pXXXX,pXXXx,pXXxx,pXxXX,pXxXx,pXxxx,pxxXX,pxxXx,pxxxx,res},
f1 = s^4;
f2 = s^2 2 s (1 - s) 2;
f3 = s^2 (1 - s)^2  2;
f4 = 2 s (1 - s) 2 s (1 - s);
f5 = 2 s (1 - s) (1 - s)^2 2;
f6 = (1 - s)^4;
pXXXX= f1 + f2/4 +       f4/16            //Simplify;
pXXXx=      f2/4 +       f4/8                 //Simplify;
pXXxx=                   f4/16                   //Simplify;
pXxXX=      f2/4 +       f4/8                 //Simplify;
pXxXx=      f2/4 + f3 +  f4/4  + f5/4    //Simplify;
pXxxx=                   f4/8  + f5/4          //Simplify;
pxxXX=                   f4/16                  //Simplify;
pxxXx=                   f4/8  + f5/4          //Simplify;
pxxxx=                   f4/16 + f5/4 + f6  //Simplify;
res={pXXXX,pXXXx,pXXxx,pXxXX,pXxXx,pXxxx,pxxXX,pxxXx,pxxxx};
Return[res]]




(*------------------------------check fast formulas----------------------------------------------*)

FreqCheck[s_,n_]:=
Module[{mvec,dvec,mvec3,dvec3,minf,dinf},
Print["AR"];
  resAR=PrintF@FreqAR[s];
  resARX=PrintF@XFreqAR[s];
   Print["  dif ",Simplify[resAR-resARX]];
Print["AD "];
  resAD=PrintF@FreqAD[s];
  resADX=PrintF@XFreqAD[s];
  Print["  dif ",Simplify[resAD-resADX]];
Print["ARN "];
  resARN=PrintF@FreqARN[s,n];
  resARNX=PrintF@XFreqARN[s];
  Print["  dif ",Simplify[resARN-resARNX]];
Print["ADN "];
  resADN=PrintF@FreqADN[s,n];
  resADNX=PrintF@XFreqADN[s];
  Print["  dif ",Simplify[resADN-resADNX]];
Print["Add "];
  resAdd=PrintF@FreqAdd[s];
  resAddX=PrintF@XFreqAdd[s];
  Print["  dif ",Simplify[resAdd-resAddX]];  
Return[Null]]



PrintF[{pmvec_,pdvec_}]:=
Module[{res,pmsum,pdsum },
 pmsum=Simplify@Total[pmvec];
 pdsum=Simplify@Total[pdvec]; 
  Print["   MZ  ",pmvec,  "  sum=", pmsum];
  Print["   DZ   ",pdvec,  "  sum=", pdsum];
 res=Join[pmvec,pdvec]; 
Return[res]]


FreqARNRan[s_,n_]:=
Module[{t, gM2,gM0,gD2,gD1,gD0,
        pM2,pM1,pD2,pD1,pD0,
        pM2ninf,pM1ninf,pD2ninf,pD1ninf,pD0ninf,res},
  (*basic*) 
     kvec=RandomVariate[NormalDistribution[1,.02],n];
     tvec=s^(1/n) kvec;
     {gM2vec,gM0vec}=Transpose@(FreqM[#,"AR"]&  /@ tvec);
     {gD2vec,gD1vec,gD0vec}=Transpose@(FreqD[#,"AR"]& /@tvec);
(*ARN*)
    pD2=Apply[Times, gD2vec];
    pD1= 2 (Apply[Times,gD2vec + gD1vec/2]-  Apply[Times,gD2vec]);    
    pD0=1-pD2-pD1;
    pM2=Apply[Times,gM2vec];
    pM0=1-pM2; 
    res={{pM2,pM0},{pD2,pD1,pD0}};
Return[res]]


End[] 
EndPackage[]

