(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Input
SplitAfterBoth  matrixl.m
SelectBoth   matrixl.m
BlockMatrix   matrixl.m*)

BeginPackage["twinfitem`","twinfitdata`","matrixlx`"] 

FitEM::usage="FitEM[data,maxiter]"

Clear[FitEM]


Begin["Private`"]


FitEM[data_,censoringstart_,numcatfin_]:=
Module[{m2,m1,m0,d2,d1,d0, m2x,m1x,m0x,d2x,d1x,d0x, totm,totd,resm,resd,res,maxiter},
     maxiter=200;
     showem=False;
   If[censoringstart=="after",
    {m2x,m1x,m0x,d2x,d1x,d0x}=data;	
     m2=Augment2[m2x];
     m1=Augment1[m1x];
     m0=Augment0[m0x];
     d2=Augment2[d2x];
     d1=Augment1[d1x];
     d0=Augment0[d0x]];
   If[censoringstart=="during",
    {m2,m1,m0,d2,d1,d0}=data];	
     {fm,iterm}=EM[{m2,m1,m0},maxiter,numcatfin,showem];
     {fd,iterd}= EM[{d2,d1,d0},maxiter,numcatfin,showem];    
    If[showem,     Print["  EM convergence in ",iterm," iterations MZ and ",iterd," iterations DZ"]];
      totm=Total@Flatten[m2+m1+m0];
      totd=Total@Flatten[d2+d1+d0];
      resm= totm fm;
      resd= totd   fd;
      res=Join[resm,resd];
  Return[res]]


Augment2[m2_]:=
Module[{n,col,row,corner,m2x},
n=Length[m2];
col=J[n,1,0];
row=J[1,n,0];
corner={{0}};
m2x=BlockMatrix[{{m2,col},{row,corner}}];
Return[m2x]];


Augment1[m1_]:=
Module[{n,col,row,corner,m1x},
n=Length[m1];
col=J[n,1,0];
row=J[1,n,0];
corner={{0}};
m1x=BlockMatrix[{{col, m1},{row,corner}}];
Return[m1x]];

Augment0[m0_]:=
Module[{n,col,row,corner,m0x},
n=Length[m0];
col=J[n,1,0];
row=J[1,n,0];
corner={{0}};
m0x=BlockMatrix[{{corner, row},{col,m0}}];
Return[m0x]];

(*---------------------------------------------------------------------*)

EM[{mat2_,mat1_,mat0_},maxiter_,numcatfin_,showem_]:=
Module[{mat2sym,mat0sym,estart,probmat,numiter,k,e00,e01,e10,e11,p00,p01,p10,p11},
 (*symmetry for incident-incident, censored-censored*)
     mat2sym=sym[mat2];
     mat0sym=sym[mat0];
     (*SYMMETRY START*)
     estart=EMStart[{mat2sym,mat1,mat0sym}];
    {probmat,numiter}=EMCore[estart,{mat2sym,mat1,mat0sym},maxiter,showem];
 (*collapse into 2 x2  table based on number of final categoreis*)
    k=Length[probmat];
    {e00,e01,e10,e11}=SplitAfterBoth[probmat,k-numcatfin,k-numcatfin];
    p00=Apply[Plus,Flatten[e00]];
    p01=Apply[Plus,Flatten[e01]];
    p10=Apply[Plus,Flatten[e10]];
    p11=Apply[Plus,Flatten[e11]];
   res={p00,p01+p10,p11};
 Return[{res,numiter}]]


sym[mat_]:=mat/2 + Transpose[mat/2]//N;	

EMCore[evecstart_,{mat2_,mat1_,mat0_},maxiter_,showem_]:=
Module[{vec2,vec1,vec0,conv,enew,numiter,k,emat},
(*input are vectors*)
  vec2=Flatten[mat2];
  vec1=Flatten[mat1];
  vec0=Flatten[mat0];
   conv=.001;
 (*iterate*)
 {enew,numiter}=FixedPoint[                                             
        EMStep[#,{vec2,vec1,vec0},showem]&,
        {evecstart,0},
        maxiter,
        SameTest->((Max[Abs[#1[[1]]-#2[[1]]]] < conv)&)]; 
 (*create matrix*)       
  k=Sqrt[Length[enew]];
  emat=Partition[enew,k];
Return[{emat,numiter}]]


EMStart[{mat2_,mat1_,mat0_}]:=
Module[{k,e00,e01,e10,e11,estart0,estart,evec},
   k=Length[mat2];																			   
 (*incident-incident*)
        e11=SelectBoth[mat2, Range[k-1]];
 (*incident-censored last column*)
       e01=Drop[SelectColumns[mat1,{k-1}],-1];
        e10=Transpose[e01];
 (*censored censored-last row*)
   e00=SelectBoth[mat0,{k}];
 (*combine *)
   estart=BlockMatrix[{{e11,e01},{e10,e00}}];
   estart0=ReplaceZero[estart,.5];
    estart=estart0/Apply[Plus,Flatten[estart0]];
   evec=Flatten[estart];
Return[evec]]




EMStep[{evec_,iter_},{nvec2_,nvec1_,nvec0_},showem_]:=
Module[{k,a1,a2,c1,c0,e2mat,e1mat,e0mat,emat,fvec},
 (*E-STEP*)
    k=Sqrt@Length[nvec2];
    a1=core1[k];
    a2=core2[k];  (* censoring in interval j includes intervals j and larger*)
    c1=a1 ~Dir~ a2;
    c0=a2 ~Dir~ a2;
    e2mat=Partition[nvec2,k];
    (*SYMMETRY FOR IC GROUP*)
    e1mat=sym@Partition[nvec1 evec/ ReplaceZero[c1 .evec,.5], k];
    e0mat=Partition[nvec0 evec/ ReplaceZero[c0 .evec,.5], k];
 (*M-STEP*)
    emat=e2mat+e1mat+e0mat;
    fvec=Flatten[emat]/Total[Flatten[emat]];
    If[showem, Print["iteration ",iter,"   fvec ",fvec]];
 Return[{fvec,iter+1}]]
	

core1[n_]:=Id[n]
core2[n_]:=UpperDiagJ[n,n,1]+Id[n]


End[] 
EndPackage[]

