(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  

BeginPackage["twinfitdata`","matrixlx`"] 

GenDataB::usage="GenDataB[datatype]"
GenDataCM::usage="GenDataCM[datatype]"
GenDataCW::usage="GenDataCW[datatype]"
GenDataP::usage="GenDataP[datatype]"


Clear[GenDataB,GenDataCM,GenDataCW,GenDataP]

Begin["Private`"]





GenDataB[datatype_]:=
Module[{data,datax,datafilename,res,mii,mic,mcc,dii,dic,dcc},
If[datatype=="em",        datafilename="bem"];
If[datatype=="obs",         datafilename="bobs"];
        mii=
	{{0,0,0,0,0,0},
	{0,2,0,0,0,0},
	{1,7,4,0,0,0},
	{0,3,2,3,0,0},
	{0,0,3,6,6,0},
	{0,1,0,1,3,0}};
	mic=
	{{2,8,3,1,1,1},
	{0,22,27,18,20,9},
	{0,2,25,33,32,14},
	{1,1,5,31,56,40},
	{0,1,3,7,40,54},
	{0,0,0,0,13,38}};
	mcc=
	{{395,0,0,0,0,0},
	{28,1707,0,0,0,0},
	{12,29,1266,0,0,0},
	{12,25,94,1068,0,0},
	{16,25,76,273,1105,0},
	{4,14,46,155,545,993}};
	dii=
	{{1,0,0,0,0,0},
	{1,4,0,0,0,0},
	{1,1,4,0,0,0},
	{0,5,10,5,0,0},
	{0,1,5,4,3,0},
	{0,0,0,4,2,1}};
	dic=
	{{5,20,10,3,3,2},
	{2,37,45,40,27,11},
	{0,2,60,72,69,32},
	{0,2,12,78,108,66},
	{0,0,9,22,89,100},
	{0,1,3,9,18,66}};
	dcc=
	{{587,0,0,0,0,0},
	{55,2850,0,0,0,0},
	{29,66,2134,0,0,0},
	{20,58,175,2008,0,0},
	{34,45,197,508,2184,0},
{8,34,119,382,1044,1738}};
        data={mii,mic,mcc,dii,dic,dcc};
         datax=ModifyData[data,datatype];   
   res={datax, datatype, "breastca",datafilename}; 
Return[res]]



(*From Baker et al 2005*)
GenDataB2005[]:=
Module[{data,datatype,res,datax,datafilename},
    datatype="em";
    data={{{2, 0, 0, 0, 0}, {8, 4, 0, 0, 0}, {3, 2, 3, 0, 0}, {0, 3, 6, 6, 0}, {1, 0, 
      1, 3, 0}}, {{32, 30, 19, 21, 10}, {2, 25, 33, 32, 14}, {2, 5, 31, 56, 
      40}, {1, 3, 7, 40, 54}, {0, 0, 0, 13, 38}}, {{2130, 0, 0, 0, 0}, {41, 
      1266, 0, 0, 0}, {37, 94, 1068, 0, 0}, {41, 76, 273, 1105, 0}, {18, 46, 
      155, 545, 993}}, {{6, 0, 0, 0, 0}, {2, 4, 0, 0, 0}, {5, 10, 5, 0, 
      0}, {1, 5, 4, 3, 0}, {0, 0, 4, 2, 1}}, {{64, 55, 43, 30, 13}, {2, 60, 
      72, 69, 32}, {2, 12, 78, 108, 66}, {0, 9, 22, 89, 100}, {1, 3, 9, 18, 
      66}}, {{3492, 0, 0, 0, 0}, {95, 2134, 0, 0, 0}, {78, 175, 2008, 0, 
      0}, {79, 197, 508, 2184, 0}, {42, 119, 382, 1044, 1738}}};
        datax=ModifyData[data,datatype];   
         datafilename="b2005";
    res={datax, datatype, "breastca2005",datafilename};           
   Return[res]]
      
 


         

GenDataCM[datatype_]:=
Module[{data,datax,datafilename,res,mii,mic,mcc,dii,dic,dcc},
If[datatype=="em",        datafilename="cmem"];
If[datatype=="obs",     datafilename="cmobs"];
    mii= {{0,0,0,0,0,0},
{0,0,0,0,0,0},
{0,1,0,0,0,0},
{0,0,1,2,0,0},
{0,0,0,1,1,0},
{1,0,0,1,1,1}};

mic=
{{0,4,0,1,0,0},
{0,3,1,2,1,1},
{0,0,3,8,11,4},
{0,0,1,15,28,14},
{0,1,2,4,30,31},
{0,2,1,2,7,25}};

mcc=
{{325,0,0,0,0,0},
{63,1459,0,0,0,0},
{19,66,1148,0,0,0},
{9,61,159,993,0,0},
{10,26,134,399,860,0},
{5,5,34,168,484,591}};

dii={{0,0,0,0,0,0},
{1,0,0,0,0,0},
{0,0,1,0,0,0},
{1,0,0,1,0,0},
{0,1,0,5,1,0},
{0,1,0,1,4,0}};

dic={{0,2,2,0,0,1},
{0,4,5,4,6,0},
{3,2,15,19,12,7},
{2,3,7,38,44,33},
{2,2,10,20,57,44},
{0,1,1,7,10,30}};

dcc={{589,0,0,0,0,0},
{145,2841,0,0,0,0},
{58,125,2143,0,0,0},
{34,119,333,1924,0,0},
{25,76,324,793,1659,0},
{6,17,85,358,952,753}};

 data={mii,mic,mcc,dii,dic,dcc};
 datax=ModifyData[data,datatype];   
         datafilename="CM";
    res={datax, datatype, "CM",datafilename};           
     Return[res]]
       
       
       
   GenDataCW[datatype_]:=
Module[{data,datax,datafilename,res,mii,mic,mcc,dii,dic,dcc},
If[datatype=="em",        datafilename="cwem"];
If[datatype=="obs",         datafilename="cwobs"];
       mii={{0,0,0,0,0,0},
       {0,1,0,0,0,0},
       {0,0,0,0,0,0},
       {0,0,2,4,0,0},
       {0,1,2,2,1,0},
       {0,1,1,0,3,2}};
       
       mic={{0,1,0,0,0,0},
       {0,1,1,4,7,0},
       {0,0,1,11,14,5},
       {0,3,4,14,20,12},
       {1,0,0,7,30,42},
       {0,1,0,1,6,28}};
       
       mcc={{397,0,0,0,0,0},
       {28,1735,0,0,0,0},
       {12,34,1318,0,0,0},
       {13,24,102,1111,0,0},
       {16,30,84,292,1160,0},
       {4,13,52,164,569,1045}};
       
       dii={{0,0,0,0,0,0},
       {0,0,0,0,0,0},
       {0,0,1,0,0,0},
       {0,0,1,1,0,0},
       {0,0,1,1,4,0},
       {0,0,2,0,3,1}};
       
       
       dic={{0,2,0,2,0,0},
       {0,2,3,4,6,6},
       {2,0,11,27,24,10},
       {1,2,3,35,47,27},
       {2,1,5,18,60,66},
       {0,1,3,2,28,53}};
       
       dcc={{592,0,0,0,0,0},
       {62,2900,0,0,0,0},
       {31,77,2218,0,0,0},
       {19,59,195,2115,0,0},
       {31,54,226,553,2286,0},
      {9,33,129,412,1071,1811}};
     data={mii,mic,mcc,dii,dic,dcc};
 datax=ModifyData[data,datatype];   
         datafilename="CW";
    res={datax, datatype, "CW",datafilename};           
   Return[res]]   
       
       
       
       
      GenDataP[datatype_]:=
   Module[{data,datax,datafilename,res,mii,mic,mcc,dii,dic,dcc},
             If[datatype=="em",  datafilename="pem"];
            If[datatype=="obs",   datafilename="pobs"];
                  mii={{0,0,0,0,0,0},
                   		{0,0,0,0,0,0},
                   		{0,1,0,0,0,0},
                   		{0,0,3,7,0,0},
                   		{0,0,1,9,8,0},
                   		{0,0,1,0,9,1}};        
                   	mic=	{{0,0,0,0,0,0},
                   		{1,0,1,1,1,0},
                   		{0,0,1,8,1,0},
                   		{0,1,5,31,33,11},
                   		{2,1,6,18,70,48},
                   		{0,0,0,2,22,35}};      
                   	mcc={{325, 0,  0,0,0,0},
                   		{62,1466,0,0,0,0},
                   		{19,66,1150,0,0,0},
                   		{9,64,160,980,0,0},
                   		{9,27,133,372,830,0},
                   		{5, 7, 38,160,455,554}};
                   	dii=	{{0,0,0,0,0,0},
                   		{0,0,0,0,0,0},
                   		{0,0,1,0,0,0},
                   		{0,0,0,1,0,0},
                   		{0,0,1,6,2,0},
                   		{0,0,0,4,4,1}};
                   	dic=	{{0,0,0,0,0,0},
                   		{0,0,1,0,0,0},
                   		{0,0,4,15,11,5},
                   		{0,8,13,57,70,19},
                   		{2,2,11,41,110,109},
                   		{0,0,4,8,36,58}};
                   	dcc ={{589, 0,	0,	0,0,0},
                   		{146,2845,0,	0,0,0},
                   		{60,126,	2156,0,0,0},
                   		{36,119,336,	1918,0,0},
                   		{26,78,327,	768,1603,0},
                   		{7,20,78,	360,874,692}};
                    data={mii,mic,mcc,dii,dic,dcc};
      	  datax=ModifyData[data,datatype];   
      	          datafilename="P";
      	     res={datax, datatype, "P",datafilename};           
   Return[res]]   
       
       
 ModifyData[{mii_,mic_,mcc_,dii_,dic_,dcc_},datatype_]:=
Module[{res},
If[datatype=="em",  res={mii,mic,mcc,dii,dic,dcc}];
If[datatype=="obs" ,res=Apply[Plus,Flatten[#]]& /@ {mii,mic,mcc,dii,dic,dcc}];
dimvec=Dimensions[#]& /@ res;
Return[res]]      
       
End[] 
EndPackage[]

 
Print["breast cancer data"];
Print["  dataBem is survival data"];
Print["  dataBobs is sums of counts"];
dataBem=GenDataB["em"];
dataBobs=GenDataB["obs"];

Print["colorectal cancer data for men"];
Print["  dataCMem is survival data"];
Print["  dataCMobs is sums of counts"];
dataCMem=GenDataCM["em"];
dataCMobs=GenDataCM["obs"];

Print["colorectal cancer data for women"];
Print["  dataCWem is survival data"];
Print["  dataCWobs is sums of counts"];
dataCWem=GenDataCW["em"];
dataCWobs=GenDataCW["obs"];

Print["prostate cancer data"];
Print["  dataPem is survival data"];
Print["  dataPobs is sums of counts"];
dataPem=GenDataP["em"];
dataPobs=GenDataP["obs"];

(*datavec={dataBem,dataBobs,dataCMem,dataCMobs,dataCWem,dataCWobs,dataPem,dataPobs};*)


Print["Type TwinFit[dataname, parsym, options]"];
