(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Input
TwinFitProfile		twinfitprofile.m
GenProb		          twinfitprob.m
*)

BeginPackage["twinfitcore`","twinfitprob`","twinfitprofile`", "twinfitprofileplot`","twinfitsummary`",
                       "twinfitem`","twinfitfreq`","twinfitdata`","twinfitvar`","matrixlx`"]  

TwinFitCore::usage="TwinFitCore[dataset,model,parsym,maxboot,bounds,showprog]"
GenRandomData::usage="GenRandomData[data,datatype]"
TwinFitBoot::usage="TwinFitBoot"
TwinFitModel::usage="TwinFitModel"

Clear[TwinFitCore,GenRandomData,TwinFitBoot,TwinFitModel]


Begin["Private`"]

TwinFitCore[dataset_,parsym_,modelvec_,maxboot0_,showprog_,censoringstart0_,numcatfin0_,amin0_,newfitQ_,storedname_]:=
Module[{res,resx,amin,maxboot,censoringstart,numcatfin,resset,mat,mat0,labelvec,colname,mat0r,matr}, 
  If[newfitQ==True,
           res=TwinFitModelSet[dataset,parsym,modelvec,maxboot0,showprog,censoringstart0,numcatfin0,amin0];
           res0={maxboot0,amin0,censoringstart,numcatfin,res};
           amin=amin0;
           maxboot=maxboot0;
           censoringstart=censoringstart0;
           numcatfin=numcatfin0;
           Print["exporting stored ",storedname];
            Export[storedname,res0]];
     If[newfitQ==False,
           res=Quiet@Drop[ReadList[storedname],1][[1]];
           {maxboot,amin,censoringstart,numcatfin,res}=res;
           Print["importing stored ",storedname]];
      Return[res]]



            
TwinFitModelSet[dataset_,parsym_,modelvec_,maxboot_,showprog_,censoringstart_,numcatfin_,amin_]:=
Module[{resvec},
   resvec=TwinFitModel[dataset,parsym,#,maxboot,showprog,censoringstart,numcatfin,amin]& /@ modelvec;
Return[resvec]]


 
   
TwinFitModel[dataset_,parsym_,model_,maxboot_,showprog_, censoringstart_,numcatfin_,amin_]:=  
  Module[{mat0,matset,matall},
      Print["MODEL ",model];
      NotebookDelete[temp];
      temp = PrintTemporary["original data fit "]; 
     mat0=TwinFitEst[dataset,parsym,model,showprog,censoringstart,numcatfin,amin];
     If[maxboot==1,matset=0];          
     If[maxboot>1,
          SeedRandom[18];   
         matset=TwinFitBoot[dataset,parsym,model,maxboot,showprog,censoringstart,numcatfin,amin]];    
        matall={model,mat0,matset};
         Return[matall]]

 
 
 (*--------------------------- ORIGINAL FIT------------------------------------------------*)
 
 TwinFitEst[dataset_,parsym_,model_,showprog_,censoringstart_,numcatfin_,amin_]:=
   Module[{data,datatype,dataname,datafilename,mat,matr,rowname,colname,tab},
       {data,datatype,dataname,datafilename}=dataset;
       If[datatype=="obs", datacore = data];
       If[datatype=="em",    datacore =FitEM[data,censoringstart,numcatfin]]; 
       mat= TwinFitProfile[datacore,parsym,model,showprog,amin];
  Return[mat]]





(*-----------------BOOTSTRAP----------------------------------*)

 TwinFitBoot[dataset_,parsym_,model_,maxboot_,showprog_,censoringstart_,numcatfin_,amin_]:=
   Module[{matset},
      matset=Table[TwinFitBootCore[dataset,parsym,model,i,showprog,censoringstart,numcatfin,amin],  {i,1, maxboot}];
 Return[matset]]
  
  
  
TwinFitBootCore[{data_,datatype_,dataname_,datafilename_},
             parsym_,model_,i_,showprog_,censoringstart_,numcatfin_,amin_]:=
   Module[{dataR,datasetR,matR},
   dataR=GenRandomData[data,datatype];
   datasetR={dataR,datatype,dataname,datafilename};
   matR=TwinFitEst[datasetR,parsym,model,showprog,censoringstart,numcatfin,amin];
   (*note temp is a global variable*)
   NotebookDelete[temp];
   temp = PrintTemporary["bootstrap iteration ",i]; 
   Return[matR]]




GenRandomData[data_,datatype_]:=
Module[{dataM,dataD,nM,nD,pvecM,pvecD,dataR,dataMR,dataDR},
dataM=Flatten@Take[data,3];
      dataD=Flatten@Take[data,-3];
      nM=Round@Apply[Plus,dataM];
      nD=Round@Apply[Plus,dataD]; 
      pvecM=dataM/nM//N;
       pvecD=dataD/nD//N;
   dataMR=GenRandomData3[nM,pvecM,datatype];
   dataDR=GenRandomData3[nD,pvecD,datatype];
   dataR=Join[dataMR,dataDR];
  Return[dataR]]


 GenRandomData3[n_,pvec_,datatype_]:=
 Module[{datavec,len,lenx,datavec1,datavec2,datavec3,lenz,mat1,mat2,mat3,res},
  datavec=RandomVariate[MultinomialDistribution[n,pvec]];
  If[datatype=="obs", 
       res=datavec];
  If[datatype=="em",
     len=Length[pvec];
     lenx=len/3;
    datavec1=Take[datavec,lenx];
    datavec2=Drop[Take[datavec,2 lenx], lenx];
    datavec3=Take[datavec,-lenx];
    lenz=Sqrt[lenx];
     mat1=Partition[datavec1,lenz];
     mat2=Partition[datavec2,lenz];
     mat3=Partition[datavec3,lenz];
     res={mat1,mat2,mat3}];
 Return[res]]
   








     

End[] 
EndPackage[]



