(*:Mathematica:: Version 8 *)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Input
FitEM			twinfitem.m
TwinFitProfile 	  	 twinfitprofile.m
TwinFitPlotCore	  	 twinfitprofileplot.m
TwinFitEst			twinfitcore.m
TwinFitBoot		twinfitcore.m

GenProb		          twinfitprob.m
*)

BeginPackage["twinfitcheck`","twinfitprob`", "twinfitprofile`","twinfitcore`","twinfitprofileplot`",
"twinfitsummary`",  "twinfitem`","twinfitfreq`","twinfitdata`","twinfitvar`","matrixlx`"]  



TwinFitCheck::usage="TwinFitCheck[dataset,parsym.model]"
TwinFitCheckSIM::usage="TwinFitCheckSIM[dataset,parsym.model]"

Clear[TwinFitCheckBoot, TwinFitCheckDataSIM]


Begin["Private`"]


TwinFitCheck[dataset_,parsym_,maxboot_:0]:= 
Module[{},
   Print["number of bootstraps ",maxboot];   
   TwinFitCheckBootX[dataset,parsym,"AR",maxboot];
  TwinFitCheckBootX[dataset,parsym,"AD",maxboot];
 TwinFitCheckBootX[dataset,parsym,"Add",maxboot];
Return[Null]]



 TwinFitCheckBootX[dataset_,parsym_,model_,maxboot_]:=
  Module[{res,showprog0,censoringstart0,numcatfin0,amin0,estvec,nM,nD,dev0,v0,a0,b0,c0,s0,prev0,frac0,
               parsym0,estvec0,datacore0,data,datatype,dataname,datafilename,datafilename0,dataset0},
      showprog0=False;
      censoringstart0="during";
      numcatfin0=1;
      amin0=0;
  (*INITIAL FIT*)
  Print["Model ", model];
     {estvec0,nM,nD}=TwinFitCheckEst[dataset,parsym,model,showprog0,censoringstart0,numcatfin0,amin0];
     {dev0,rr0,a0,b0,c0,s0,prev0,frac0}=estvec0;   
     Print["starting values ", estvec0];
     datacore0=GenDataCoreX[model,{a0,b0,c0,s0},{nM,nD}]; 
     {data,datatype,dataname,datafilename}=dataset;
      datafilename0=StringJoin[datafilename,"PERFECT"];
      dataset0={datacore0,"obs",dataname,datafilename0};     
      SeedRandom[18];   
      matset=TwinFitBoot[dataset0,parsym,model,maxboot,showprog0,censoringstart0,numcatfin0,amin0];   
     Print@Dimensions[matset];
     SummaryBoot[model,estvec0,matset,maxboot];
     
      Return[Null]]
 
 
 
  TwinFitCheckEst[dataset_,parsym_,model_,showprog_,censoringstart0_,numcatfin0_,amin0_]:=
  Module[{data,dataype,dataname, datacore,nM,nD,estvec, survaug,mats},
      {data,datatype,dataname,datafilename}=dataset;
      survaug=False;
      If[datatype=="obs", datacore = data];
      If[datatype=="em",    datacore =FitEM[data,censoringstart0,numcatfin0]];
       mat=TwinFitProfile[datacore,parsym,model,showprog,amin0];
      mats=Sort[mat];
      estvec=mats[[1]];
     nM=Apply[Plus,Take[datacore,3]];
      nD=Apply[Plus,Take[datacore,-3]];
      res={estvec,nM,nD};
    Return[res]]
    
    
    TwinFitCheckSIM[parsym_]:=
    Module[{model,parsym0},
    model="AR";
    parsym0={.99,.05,.07,.01};
    Print[model];
    Print[parsym0];
    TwinFitCheckSIMX[model,parsym0,parsym];
    Return[Null]]
    
    
     TwinFitCheckSIMX[model_,parsym0_,parsym_]:=
     Module[{},
       TwinFitPlotSIM[model,parsym0,parsym];
       TwinFitCheckParameters[model,parsym0,parsym];
Return[Null]]   
  




    
    TwinFitCheckParameters[input_,parsym_]:=
    Module[{model,a0,b0,c0,d0,showconv},
    {model,{a0,b0,c0,s0}}=input;
    showconv=True;
     Print[model, "    a = ",a0,"     s = ",s0];
     {estvec0,estvec}=TwinFitCheckParametersCore[{a0,b0,c0,s0},{1000,1000},model,parsym,False,showconv];
    Return[{estvec0,estvec}]]

     
     TwinFitCheckParametersCore[parsym0_,{nM_,nD_},model_,parsym_,showprog_,showconv_:True]:=
     Module[{a0,b0,c0,s0,dev0,estvec0,datacore0, amin,mat, mats, estvec,colname,rwoname,matb, matr,tab},
           {a0,b0,c0,s0}=parsym0;
           dev0=0;
           estvec0=ComputeFinalParameters[model,{dev0,a0,b0,c0,s0}];
          datacore0=GenDataCoreX[model,parsym0,{nM,nD}];   
           amin0=0;
           mat=TwinFitProfile[datacore0,parsym,model,showprog,amin0];
           mats=Sort[mat];
	   estvec=mats[[1]];
	   colname={"true","sim"};
          rowname={"dev",   "RR", "a",   "b",   "c",   "s",    "prev","HF"};
            matb=Transpose[{estvec0,estvec}];
           matr=Round[matb 1000]/1000//N;
           tab=TableForm[matr,TableHeadings->{rowname,colname},TableSpacings->{1,1}];
           Print[tab];
      Return[{estvec0,estvec}]]

 










 
GenDataCoreX[model_,{a0_,b0_,c0_,s0_},{nM_,nD_}]:=
Module[{par0,datacore,fMii, fMic, fMcc, fDii, fDic, fDcc,xMvec,xDvec},
       par0={a0,b0,c0,s0};
       res0=GenProb[par0,model];
        {fMii, fMic, fMcc, fDii, fDic, fDcc}=  GenProb[par0,model];
       xMvec={fMii, fMic, fMcc} nM;
       xDvec={fDii, fDic, fDcc}  nD;
       datacore=Join[xMvec,xDvec];
 Return[datacore]]    





SummaryBoot[model_,estvec0_,mat_,maxboot_]:=
 Module[{estmat,meanvec,sevec,lowvec,uppvec,alpha},
           estmat=FindBestZ[#]& /@ mat;
           alpha=.05;
          Print[model];
         BootTableZ[estvec0,estmat,maxboot,alpha];
     Return[Null]]





BootTableZ[estvec0_,estmat_,maxboot_,alpha_]:=
Module[{meanvec,sevec,lowvec,uppvec,
  dev0,logdev0,rr0,logrr0,a0,b0,c0,s0,prev0,frac0,estvecNEW,sevecNEW,
  dev0se,logdev0se,rr0se,logrr0se,a0se,b0se,c0se,s0se,prev0se,frac0se,
  devs0seADj,rr0seADJ,sevec0,mat,labelvec,colname,matr},
    {meanvec,sevec,lowvec,uppvec1,uppvec2,uppvec3, uppvec4}=BootAnalysisCore[estmat,maxboot,alpha];

   mat=Transpose[{meanvec,lowvec,uppvec1,uppvec2,uppvec3,uppvec4}];
   mat1=Drop[mat,{2,4}];
    matr=Round[mat1 1000]/1000//N;
        labelvec= {"dev","RR","a","b","c","s","prev","frac"};

    colname={"mean","2.5%","98%","99%","99.5%","max%"};
   Print@TableForm[matr,TableHeadings->{labelvec,colname}];    

Return[Null]]


 BootAnalysisCore[mat_,maxboot_,alpha_:.025]:=
 Module[{matx,meanvec,sevec,lowvec,uppvec,res,low,upp,bounds},
     matx=Transpose[mat];
      meanvec=Mean[#]&  /@ matx;
      sevec=Sqrt[Variance[#]]& /@ matx;
      low=Max[1,Floor[maxboot alpha]];
      upp1=Min[maxboot,Ceiling[maxboot .98]];
      upp2=Min[maxboot,Ceiling[maxboot .99]];
      upp3=Min[maxboot,Ceiling[maxboot .995]];
      upp4=maxboot;       

      lowvec=LowerCI[low,#]& /@ matx;
      uppvec1=UpperCI[upp1,#]& /@ matx;
      uppvec2=UpperCI[upp2,#]& /@ matx;
      uppvec3=UpperCI[upp3,#]& /@ matx;
      uppvec4=UpperCI[upp4,#]& /@ matx;
      res= {meanvec,sevec,lowvec,uppvec1,uppvec2,uppvec3,uppvec4};
Return[res]]
 
 
  LowerCI[lowCI_,y_]:=(Sort[y])[[lowCI]]
  UpperCI[uppCI_,y_]:=(Sort[y])[[uppCI]]

 
 
 FindBestZ[mat_]:=
 Module[{mats,estvec,res},
        mats=Sort[mat];
          estvec=mats[[1]];
      Return[estvec]]



End[] 
EndPackage[]


