(*:Mathematica:: Version 10*)
(*:Context:: "twinfit`" *)
(*Twin Version:: 1 *)
(*:Title:: twin genetics *)  
(*Date 2015*)

(*Input
TwinFitCore			  twinfitcore.m
TwinFitProfilePlot		  twinfitprofileplot.m
TwinFitSummarySet		  twinfitsummary.n
TwinFitVarComp		  twinfitvar.m*)

(*
FITTING
twinfit.m		         fit all models
twinfitcore 	        core computations
twinfitprofille		 profile given s
twinfitprofileplot		 option with showplot
twinfitem		         fits survival data with em algorithm
twinfitprob	                 probablity of latent class and outcome given latent class
twinfitfreq		         probablity of genotypes
twinfitvar		         variance components formulation (for comparison)
twinfitsummary		 summary report with bootstap
twinfitdata			data set
matrixlx		         matrix functions for twinfitem
DIAGNOSTICS AND CHECKS
twinfitcheck               TwinFitCheck[dataset,parysm] checks convergence 
twinfitsim			TwinFitSim[parsym] compare estimates under different amin
twinfitheritability		TwiinFitPlotH[] plost heritability versus heritability fraction
*)

(*TwinFit[dataset,parsym,options] 
dataset ={{m2,m1,m0,d2,d1,d0},datatype, dataname, datafilename} where datatype is em or obs*)




BeginPackage["twinfit`","twinfitprob`","twinfitcore`","twinfitprofileplot`", "twinfitcheck`","twinfitprofile`","twinfitsummary`",
"twinfitem`","twinfitfreq`","twinfitdata`","twinfitvar`","matrixlx`","twinfitsim`","twinfitheritability`"]  


TwinFit::usage="TwinFit[dataset,options]"

Clear[TwinFit]

Options[TwinFit]=
 {ModelList->"All",
  CensoringStart->"during",
  NumCatFinal->1,
  ShowProgress->False,
  ShowPlot->False,
   AMin->.70,
   MaxBoot->0,
   NewFitQ->True}

CensoringStart::usage="during or after--- applies to interval of missing"
NumCatFinal::usage="number of final categories in survival model matrix used for split to create genetic model"
ShowProgress::usage="True or False for showing progress"
ShowPlot::usage="True or Flase for show profile plot sensivity analysis"
MaxBoot::usage="maximum number of bootstrap iterations; 0 means none, otherwise at least 2"
ModelList::usage="All or create list of subset of AR, AD, ARN, ADN, Add"
NewFitQ::usage="True or False indicator if new fit"
AMin::usage="minimum penetrance in highest group"

Begin["Private`"]



TwinFit[dataset_,parsym_,options___Rule]:=
Module[{data,datatype,dataname,datecore,maxboots,adds,modelvec,modelvec0,numcatfin,censoringstart,
          showprog,showplot,maxboot,storedname,storedletter,hvec,resvec},
   (*options input*)
        {modelvec0,censoringstart,numcatfin,showplot,showprog,maxboot,newfitQ,amin}=
        {ModelList,CensoringStart,NumCatFinal,ShowPlot,ShowProgress,MaxBoot,NewFitQ,AMin}/.
         {options}/.Options[TwinFit];              
  (*data input*)
        {data,datatype,dataname,datafilename}=dataset;
  (*model vector*)
     If[modelvec0==="All", modelvec={"AR","AD","Add"}, modelvec=modelvec0];
  (*listing*)
        Print["DATA SET: ",dataname, ": ",datatype, " data analysis"];
        If[datatype=="em",
        If[censoringstart=="during", Print["   censoring at beginning of interval"]];
        If[censoringstart=="after",   Print["   censoring at end of interval"]];
        Print["   number of final categories = ",numcatfin]];
        Print["MODEL LIST ",modelvec];
        Print["NUMBER OF BOOTSTRAP REPLICATIONS ",maxboot];
        Print["AMIN ",amin];
  (*name*)
      storedname=GenStoredName[dataset,maxboot];
  (*check*)
        check=CheckInput[{data,datatype,dataname,datafilename},
           {censoringstart,showplot,showprog,maxboot,newfitQ,amin},storedname,parsym];
  If[check==False, Print["invalid inputs"]];
  If[check==True,
        ReportDataCoreX[dataset,censoringstart,numcatfin]
        Print["VARIANCE COMPONENT ANALYSIS"];
        hvec=TwinFitVarComp[dataset,censoringstart,numcatfin];
        Print["LATENT CLASS ANALYSIS with lower bound on parameter a of ",amin];
        resvec=TwinFitCore[dataset,parsym,modelvec,maxboot,showprog,censoringstart,numcatfin,amin,newfitQ,storedname];
       TwinFitSummarySet[resvec,maxboot,modelvec];
       If[showplot,
          Print["Sensitivity analysis"];
          TwinFitProfilePlot[dataset,parsym,modelvec,showprog,censoringstart,numcatfin]]];
 Return[Null]]
 


(*--------------------------------------------------------------*)

GenStoredName[dataset_,maxboot_]:=
Module[{data,datatype,dataname,datafilename,maxboots,adds,storedname},
     {data,datatype,dataname,datafilename}=dataset;
     maxboots=ToString[maxboot];
        namecore="twincorex";
       storedname=StringJoin["twincomp",namecore,maxboots,datafilename,".m"];
      Print["storedname ",storedname];
Return[storedname]]


CheckInput[{data_,datatype_,dataname_,datafilename_},
    {censoringstart_,showplot_,showprog_,maxboot_,newfitQ_,amin_},storedname_,parsym_]:=
Module[{checknewfit,checkfile, checkiter,checkdatatype,check,check0,checkamin,checkcens},
  If[MemberQ[{False,True}, newfitQ]==True, check0=True, check0=False; Print["incorrect newfitQ"]];  
                      checkfile =FileExistsQ[storedname];
  If[(newfitQ==False) &&  (checkfile == True), checknewfit=True];
  If[(newfitQ==False) &&  (checkfile==False), Print["no stored file"]; checknewfit=False];
  If[newfitQ==True, checknewfit=True];
  If[IntegerQ[maxboot] && (maxboot==0 || maxboot>=2),    checkiter=True,   Print["invalid maxboot"]; checkiter=False];
  If[maxboot==1, Print["a single bootstrap iteration is not valid"]];
  If[MemberQ[{"em","obs"}, datatype]==True,  checkdatatype=True,Print["invalid data type"];  checkdatatype=False];
  
   If[showplot==True || showplot==False,  check1=True,  Print["invalid showplot"];  check1=False];
   If[showprog==True || showprog==False,  check2=True,Print["invalid showprog"];  check2=False];
   
  If[amin>=0 && amin <1, checkamin=True, Print["invalid amin"];  checkamin=False];    
  If[MemberQ[{"during","after"}, censoringstart]==True,checkcens=True, Print["invalid cens start"]; checkcens=False]; 
  If[Length[parsym]==4, checkparsym=True, checkparsym=False; Print["invalid parsym"]];
  check=checknewfit && checkiter&& checkdatatype && check0 && checkamin && checkcens && checkparsym && check1 && check2;
Return[check]]
  


ReportDataCoreX[dataset_,censoringstart_,numcatfin_]:=
Module[{data,datatype,dataname,datafilename,datacore, mat,matr,rowname,colname,tab},
      {data,datatype,dataname,datafilename}=dataset;
      If[datatype=="obs", datacore = data];
       If[datatype=="em",    datacore =FitEM[data,censoringstart,numcatfin]]; 
       Print["ESTIMATED COUNTS FROM SURVIVAL MODEL "];
           mat=Partition[Flatten[datacore],3];
           matr=Round[mat];
           rowname={"MZ", "DZ"};
           colname={"2", "1", "0"};
           tab=TableForm[matr,TableHeadings->{rowname,colname}];
           Print["  ",tab];
Return[Null]]
 


End[] 
EndPackage[]



     parsym={a,b,c,s}; 