(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"        *)
(*:Title::  TrialFit *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*input *)
  
 
BeginPackage["survfitsplit`"]  


GenDataSplit::usage="GenDataSplit[dataset,split]"

Clear[GenDataSplit]

Begin["Private`"]	  


 
     GenDataSplit[dataset_,split_,seed_:19]:=
       Module[{x0,x1,y0,y1,xname, datainfo,
                  nvar,datasetname,difboot,
                nALL0,nALL1, nTRAIN0,nTRAIN1,nTEST0,nTEST1,
                rangeALL0,rangeALL1,
                xTRAIN0,xTRAIN1,yTRAIN0,yTRAIN1,dataTRAIN,
                  indexTRAIN0,indexTRAIN1,indexTEST0,indexTEST1,
                 xTEST0,xTEST1,yTEST0,yTEST1,dataTEST,res},
              {x0,x1,{y0,s0,c0},{y1,s1,c1},xname,datasetname}=dataset;
          (*split*)
              nALL0=Length[y0];
              nALL1=Length[y1];
              nTRAIN0=Round[nALL0 (1-split)];
              nTRAIN1=Round[nALL1 (1- split)];
              nTEST0=nALL0-nTRAIN0;
              nTEST1=nALL1-nTRAIN1;
              nALL=nALL0+nALL1;
              SeedRandom[18];
              rangeALL0=RandomSample@Range[nALL0];
              SeedRandom[seed];
              rangeALL1=RandomSample@Range[nALL1];
              indexTRAIN0=Take[rangeALL0,nTRAIN0];
              indexTRAIN1=Take[rangeALL1,nTRAIN1];
              indexTEST0=Drop[rangeALL0,nTRAIN0];
              indexTEST1=Drop[rangeALL1,nTRAIN1]; 
      (*training sample*)         
              xTRAIN0=SelectColumns[x0,indexTRAIN0];
              xTRAIN1=SelectColumns[x1,indexTRAIN1];
              yTRAIN0=y0[[indexTRAIN0]];
              yTRAIN1=y1[[indexTRAIN1]]; 
              
           (*SURVIVAL ADJUSTED ESTIMATE*)   
               yTRAIN0=s0[[indexTRAIN0]];
              yTRAIN1=s1[[indexTRAIN1]]; 
              
              
              dataTRAIN={xTRAIN0,xTRAIN1,yTRAIN0,yTRAIN1};
          (*test sample*)    
               xTEST0= SelectColumns[x0,indexTEST0];
               xTEST1=SelectColumns[x1,indexTEST1];
               yTEST0=y0[[indexTEST0]];
               yTEST1=y1[[indexTEST1]]; 
               
               
               yTEST0=y0[[indexTEST0]];
               yTEST1=y1[[indexTEST1]]; 
               cTEST0=c0[[indexTEST0]];
               cTEST1=c1[[indexTEST1]]; 
               
               
               dataTEST={xTEST0,xTEST1,yTEST0,yTEST1,cTEST0,cTEST1};
               nvar=Length[x0];
         (*REPORT*)    
          datainfo={datasetname,nvar,nALL0,nALL1,split};
           res={dataTRAIN,dataTEST,nTEST0,nTEST1};
           Return[{res,datainfo}]]
     
     
         

End[] 
EndPackage[]

