(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"        *)
(*:Title::  simulation  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)

BeginPackage["survfitsim`"]  

GenDataSim::usage="GenDataSim"
CensX::usage="CensX"

Clear[GenDataSim,CensX]

Begin["Private`"]	  



GenDataSim[n_,g_,name_,show_:False]:=GenDataSimCore[n,g,name,{2,3},{1,2},show]


GenDataSimCore[n_,g_,name_,coef0_,coef1_,show_:False]:=
Module[{m,sigma,
   a0, avec0,a1,h0,h1,avec1,len,
   x0,x1,pvec0,pvec1,y0,y1,p0,p1,
   var,se,dif,low,upp,
      range,xname,datasetname,res},
(*variance for normal distribution of all markers*)
  sigma=20;
 SeedRandom[100];    
(*report*)   
          x0=RandomVariate[NormalDistribution[0,sigma], {g,n}];
            x1=RandomVariate[NormalDistribution[0,sigma], {g,n}];     
      (*probabilities of outcome*)
             h0=.3;
             a0=Round[Log[h0/(1-h0)] 100]/100//N;
             h1=.2;
             a1=Round[Log[h1/(1-h1)] 100]/100//N;
            len0=Length[coef0];
	    len1=Length[coef1];
	    
            {pvec0,pvec1}=GenProb[{g,x0,x1,a0,coef0,a1,coef1,"first","last"},showplot];
          (*outcome data*)
        
          tvec0=-Log[pvec0];
          tvec1=-Log[pvec1];
           u0= Flatten[RandomVariate[ExponentialDistribution[#]]& /@ tvec0];
	 u1= Flatten[RandomVariate[ExponentialDistribution[#]]& /@ tvec1];
	 (*censoring is c=1*)
          c0= Flatten@RandomVariate[BernoulliDistribution[.2],n];
	  c1= Flatten@RandomVariate[BernoulliDistribution[.2],n];
          t0=CensX[#]& /@ Transpose[{u0,c0}];
          t1=CensX[#]& /@ Transpose[{u1,c1}];
        (*combine*)
           len=Length[x0];
           xname=ToString[#]& /@ Range[len];
           datasetname=name;
 If[show,
	Print["SIMULATED DATA"];
	Print[" number of genes = ",g];
	Print[" normal with mean 0 and sigma = ",sigma];
	Print[" sample size per arm= ",n];
        Print["PARAMETERS IN RISK PREDICTION MODEL WITH STARTING BINARY ENDPOINT"]
         Print[" parameters group 0 ",Flatten[{a0,coef0}]];
         Print[" variable names in group 0 ", Range[len0]];
         Print[" parameters group 1 ",Flatten[{a1,coef1}]];
        Print[" variable names in group 1 ", Take[Range[g],-len1]]];

         res=  {x0,x1,{t0,c0}, {t1,c1}, xname,datasetname};
      Return[res]]
  

CensX[{u_,c_}]:=
Module[{t},
If[c==0, t=u];
If[c==1, t=u .8];
Return[t]]


GenProb[{g_,x0_,x1_,a0_,avec0_,a1_,avec1_,genepos0_,genepos1_},showplot_]:=
 Module[{mrange0,mrange1, m, x0m,x1m, avec02,avec12, w0,p0,w1,p1,p0z,p1z,
     output,res},
     (*position of genes*)
      m=Length[avec0];
   {mrange0,mrange1}=GenePos[g,m,genepos0,genepos1];
        (*pararamters for both*)
         avec02=avec0 ~Join~ avec0;
         avec12=avec1 ~Join~ avec1;      
       (*probabilities in control arm*) 
            x0m=x0[[mrange0]];
            If[genepos0=="both", w0= a0 + avec02 .x0m]; 
             If[genepos0=="first", w0= a0 + avec0 .x0m]; 
             If[genepos0=="last", w0= a0 + avec0 .x0m]; 
             If[genepos0=="next", w0= a0 + avec0 .x0m]; 
            p0= Expit[w0];  
      (*probabilities in experimental arm*)
             x1m=x1[[mrange1]];
             If[genepos1=="both", w1= a1 + avec12 .x1m]; 
            If[genepos1=="first", w1= a1 + avec1 .x1m]; 
            If[genepos1=="last", w1= a1 + avec1 .x1m];  
             If[genepos1=="next", w1= a1 + avec1 .x1m];  
             p1=Expit[w1];
          q0=BinAdjust[#]& /@ p0;
          q1=BinAdjust[#]& /@ p1;
    
          res={q0,q1};    
          
        Return[res]]      


BinAdjust[p_]:=
Module[{q},
If[p<=.01, q=.01];
If[p>=.99, q=.99];
If[p >.01 && p < .99, q=p];
Return[q]]


Expit[x_]:=Exp[x]/(1+Exp[x])

PositiveSign[x_]:=Sign[Sign[x]-1]+1
NegativeSign[x_]:=1-Sign[Sign[x]+1]
NonNegativeSign[x_]:=Sign[Sign[x]+1]
NonPositiveSign[x_]:=Abs @ Sign[Sign[x]-1]  
ReplaceUpperBound[x_,ub_,new_]:=
   x NegativeSign[x-ub] + NonNegativeSign[x-ub] new
ReplaceLowerBound[x_,ub_,new_]:=
   x PositiveSign[x-ub] + NonPositiveSign[x-ub] new   

GenePos[g_,m_,genepos0_,genepos1_]:=
Module[{mrange0,mrange1},
 (*choice of genes arm 0*)
        If[genepos0=="first",  mrange0=Range[m]];
        If[genepos0=="next",  mrange0=m+Range[m]];
        If[genepos0=="last",  mrange0=g-m + Range[m]];
        If[genepos0=="both",  mrange0=Range[m] ~ Join~ (g-m + Range[m])];   
   (*choices of genes arm 1*)  
      If[genepos1=="first",  mrange1=Range[m]];
        If[genepos1=="next",  mrange1=m+Range[m]];
        If[genepos1=="last",  mrange1=g-m + Range[m]];
       If[genepos1=="both",  mrange1=Range[m] ~ Join~ (g-m + Range[m])];   
Return[{mrange0,mrange1}]]

 
End[] 
EndPackage[]

Print["generate datasim"];
datasim=GenDataSim[2000,100,"sim", False];
