(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"                   *)
(*:Title::  core algorithms  *)
(*:Summary::                         *)
(*:References::                       *)
(*Date   2014 Stuart G.Baker *)
(*Input
EstimatedBenefitCore			survfitbasic.m
GenCutpointsCore				survfitbasic.m
 ComputeSortedBenefitScore  		survfitbasic.m
 *)

BeginPackage["survfitRDtest`","survfitbasictest`"]  
 
 EvaluateTestSampleRD::usage="EvaluateTestSampleRD[dataTEST,parvec,numcut,quantL,quantU,quantUsize,showcut]"

Clear[EvaluateTestSampleRD]

Begin["Private`"]	  

 EvaluateTestSampleRD[dataTEST_,parvec_,numcut_,fracmax_,quantL_,quantU_,quantUsize_,
          showcut_,plottype_,time_,show_:False]:=
  Module[{dcutvec,res,xvec},
          {dcutvec,xvec}=GenCutpointsRD[dataTEST,parvec,numcut,fracmax, 
           quantL,quantU, quantUsize,showcut,plottype];
           res=EstimatedBenefitCutpoint[dataTEST,parvec,dcutvec,time,show];
        Return[{res,xvec}]]

GenCutpointsRD[dataTEST_,parvec_,numcut_,fracmax_,quantL_,quantU_,quantUsize_,showcut_,plottype_]:=
              Module[{pair0,pair1,range},
             {pair0,pair1}=ComputeSortedBenefitScore[dataTEST,parvec];      
            range=GenCutpointsCore[{pair0,pair1},parvec,numcut,fracmax,
                          quantL,quantU,quantUsize,showcut,plottype];
         Return[range]]   

		     
   EstimatedBenefitCutpoint[dataTEST_,parvec_,dcutvec_,time_,show_:False]:=
              Module[{pair0,pair1,res,resx},
                   {pair0,pair1}=ComputeSortedBenefitScore[dataTEST,parvec];                        
                  res=EstimatedBenefitCore[pair0,pair1,#,time,show]& /@ dcutvec;
                  {d,dif,se,m0,m1,n0,n1,plot}=Transpose[res];
                  resx={d,dif,se,m0,m1,n0,n1};
             Return[resx]]
         
 
   

    
End[] 
EndPackage[]

