(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"        *)
(*:Title::  TrialFit*)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*input 
   ReportTestSample			  trialfitbasic.m
   ReportParameterAUC			  trialfitbasic.m
   FitRiskModelPair	        		  trialfitRDtrain.m
   EvaluateTestSample		   	  trialfitRDtest.m *)
  
 
BeginPackage["survfitRD`", "survfitRDtrain`", "survfitRDtest`","survfitlogit`","survfitbasic`"]  


TrialFitRiskDifference::usage="TrialFitRiskDifference[datacore,input]"


Clear[TrialFitRiskDifference]

Begin["Private`"]	  

     
     TrialFitRiskDifference[datacore_,{dataset_,maxboot_,showcut_,showfit_,showprog_,showtab_,
        threshold_,numcut_,fracmax_,
               newfitQ_,newbootQ_,split_,numfilter_,maxsteps0_,
          showplot_,quantL_,quantU_,quantUsize_,format_},aucdif_,level_,time_]:=
             Module[{x0,x1,y0,y1,xname, datasetname,
	                 dataTRAIN,dataTEST,nTEST0,nTEST1,parmat0,parmat1,parmat,
	                 aucdifs,storedname,plotname,auclist0,auclist1,
	                 parvec0,parvec,parameters0,pos0,parameters1,pos1,spec,testresult,stepp},
	         PrintMod["RD",level,showprog,showtab];
	            If[level=="F",maxsteps=1];
		    If[level=="M",maxsteps=2];
		    If[level=="X",maxsteps=5];
              {x0,x1,y0,y1,xname,datasetname}=dataset;  
               {dataTRAIN,dataTEST,nTEST0,nTEST1}=datacore;
            (*TRAINING SAMPLE*)
                     parvec0=FitRiskModelPair[dataTRAIN,xname,numfilter,maxsteps,
                                    showfit,showprog,showtab,aucdif];   
            {parameters0,pos0,auclist0,parameters1,pos1,auclist1} = parvec0;
                 parmat0=ReportParametersAUC[parameters0,pos0,auclist0,xname,"group 0",showfit];
                 parmat1=ReportParametersAUC[parameters1,pos1,auclist1,xname,"group 1",showfit];
                parmat={parmat0,parmat1};
          If[showprog,      
           Print[parmat0];
           Print[parmat1]];
           (*TEST SAMPLE*)
               parvec= {parameters0,pos0,parameters1,pos1};
               {res,xvec}=EvaluateTestSampleRD[dataTEST,parvec,numcut,fracmax,
                            quantL,quantU,quantUsize,showcut,"score",time,showcut];  
          Return[{res,xvec,parmat}]]
          
          
           
          
        
    


 

End[] 
EndPackage[]

