(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"        *)
(*:Title::        TrialFit *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*Input*)

BeginPackage["survfitmodel`",
"survfitRD`", "survfitRDtrain`","survfitRDtest`",
"survfitbasic`","survfitsplit`",
"survfitlogit`", "survfitplot`","survfitboot`", "survfitbootci`"]


TrialFitModel::usage="TrialFit[data,options]"


Clear[TrialFitModel]

Begin["Private`"]	  


 TrialFitModel[datacore_,{name_,level_},parameterset_]:=
    Module[{input,method,tuningparameters,check,numcvsplits,plotformat,
             aucdif1,aucdif2,numchoose1,numchoose2, time,
             plotinfo,res},
    (*parameters*)
    {input,method,tuningparameters,check,numcvsplits,plotformat,time}=parameterset;
   {aucdif1,aucdif2,numchoose1,numchoose2}= tuningparameters;
   If[name=="RD"  && level=="F",     plotinfo= TrialFitRiskDifference[datacore,input,aucdif1,"F",time]];
   If[name=="RD"  && level=="M",     plotinfo= TrialFitRiskDifference[datacore,input,aucdif2,"M",time]];
   If[name=="RD"  && level=="X",     plotinfo= TrialFitRiskDifference[datacore,input,aucdif2,"X",time]];
   res=Join[{{name,level}},plotinfo];
   Return[res]]


End[] 
EndPackage[]

