(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"        *)
(*:Title::  simulation  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2015 Stuart G. Baker *)
(*Input  trialfitstepp.txt *)

BeginPackage["survfitdata`"]  

GenDataBC::usage="GenDataBC"

Clear[GenDataBC]

Begin["Private`"]	  



GenDataBC[type_,show_:False]:=
Module[{mat,dvec,pair,pair1,matx,index,matz,mat0,mat1,x0,y0,x1,y1,t0,t1,s0,s1,dataname,xname,maxtx0,
             id,er,pgr, ki67, tumorsize,  numposnodes,age,bmi, treatment, oscens,dfscens, dfsyrs,rc,rccens, osyrs},

  mat=ReadList["trialfitstepp.txt", Number, RecordLists -> True];
  (*id,er,pgr, ki67, tumorsize,  numposnodes,age,bmi, treatment, oscens,dfscens, dfsyrs,rc,rccens, osyrs*)

 (*remove missing  covariate data*)	
  matx0=Select[mat,(#[[8]]>0 && #[[1]]>0 && #[[2]]>0 && #[[3]] >0)&];


If[type=="bin",
     (*select persons who were not censored or who survived past time 3*)
     matx=Select[matx0,(#[[11]]==1 || #[[12]]>3)&];
     dataname="databin"];
  
   
If[type=="surv",
   dataname="datasurv"; 
    matx=matx0];

Print["dataname ",dataname];
Print["number of observations ",Length[matx]];

 
If[show,
 Print["  initial number  n = ",Length[mat]];
 Print["  remove missing covariate  n = ",Length[matx0]]];



 (*split by treatment*)
 (*DIFFERENCE:    GROUP 1 MINUS GROUP 0  - IDEAL LARGER EFFECT IN GROUP 1*)
   mat0=Select[matx,(#[[9]]==2)&];   (*tamixofen =  control smaller survival so group 0*)
   mat1=Select[matx,(#[[9]]==1)&];  (*letrizole =   experimental larger survival so group 1*)

(*covariates*)
    index={2,3,4,5,6,7,8};
    (*id,er,pgr, ki67, tumorsize,  numposnodes,age,bmi, treatment, oscens,dfscens, dfsyrs,rc,rccens, osyrs*)
    (*er, pgr, ki67, tumorsize,numposnodes, age,bmi*) 
    
   (*transpose because rows are predictors*)
   x0=Transpose@SelectColumns[mat0,index];
   x1=Transpose@SelectColumns[mat1,index];
   If[show,Print["  dimensions x0 ",Dimensions[x0]]];
   If[show,Print["  dimensions x1 ",Dimensions[x1]]];

(*outcome DFS is column 12*)
   t0=Flatten@SelectColumns[mat0,{12}];
   t1=Flatten@SelectColumns[mat1,{12}];

(*censoring*)
(*censoring changed from 0 to 1*)
   c0=1-Flatten@SelectColumns[mat0,{11}];
   c1=1-Flatten@SelectColumns[mat1,{11}];

   
 (*names*)

  xname={"er","pgr","ki67","tumorsize","numposnodes","age","bmi"};
 
 (*data*)
 data=  {x0,x1,{t0,c0}, {t1,c1}, xname,dataname};
  
 Return[data]]









SelectRows[matrix_List?MatrixQ,indices_List?VectorQ] :=
   matrix[[#]]& /@ indices 
 
SelectColumns[matrix_List?MatrixQ, indices_List?VectorQ] :=           
   Transpose @ SelectRows[Transpose[matrix],indices]

                  
RemoveRows[matrix_List?MatrixQ,indices_List?VectorQ] :=
   Delete[matrix,List /@ indices]
                  
                   
RemoveColumns[matrix_List?MatrixQ, indices_List?VectorQ] :=           
   Transpose[RemoveRows[Transpose[matrix],indices]]



 

                      
 
End[] 
EndPackage[]

databin=GenDataBC["bin"];
datasurv=GenDataBC["surv"];
