(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"        *)
(*:Title::  TrialFit *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*input 
   ComputeBootSet				  trialfitboot.m
   PlotExport					   trialfitplot.m
   PlotBenefitScoresRD			   trialfitRD.m
   PlotCut				 		   trialfitplot.m*)
  
 
BeginPackage["survfitbasictest`"]  

ComputeSortedBenefitScore::usage="ComputeSortedBenefitScore[data,parvec]"
GenCutpointsCore::usage="GenCutpointsCore"
EstimatedBenefitCore::usage=" EstimatedBenefitCore[pair0,pair1,d]"


Clear[ComputeSortedBenefitScore,GenCutpointsCore,EstimatedBenefitCore]

Begin["Private`"]	  

  
  ComputeSortedBenefitScore[{x0_,x1_,y0_,y1_,c0_,c1_},parvec_]:=
             Module[{parameters0,posvec0,n0,parameters1,posvec1,n1,
             parcons0,parcons1,par0,par1,
                      xvec00,xvec01, s00,s01,r00,r01,d0,
                      xvec10,xvec11, s10,s11,r10,r11,d1,         
                     pair0,pair1,len2, 
                     partop0,pairtop1,
                     rtop0,rtop1,
                     ytop0,ytop1,ym0,ym1,dif,var0,var1,var},
            (*parameters*) 
                 {parameters0,posvec0,parameters1,posvec1}=parvec;      
                 parcons0=parameters0[[1]];
                 parcons1=parameters1[[1]];       
                 par0=Drop[parameters0,1];
                 par1=Drop[parameters1,1];  
           (*difference in risk in control group*)  
                 xvec00=x0[[posvec0]];
                 xvec01=x0[[posvec1]];
                 s00= parcons0 + par0 .xvec00;
                 s01= parcons1 + par1 .xvec01;
                 r00=Exp[s00]/(1+Exp[s00]);
                 r01=Exp[s01]/(1+Exp[s01]);
                 d0=r01-r00;
            (*difference in risk in experimental group*)  
                  xvec10=x1[[posvec0]];
                  xvec11=x1[[posvec1]];
                  s10= parcons0 + par0 .xvec10;
                  s11= parcons1 + par1 .xvec11;
                  r10=Exp[s10]/(1+Exp[s10]);
                  r11=Exp[s11]/(1+Exp[s11]);
                  d1=r11-r10;
               (*pairs*)
                  pair0=Sort@Transpose[{d0,y0,c0}];
                   pair1=Sort@Transpose[{d1,y1,c1}];
               Return[{pair0,pair1}]]
              
  
         EstimatedBenefitCore[pair0_,pair1_,d_,time_,show_:False]:=
                           Module[{m0,n0,p0,var0,m1,n1,p1,var1,dif,var,se,res,plot0,plot1,plot,z,low,upp},
                           plotname=StringJoin["cutpoint = ",ToString[d]];
                                {m0,n0,p0,var0,plot0,tab0,q0}=ComputeForGroup[pair0,d,time,Green,plotname];
                                {m1,n1,p1,var1,plot1,tab1,q1}=ComputeForGroup[pair1,d,time,Red,plotname];
                                 plot=Show[plot0,plot1];                              
                                dif=(p1-p0);
                                var=var0+var1;
                                se=Sqrt[var];
                                z=1.96;
                                low=dif-z se;
			        upp=dif+z se;
			        If[show,  Print["SURV  cutpoint ",d,"      dif low upp ",{dif,low,upp}]];
                               res={d,dif,se,m0,m1,n0,n1,plot};
                          Return[res]]
        
        
        
        ComputeForGroup[pair_,d_,time_,color_,groupname_]:=
        Module[{pairtop,dtop,ttop,m,p,n,var,data,S,maxtime,plot,plotx,q},
                     (*select greater than or equal to cutpoint*)
                     pairtop=Select[pair,(#[[1]] >= d)&];
        	          {dtop,ttop,ctop}=Transpose@pairtop;
        	          S = SurvivalModelFit[EventData[ttop, ctop]];
                          p=S[time];
                         vec=S[#]& /@ ttop;
                          m=Round@Apply[Plus,vec];
                         n=Length[ttop];
                          var=p (1-p)/n;
                          maxtime=Max[ttop];
                            plot=Plot[{S[t], S["PointwiseBands"][t]}, {t, 0, maxtime}, PlotPoints -> 500, 
			          Exclusions -> None, PlotStyle -> {color, Dotted, Automatic}, 
			         PlotRange -> {0, 1}];
                          plotx=Show[plot,Frame->True,FrameLabel->{"time","survival",groupname,None}];
                   {tab,q}=ReportSurvX[ttop,ctop,time];
                   Return[{m,n,p,var,plotx,tab,q}]]
   
   
   
   ReportSurvX[tvec_,cvec_,time_]:=
   Module[{pair,a,b,c,d,mat,rowname,colname,tab,r0,r1},
     pair=Transpose[{tvec,cvec}];
     a=Length@Select[pair,(#[[1]]<=time && #[[2]]==0)&];
     b=Length@Select[pair,(#[[1]]<=time && #[[2]]==1)&];
     c=Length@Select[pair,(#[[1]]>time && #[[2]]==0)&];
     d=Length@Select[pair,(#[[1]]>time && #[[2]]==1)&];
     mat={{a,b},{c,d}};
     times=ToString[time];
     r0=StringJoin["<=", times];
     r1=StringJoin[">", times];
     rowname={r0,r1};
     colname={"fail","cens"};
    q=(c+d)/(a+b+c+d);
   tab=TableForm[mat,TableHeadings->{rowname,colname}];
Return[{tab,q}]]
   
 
 
 

  GenCutpointsCore[{pair0_,pair1_},parvec_,numcut_,fracmax_,quantL_,quantU_,quantUsize_,
      showcut_,plottype_:"score"]:=
              Module[{dvec0,yvec0,dvec1,yvec1,cvec0,cvec1,
                       dvecUnion0,dvecUnion1,dvecUnion,
                        len,index, num,inc,i,lentot,range,matr,tab,mat,ranger,dcutvecr,
                        set,setcut,dcutvec},
                        {dvec0,yvec0,cvec0} =Transpose[pair0];
                        {dvec1,yvec1,cvec1} =Transpose[pair1];
                        dvecUnion0=Union[dvec0];
		        dvecUnion1=Union[dvec1];
		        dvecUnion=Sort@Union[Join[dvec0,dvec1]];
		  (*MAXIMUM CUTPOINT*)      
		      If[quantU==Automatic,
		             dsort0=Sort[dvec0];
		             dsort1=Sort[dvec1];
		             dmax0=dsort0[[-quantUsize]];
		             dmax1=dsort1[[-quantUsize]];
		             dmax=Min[dmax0,dmax1]];
		     If[quantU=!=Automatic,
		          dmax=Quantile[dvecUnion,quantU]];
		   (*MINUMUM CUTPOInT*)
		            dmin=Quantile[dvecUnion,quantL];
		   (*CUTPOINT VECTOR =range*)
		        dvecQ=Sort@Select[dvecUnion, (#<=dmax)&];
		         len=Length[dvecQ];
		         quant= Round[ 100 len/Length[dvecUnion]]//N;
                          index=Range@len;
		          rangefrac={0} ~Join~ (Range[numcut])/numcut;		      
	         If[plottype=="score",
	               (*equally spaced cutpoints up to dmax*)
        	        dcutvec= dmin+ (dmax-dmin) rangefrac;
		        xvec=dcutvec];
        	 If[plottype=="quant",
        	       (*equally spaced quantiles up to fracmax*)
        	        dvec=Join[dvec0,dvec1];
        	         xvec=Round[rangefrac fracmax 100]/100//N;
        	        dcutvec=Quantile[dvec,#]& /@ xvec];
        	  (*report table*)	
        	  If[showcut,	
        		rowname={"cutpoints", "x-axis"};
        		cmat={dcutvec,xvec};
        		cmatr=Round[cmat 1000]/1000//N;
        		Print["    cutpoints"];
        		Print["  ",TableForm[cmatr,TableHeadings->{rowname,Automatic}]]];
           	 If[showcut,
	                  lentot=Length@Join[dvec0,dvec1];
	                  Print["Test sample:   total number of benefit scores ",lentot, " number unique= ",len]];
	     Return[{dcutvec,xvec}]]
	     
		 
		  
  

End[] 
EndPackage[]

