
(*Mathematica:: Version 8.0      *)
(*:Context:: "survfit`"        *)
(*:Title::        TrialFitSurv *)
(*:References::                  *)
(*Date   2015 Stuart G. Baker *)



BeginPackage["survfitsurv`"]

GenDatasetSurv::usage="GenDatasetSurv[dataset,time]"


Clear[GenDataSurv]

Begin["Private`"]	  

   GenDatasetSurv[dataset0_,time_,show_:False]:=
   Module[{x0,x1,t0,c0,t1,c1,xname,dataname,s0,s1,dataset,plot0,plot1,plot,plotx},
          {x0,x1,{t0,c0}, {t1,c1}, xname,dataname}=dataset0;
            {s0,plot0,p0}=GenSurv[t0,c0,time,"group 0",Green];
          {s1,plot1,p1}=GenSurv[t1,c1,time,"group 1",Red];
          dataset={x0,x1,{t0,s0,c0},{t1,s1,c1},xname,dataname};
       If[show,
         Print["Overall Analysis"]; 
           EvaluateSurvKM[t0,c0,t1,c1,time];
           plot=Show[plot0,plot1];
          plotx=Show[plot,ImageSize->Small];
            Print["    Group 0 data"];
           tab0=ReportSurv[t0,c0,time];
           Print["   Group1 data"];
           tab1=ReportSurv[t1,c1,time];            
          Print["   Survival curves"];
          Print["    ",plotx]];
      
 
 Return[dataset]]

GenSurv[tvec_,cvec_,time_,groupname_,color_]:=
Module[{data,S,mint,maxt,medt,plot,plotx,svec,survec,p,maxtime},
(*KM fit*)
    S=SurvivalModelFit[EventData[tvec, cvec]];
(*plot*)
maxtime=Max[tvec];
   plot=Plot[{S[t], S["PointwiseBands"][t]}, {t, 0, maxtime}, PlotPoints -> 500, 
        Exclusions -> None, PlotStyle -> {color, Dotted, Automatic}, 
       PlotRange -> {0, 1}];
       plotx=Show[plot,Frame->True,FrameLabel->{"time","survival",groupname,None}];
(*outcome*)
    stime=S[time];
    survec=S[#]& /@ tvec;
   tri=Transpose[{tvec,cvec,survec}];
    svec=GenOutcome[#,time,S]& /@ tri;   
    p=S[time];
Return[{svec,plotx,p}]]

GenOutcome[{t_,c_,s_}, time_,S_]:=
Module[{y},
(*censoring is 1*)
If[ t > time, y=1];   (*surv*)
If[ t <=time && c==0, y=0];  (*death*)
If[t < time  && c==1, y=S[time]/s];  
Return[y]]


ReportSurv[tvec_,cvec_,time_]:=
Module[{pair,a,b,c,d,mat,rowname,colname,tab,r0,r1},
pair=Transpose[{tvec,cvec}];
a=Length@Select[pair,(#[[1]]<=time && #[[2]]==0)&];
b=Length@Select[pair,(#[[1]]<=time && #[[2]]==1)&];
c=Length@Select[pair,(#[[1]]>time && #[[2]]==0)&];
d=Length@Select[pair,(#[[1]]>time && #[[2]]==1)&];
mat={{a,b},{c,d}};
times=ToString[time];
r0=StringJoin["<=", times];
r1=StringJoin[">", times];
rowname={r0,r1};
colname={"fail","cens"};
tab=TableForm[mat,TableHeadings->{rowname,colname}];
Print["   ",tab];
Return[Null]]



  EvaluateSurvKM[tvec0_,cvec0_,tvec1_,cvec1_,time_]:=
 Module[{y0,y1,z,p0,p1,m0,m1,n0,n1,dif,var,se,low,upp,S0,S1},
       S0=SurvivalModelFit[EventData[tvec0, cvec0]];
       S1=SurvivalModelFit[EventData[tvec1, cvec1]];
        p0=S0[time]//N;
        p1=S1[time]//N;
          dif=p1-p0;
         n0=Length[tvec0];
          n1=Length[tvec1];
          var=p1 (1-p1)/n1 + p0 (1-p0)/n0;
          se=Sqrt[var];
          low=dif-1.96 se;
          upp=dif+1.96 se;
          Print["overall probabilities p0  p1    ",   {p0,p1}];
          Print["dif low upp   ",{dif,low,upp}];
Return[Null]]



End[] 
EndPackage[]

