(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"                   *)
(*:Title::  logistic fitting algoritms  *)
(*:Summary::                         *)
(*:References::                       *)
(*Date   2014 Stuart G. Baker *)
(*Input 
UnivariateFilter		trialfitbasic.m
FitLogitNested			trialfitlogit.m*)

BeginPackage["survfitRDtrain`","survfitlogit`","survfitbasic`"]  


FitRiskModelPair::usage="FitRiskModelPair[{x0,x1,y0,y1},xname,numfilter,maxsteps,showprog,aucdif]"
FitRiskModel::usage="FitRiskModelCadit[{x0,x1,y0,y1},xname,numfilter,maxsteps,showprog,aucdif]"
  
 
Clear[FitRiskModelPair, FitRiskModel]
         
Begin["Private`"]	  

      
  FitRiskModelPair[{x0_,x1_,y0_,y1_},xname_,numfilter_,maxsteps_,
  showfit_,showprog_,showtab_,aucdif_]:=
    Module[{parameters0,pos0,n0,parameters1,pos1,n1,res},
       {parameters0,pos0,auclist0}=
          FitRiskModel[{x0,y0},"Group 0",xname,numfilter,maxsteps,showfit,showprog,showtab,aucdif];
        {parameters1,pos1,auclist1}=
            FitRiskModel[{x1,y1},"Group 1",xname,numfilter,maxsteps,showfit,showprog,showtab,aucdif];
       res={parameters0,pos0,auclist0,parameters1,pos1,auclist1};        
       If[showprog,
       Print["  Group 0:  AUC list  last excluded: ",auclist0];
       Print["  Group 1:  AUC list  last excluded: ",auclist1]];
 Return[res]];
   
  
  FitRiskModel[{xdata_,ydata_},groupname_,xname_,numfilter_,maxsteps_,
       showfit_,showprog_,showtab_,aucdif_]:=
      Module[{t,set,tlist,posall,g,posallx,n,
                  auc,parameters,posin,res,posbest,xtop},
       (*find positions of best variables*)
       {tlist,posall,xtop}=UnivariateFilter[xdata,ydata,xname,numfilter,showprog];   
      (*stepwise*)
            {auclist,parameters,posin}=FitLogitNested[xdata,ydata,posall,showprog,aucdif,maxsteps];
         (*output*)     
         parametersr=Round[parameters 1000]/1000//N;
          res={parametersr,posin,auclist}; 
     Return[res]];
    
     
     
     
End[] 
EndPackage[]

