(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"        *)
(*:Title::  plot  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
 
BeginPackage["survfitplot`"]  

PlotCut::usage="PlotCut[inputvec,vec,threshold,format]"
PlotExport::usage="PlotExport[figname,plot]"
GenTicksForQuant::usage="Gen"

Clear[PlotCut,PlotExport,GenTicksForQuant]

Begin["Private`"]	  

PlotCut[{inputvec_,dif0_,low0_,upp0_,threshold_,zboot_,plotname_,qvec_,color0_},{ymin_,ymax_},
plotformat_,format_,ncol_]:=
Module[{difvec,fracvec,sevec,m0,m1,n0,n1,e,dmin,dmax,
            lineplot,lowvec,uppvec,lowvec0,uppvec0,xticks,rangex,
            pointTEST,lineTEST,pointTESTlow,pointTESTupp,
            plotcore,plot},
 (*BASIC  QUANTITITES*)           
 color=Black;
 
 th=.01;
 size=Medium;
 
 {xvec0,fracvec,difvec,sevec,m0,m1,n0,n1}=inputvec;
      If[plotformat=="quantiles",xvec=qvec];
      If[plotformat=="score", xvec=xvec0];
        (*TEST SAMPLE POINTS *)
          lowvec0=difvec-zboot sevec;
          uppvec0=difvec+zboot sevec;
       (*adjust for boundary values*)
            lowvec=LowVec[lowvec0];
           uppvec=UppVec[uppvec0];
      (*connecting lines*)
         lineplot=LineSet[xvec,difvec,"est",color,th];
         lineplotlow=LineSet[xvec,lowvec,"ci",color,th];
         lineplotupp=LineSet[xvec,uppvec,"ci",color,th];
      (*points*)    
         psize=Medium;
         pointTEST=Graphics[{color,PointSize[psize],Point[#]}]& /@ Transpose[{xvec,difvec}];
         pointTESTlow=Graphics[{color,PointSize[psize],Point[#]}]& /@ Transpose[{xvec,lowvec}];
         pointTESTupp=Graphics[{color,PointSize[psize],Point[#]}]& /@ Transpose[{xvec,uppvec}];
      (*line for overall treatment effect*)    
       dmin=Min[xvec];
       dmax=Max[xvec];
       (*overall effect*)
        hline=Graphics[{Dashing[{.01,.01}],Line[{{dmin,dif0},{dmax,dif0}}]}];
        zeroline=Graphics@Line[{{dmin,0},{dmax,0}}];
     (*PLOT*)    
        (*if sample size label is desired on plot--not used*)
          e=Max[sevec/5];
          textset=TextSize[#,e]& /@ Transpose[{xvec,difvec,m0,m1,n0,n1}];
       (*plot*)
         maxqvec=Max[qvec];
         maxqvec0=maxqvec 1.01;
          maxxvec=Max[xvec];
          minxvec=Min[xvec];
         maxxvec0=maxxvec+ .01 (maxxvec-minxvec);
         minxvec0=minxvec- .01 (maxxvec-minxvec);
          If[plotformat=="quantiles",
            xlabel="Quantile (benefit score)";   
           rangex={0,maxqvec0}; 
            xticks=GenTicksForQuant[xvec0,qvec,ncol]];
            
          
            
         If[plotformat=="score",   
                  xlabel="benefit score";
                    rangex={minxvec0,maxxvec0};
                    If[ncol<=3,  xticks0={dmin,(dmin+dmax)/2,dmax}];
                    If[ncol>3,  xticks0={dmin,dmax}];
                    xticks1=Round[xticks0 100]/100//N;
                    xticks=Transpose[{xticks0,xticks1}]];
            
           plotcore={pointTEST, pointTESTlow,pointTESTupp,lineplot,lineplotlow,lineplotupp,zeroline};
              plotcore={lineplot,lineplotlow,lineplotupp,zeroline};
           plotnamex=Style[plotname,color];
             
             
              xlabelx=Style[xlabel,Black,size];
             ylabelx=Style["Treatment effect",Black,size];
             topnamex=Style[plotname,Black,size];           
          plot=Show[plotcore,
               Frame->True,
               FrameTicks->{xticks,Automatic,None,None},
               PlotRange->{rangex,{ymin,ymax}},
               LabelStyle->size,	
               FrameLabel->{xlabelx,ylabelx,topnamex,None},AspectRatio->1];
   Return[plot]]      
  

  GenTicksForQuant[xvec_,qvec_,ncol_]:=
  Module[{maxxvec,minvec,xmax,xmin,xmid,xmaxr,xminr,xmidr,xmaxs,xmids,xmins,
      qmax,qmin,qmid, qmaxr,qmidr,qminr,qmaxs,qmids,qmins,qticks,zticks,xticks},
            xmax=Max[xvec];
            xmin=Min[xvec];
            xmid=(xmax+xmin)/2;
            
            xmaxr=Round[xmax 100]/100//N;
            xminr=Round[xmin 100]/100//N;
            xmidr=Round[xmid 100]/100//N;
            xmaxs=ToString[xmaxr];
            xmids=ToString[xmidr];
            xmins=ToString[xminr];
           qmax=Max[qvec];
           qmid= qmax/2;
            qmin=0;
            qticks={qmin,qmid,qmax};
                 qmaxr=Round[qmax 100]/100//N;
	                qminr=Round[qmin 100]/100//N;
	                qmidr=Round[qmid 100]/100//N;
	                qmaxs=ToString[qmaxr];
	                qmids=ToString[qmidr];
	                qmins=ToString[qminr];
      If[ncol<=3,	                
       qticks={qminr,qmidr,qmaxr};
       zticks={StringJoin[qmins,"\n(",xmins,")"],StringJoin[qmids,"\n(",xmids,")"],
                        StringJoin[qmaxs,"\n(",xmaxs,")"]}];
      If[ncol>3,	                
       qticks={qminr,qmaxr};
       zticks={StringJoin[qmins,"\n(",xmins,")"], StringJoin[qmaxs,"\n(",xmaxs,")"]}];
                        
                xticks=Transpose[{qticks,zticks}];
  Return[xticks]]
  
  
   GenTicksForQuantOnly[qvec_,ncol_]:=
    Module[{maxxvec,minvec,xmax,xmin,xmid,xmaxr,xminr,xmidr,xmaxs,xmids,xmins,
        qmax,qmin,qmid, qmaxr,qmidr,qminr,qmaxs,qmids,qmins,qticks,zticks,xticks},
             qmax=Max[qvec];
             qmid= qmax/2;
              qmin=0;
              qticks={qmin,qmid,qmax};
                   qmaxr=Round[qmax 100]/100//N;
  	                qminr=Round[qmin 100]/100//N;
  	                qmidr=Round[qmid 100]/100//N;
  	                qmaxs=ToString[qmaxr];
  	                qmids=ToString[qmidr];
  	                qmins=ToString[qminr];
        If[ncol<=3,	                
         qticks={qminr,qmidr,qmaxr}];
          If[ncol>3,	                
         qticks={qminr,qmaxr}];
    Return[qticks]]
  
  
     TextSize[{d_,dif_,m0_,m1_,n0_,n1_},e_]:=
     Module[{m0s,m1s,name,res},
         m0s=ToString[m0];
         m1s=ToString[m1];
        name=StringJoin["(",m0s,",",m1s,")"];
        ns=ToString@Min[n0,n1];
        name=StringJoin["(",ns,")"];
        res=Graphics@Text[Style[name,FontSize->12],{d-e,dif+e},{0,-1}];
     Return[res]]
  
     UppVec[vec_]:= Min[1,#]&  /@ vec
     LowVec[vec_]:= Max[-1,#]&  /@ vec

(*create line sements*)

LineSet[xvec_,yvec_,type_,color_,th_]:=
Module[{pairvec,pairvec1,lineset},
   pairvec=Transpose[{xvec,yvec}];
   pairvec1=Partition[pairvec,2,1];
   If[type=="est",  lineset=LinePairEst[#,color,th]& /@ pairvec1];
   If[type=="ci",  lineset=LinePairCI[#,color,th]& /@ pairvec1];
 Return[lineset]]

LinePairEst[{{a_,b_},{c_,d_}},color_,th_]:= Graphics@{color,Thickness[th],Line[{{a,b},{c,d}}]}
LinePairCI[{{a_,b_},{c_,d_}},color_,th_]:= Graphics@{Darker[Red],Thickness[th],Dashing[{.02,.02}],Line[{{a,b},{c,d}}]}


  

  
  
 PlotExport[figname_,plot_,showprog_]:=
 Module[{namez},
   	 If[showprog, Print[plot]];
	   namez=StringJoin["trialfit",figname,".eps"];
	   Print["     export ", namez];
	   Export[namez,plot];     
 Return[Null]]
  
   
End[] 
EndPackage[]
