(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"        *)
(*:Title::        TrialFit *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*Input
GenStoredName		trialfitbasic.m*)


BeginPackage["survfitinputcheck`","survfitbasic`"]  


TrialFitParameters::usage="TrialFitParameters[]"

Clear[TrialFitParameters]

Begin["Private`"]	  

TrialFitParameters[dataset_,optionvec_]:=
Module[{split,numcvsplits,numcut,aucdif,newfitQ,showfitQ,maxboot,quantL,quantU,format,time,
             modellist,threshold,numfilter0,showxut,showscores,maxsteps,checkall,res,checkplotformat,
             check,fracmax1,
             checkmodelvec,checkmodel,checkmodel0,checkmodel1,
             x0,x1,y0,y1,xname,datasetname,nvar,numfilter,input,plotformat,plotspec},
    (*options*)  
        {split,time,numcut,numfilter0,newfitQ,
         showprogQ,showtabQ,maxboot,quantUsize,plotformat,modellist}= optionvec;
         showplotQ=False;
         showfitQ=False;
         
    (*default values*)
    method=1;     (*nout used*)
    mca=False;
    numiter=0;
         newbootQ=False;       (*not used*)
     	   numcvsplits=5;          (*number of cv splits;other option is 3*)
          quantL=0;		   (*lower bound of quantiles assumed later calculation*)
          quantU=Automatic;  (*compute upper bound based on size in quantUsize*)
          threshold=0 ;            (*benefit threshold*)
          maxsteps=10;          (*maximum number of stepwise iterations*)
   (*Tuning paramters*)
          aucdif=0; (*hold*)
      aucdif1=.05;
                 aucdif2=.01;
                 numchoose1=1;
                 numchoose2=5;
                 trainlevel=.95;
        tuningparameters= {aucdif1,aucdif2,numchoose1,numchoose2};
     
     
       modelset={{"RD","F"},{"RD","M"}, {"RD","X"}};
       checkmodelvec=MemberQ[modelset,#]& /@ modellist;
       checkmodel0=Apply[And, checkmodelvec];
         If[modellist=="Basic", checkmodel1=True, checkmodel1=False];
      checkmodel=checkmodel0 || checkmodel1;
    If[checkmodel==False, Print["bad model"]];
    (*CHECK INPUTS*)
    	checkall=CheckInput[dataset,{split,time,numcut,numfilter0,newfitQ,newbootQ,showfitQ,
                          maxboot,quantL,quantU,quantUsize,showplotQ},method,numcvsplits,method,plotformat];
    	 checkx==False;
     If[checkall,
           (*NUMBER OF VARIABLES FOR FILTER*)
           {x0,x1,{y0,s0,c0},{y1,s1,c1},xname,datasetname}=dataset;
           nvar=Length[x0];
           numfilter=Min[numfilter0,nvar];     
            n0=Length[y0];
            n1=Length[y1];
            n=Min[n0,n1];
            nTRAIN=n(1-split);
      (*SAMPLE SIZE FOR MAXIMUM*)      
         If[method==1, fracmax0=1- quantUsize/nTRAIN];
          If[method==2, fracmax0=1- quantUsize/nTRAIN];
         fracmax1=Max[fracmax0,.2];
         fracmax=Round[fracmax1 100]/100//N;
          check=checkall && checkmodel];
     If[check,
         input={dataset,maxboot,numiter,showfitQ,showprogQ,showtabQ,threshold,numcut,fracmax,
                   newfitQ,newbootQ,split,numfilter,maxsteps,showplotQ,quantL,quantU,quantUsize,"large"};
         plotspec={numcut,numiter,showfitQ,showprogQ,showtabQ,datasetname,aucdif,maxboot,y0,y1};
          parameterset={input,method,tuningparameters,True,numcvsplits,plotformat,time},      
       (*else*)
        plotspec=0;
        parameterset=0;      
        Print["invalid input"]];    
    Return[{check,parameterset,plotspec}]]
   

CheckInput[dataset_,{split_,time_,numcut_,numfilter_,newfitQ_,newbootQ_,showfitQ_,maxboot_,
   quantL_,quantU_,quantUsize_,showplotQ_},method_,numcvsplits_,method_,plotformat_]:=
Module[{check0,modelgood,memvec,numsplit,
check1,check2,check3,check4,check5,check6,check7,check8,check9,check10,check11,
     check12, check13,check14,checkall, len,x0,x1,y0,y1,xname,datasetname, len0,len1},
    (*check DATA*)
     len=Length[dataset];
    (*check length*)
      If[len==6, 
         check1=True, 
          check1==False; Print["invalid dataset specification"]];
    (*check matrices*)
       If[check1==True,
         {x0,x1,{y0,s0,c0},{y1,s1,c1},xname,datasetname}=dataset;
         len0=Length@Dimensions[x0];
         len1=Length@Dimensions[x1];
         If[len0==2 && len1==2, 
            check2 =True,
            check2=False; check3=False; Print["invalid input x not matrices"]]];
     (*check dimensions match*)
        If[check1==True && check2==True,
          (*rows are genes and columns are persons*)
          {nr0,nc0}=Dimensions[x0];
          {nr1,nc1}=Dimensions[x1];
          ny0=Length[y0];
         ny1=Length[y1];
         If[nr0==nr1 && nc0==ny0 && nc1==ny1, 
           check3=True, 
           check3=False; 
           Print[" number of rows of x0 and x1 should be equal ",{nr0, nr1}];
           Print["group 0: number of columns of x and length of y need to be equal ",{nc0, ny0}];
           Print["group 1: number of columns of x and length of y need to be equal ",{nc1, ny1}];
            Print["invalid input of baseline variable data"]]];
        (*check SPLIT*)
           If[split <.2 || split>.8, Print["split not in between .2, and .8"]; 
           check5=False, 
           check5=True];        
       (*check QUANTILE LOWER*)
           If[quantL>=0 && quantL <.5, check6=True,
           Print["quantL not in 0 and .5"];
           check6=False]; 
        (*check QUANTILE UPPER*)
         If[(quantU>.5 && quantU <=.8) || quantU===Automatic, check7=True,
          Print["quantU not in .5 and .8 and not Automatic"]; 
           check7=False];        
       (*check Showplot *)
	     If[showplotQ==False || showplotQ==True,
	      check8=True, 
             check8=False; Print["invalid showplotQ"]];        
          (*check NUMCAT*)
          If[IntegerQ[numcut] && (numcut > 0) && (numcut <11), 
             check9=True,
             check9=False; Print["numcat needs to be integer between 1 and 11"]];
          (*check MAXBOOT*)
	            If[IntegerQ[maxboot] && (maxboot > 0), 
	               check10=True,
	               check10=False; Print["maxboot needs to be integer >0 "]];
          (*check QUANTILEUPPER SAMPLE SIZE*)
      	            If[IntegerQ[quantUsize] && (quantUsize > 0), 
      	               check11=True,
      	               check11=False; Print["quantUsize needs to be integer >0 "]];
       (*check plotformat*) 
             
              If[plotformat=="quantiles" || plotformat=="score", check12=True, check12=False; Print["invalid plot format"]];
           (*check STORED Boot NAME*) 
	              check13=True;
	   (*check number fitler*)
           If[IntegerQ[numfilter] && (numfilter > 2), 
             check4=True,
             check4=False; Print["numfilter needs to be integer between 2 and number of variables"]]; 
           (*check method*)
           If[method==1 || method==2, check14=True, check14=False; Print["invalid method"]];
          
          If[time>0, check15=True, check15=False; Print["non-positive time"]];
          
         (*COMBINE CHECKS*)
           If[check1 && check2 && check3 && check4 && check5 && check6 && check7 &&
            check8 && check9 && check10 && check11 && check12 && check13 && check14 && check15,
            checkall=True,
           checkall=False];
         (*  Print["checkvec ",{check1,check2,check3,check4,check5,check6,check7,check8,check9,
         check10,check11,check12,check13,check14}]; 
         Print["checkall ",checkall];    *)
  Return[checkall]]



End[] 
EndPackage[]

