(*Mathematica:: Version 8.0      *)
(*:Context:: "trialfit`"        *)
(*:Title::  simulation  *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*input 
 FindCIM         trialfitbootci.m*)
 
BeginPackage["survfitboot`","survfitbootci`"]  



ComputeBootSet::usage="ComputeBootSet[{dvec,fracvec,difvec,sevec,m0,m1,n0,n1},
            {maxboot,numci,showtab,scenario}]"

Clear[ComputeBootSet]

Begin["Private`"]	  


 ComputeBootSet[{dvec_,fracvec_,difvec_,sevec_,m0_,m1_,n0_,n1_},
                       maxboot_,numci_,showtab_,scenario_]:=
  Module[{r0,r1,mx0,mx1,rx0,rx1,datavec0,datavec1,showbinsearch,
                 difboot, alphaS,zboot,coverage,i},
                 
              (*scenario is fixed for original; random for bootstrap*)   
             (*cumulative remainder*)
                 r0=n0-m0;
	       r1=n1-m1;
	     (*compute difference and reverse order so tail on left *)
	        mx0=Reverse[m0-Append[Drop[m0,1],0]];
	        mx1=Reverse[m1-Append[Drop[m1,1],0]];
	        rx0=Reverse[r0-Append[Drop[r0,1],0]];
	          rx1=Reverse[r1-Append[Drop[r1,1],0]];
	    (*combine*) 	    
    	     datavec0=Join[mx0,rx0];
	      datavec1=Join[mx1,rx1];

	  (*check*)
	   {mch0,rch0}=Cumulate[datavec0];
           {mch1,rch1}=Cumulate[datavec1];
	   If[showtab,   
	      bootmat={mx0,rx0,mx1,rx1};
	      rowname={"arm 0 events","arm 0 non-events","arm 1 events", "arm 1 non-events"};
	      Print["  test sample counts:  number between cutpoints -- for multinomial bootstrap"];
	      tab=TableForm[bootmat,TableHeadings->{rowname,Automatic}];
	      Print["   ",tab]];

         (*bootstrap*)
           SeedRandom[18];
           difboot= Table[ BootMulti[datavec0,datavec1,scenario],{i,1, maxboot}];
    Return[difboot]]

  BootMulti[datavec0_,datavec1_,scenario_]:=
       Module[{pvec0,pvec1,difvec},
              pvec0=BootMultiOne[datavec0,scenario];
               pvec1=BootMultiOne[datavec1,scenario];
                difvec=pvec1-pvec0;
      Return[difvec]]

BootMultiOne[datavec_,scenario_]:=
Module[{datavecR,len,mxvec,rxvec,mvec,rvec,nvec,pvec},
            If[scenario=="fixed", datavecR=datavec];
            If[scenario=="random", datavecR=RanMulti[datavec]];
             {mvec,rvec}=Cumulate[datavecR];
               nvec=mvec+rvec;
             pvec=CompPVec[mvec,nvec];
      Return[pvec]]

Cumulate[datavecR_]:=
Module[{len,mxvec,rxvec,mvec,rvec},
   (*first half of vector is events; second half counts*)
                    len=Length[datavecR]/2;
              (*events *)
                  mxvec=Take[datavecR,len];
              (*non events*)
                 rxvec=Take[datavecR,-len];
            (*cumulative tail first*)
                mvec=Reverse@Drop[FoldList[Plus,0,mxvec],1];
                rvec=Reverse@Drop[FoldList[Plus,0,rxvec],1];
Return[{mvec,rvec}]]



 (*Random Number generation*)
 
 RanMulti[vec_]:=
 Module[{n,pvec,res},
 n=Apply[Plus,vec];
 pvec=vec/n//N;
res=RandomVariate[MultinomialDistribution[n, pvec]];
 Return[res]]
 
CompPVec[mvec_,nvec_]:=
Module[{pairvec,pvec},
pairvec=Transpose[{mvec,nvec}];
pvec=AdjustPair[#]& /@ pairvec;
Return[pvec]]

AdjustPair[{m_,n_}]:=
Module[{m0,n0,p},
If[n==0, p=0,
p=m/n//N];
Return[p]]
 
End[] 
EndPackage[]
