(*Mathematica:: Version 8.0      *)
(*:Context:: "survfit`"        *)
(*:Title::  TrialFit *)
(*:Summary::                     *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*input 
   ComputeBootSet				  survfitboot.m
   PlotExport					   survfitplot.m
   PlotBenefitScoresRD			   survfitRD.m
   PlotCut				 		   survfitplot.m*)
  
 
BeginPackage["survfitbasic`", "survfitplot`","survfitboot`", "survfitbootci`"]  

ReportTestSample::usage="ReportTestSample"
ReportParametersAUC::usage="ReportParametersAUC"

UnivariateFilter::usage="UnivariateFilter"
PlotInfoModel::usage="PlotInfoModel"
GenColor::usage="GenColor"


GenStoredName::usage="GenStoredName"
GenStoredName3::usage="GenStoredName"
PrintMod::usage="PrintMod"


Clear[ReportTestSample,GenColor,
GenStoredName,UnivariateFilter,PlotInfoModel,
PrintMod,GenStoredName3]

Begin["Private`"]	  

 PlotInfoModel[{resvec_,model_},fracmax_,xvec_,plotspec_,numcomp0_,mca_]:=   
        Module[{a,b,plotname,out,color},
          {a,b}=model;
         If[numcomp0==1,    color=Black,      color=GenColor[model]];
         If[model=={"RD","F"}, plotname="Risk DIfference\n with one marker"];
         If[model=={"RD","M"}, plotname="Risk DIfference\n with two markers"];
         If[model=={"RD", "X"}, plotname="Risk DIfference\n with five markers"];
         If[mca==False, numcomp=1, numcomp=numcomp0];
         out= ReportTestSample[resvec,plotspec,{fracmax,xvec,plotname,color,numcomp}];
        Return[out]] 
         
  ReportTestSample[{dvec_,difvec_,sevec_,m0_,m1_,n0_,n1_},
        {numcut_,showcut_,showfit_,showprog_,showtab_,datasetname_,aucdif_,maxboot_,y0_,y1_},
        {fracmax_,xvec_,plotname_,color_,numcomp_}]:=
      Module[{frac,inputvec,inputvecQ,storedname,ymin,ymax,qvec,
                 alpha,zorig,rownames,colnames, vecALL,dif0,low0,upp0,plotcut},
       (*m0=  number of events among participants with benefit scores >= cutpoint in group 0*)
       (*m1= number of events among participants with benefit scores >= cutpoint  in group 1*)
       (*n0 = number of participants with benefit scores >= cutpoint in group 0*)
       (*n1 = number of participants with benefit scores >= cutpoint in group 1*)
       (*frac =fraction of unique scores greater than or equal to cutpoint*)
        mat={difvec,xvec};
        (*TABLE OF CUTPOINTS*) 
 If[showcut,
      matr=Round[mat 1000]/1000//N;
      tab=TableForm[matr,TableHeadings->{{"difference", "benefitscore"},Automatic}];
     Print["     ",tab]];   
  (*FRACTION IN SCORES*)
         frac=(n0+n1)/(n0[[1]]+n1[[1]])//N;
       inputvec={dvec,frac,difvec,sevec,m0,m1,n0,n1};
   (*TABLE OF COUNTS*)
   If[showtab,
       Print["  test sample counts:   number greater than each score"];  
       mat={m0,n0-m0,n0,m1, n1-m1, n1};
       rowname={"arm 0 events","arm 0 non-events","arm 0 total","arm 1 events", "arm 1 non-events","arm 1 total"};
       Print["   ",TableForm[mat,TableHeadings->{rowname,Automatic}]]];
 (*BOOTSTRAP*)
      difboot=ComputeBootSet[inputvec,maxboot,numcut,showtab,"random"];      
   (*CONFIDENCE INTERVAL*)
          alphaS=.01/numcomp;
          showbinsearch=False;
	 {zboot,coverage}=FindCIM[difboot,difvec,sevec,alphaS,showbinsearch];
      (*OVERALL Z-STAT*)
          alphaORIG=.04;
          zorig=InvCDF[1-alphaORIG/2];
      (*CUTPOINT TABLE*)
      If[showtab,
        Print[" "];
        Print["CUTPOINT CONFIDENCE INTERVAL CALCULATIONS"];
         zbon=InvCDF[1-alphaS/(2 numcut)];
         zunadj=InvCDF[1-alphaS/2];
         headx={"alpha", "z-unadjusted", "z-Bonferoni", "z-bootstrap", "coverage of z-boot"};
         vecx=Round[1000 {alphaS,zunadj,zbon,zboot,coverage}]/1000//N;
        Print["  ",TableForm[{vecx},TableHeadings->{None,headx}]]]; 
   (*RESULTS TABLE*) 
     If[showtab,
        matTEST=GenTable[inputvec,zboot];
         mat=Join[{vecALL},matTEST];  
                mat=matTEST;
         rownames=Range[numcut+2]-2;
        colnames={"benefit\nscore","quantile","events\ngroup\n0","events\ngroup\n1",
                       "total\ngroup\n0","total\ngroup\n1","dif","se","low","upp"};
        Print[" "];
        Print["SUMMARY OF RESULTS"];
        Print["  ",TableForm[mat,TableHeadings->{rownames, colnames}]]]; 
(*SUBPOPULATION TREATMENT EFFECT PATTERN PLOT  in test sample*) 
       rangefrac={0} ~Join~ (Range[numcut])/numcut;	
        qvec=Round[rangefrac fracmax 100]/100//N;
          ymin=Min[difvec-zboot sevec];
        ymax=Max[difvec+zboot sevec];
        plotcore={inputvec,dif0,low0,upp0,dif0,zboot,plotname,qvec,color};
 Return[{ymin,ymax,plotcore}]]



 ReportParametersAUC[parvec_,pos_,auclist_,xname_,groupname_,showfit_]:=
    Module[{xnamevec,mat,rowname,aucvec,tab},
        aucvec=Round[auclist 1000]/1000//N;
        xnamevec= Join[{"cons"},xname[[pos]]];
       mat={xnamevec,parvec};
      rowname=StringJoin[groupname, " ",#]& /@ {"variable","coefficient"};
       tab=TableForm[mat, TableHeadings->{rowname,None}];
      If[showfit,Print[aucvec]; Print[tab]];
      Return[tab]]

		  

  ReportCutpoint[dvec_,cutvec_,name_]:=
   Module[{list,mat,rowname},
   Print["cutpoints tail counts ",name];
   list=ReportCutpointOne[dvec,#]& /@ cutvec;
   mat=Transpose[list];
   rowname={"    cutpoint","tail counts"};
   Print["     ",TableForm[mat,TableHeadings->{rowname,Automatic}]];
   Return[list]]
  
   ReportCutpointOne[dvec_,cut_]:=
   Module[{dvecx,len,cutx},
               dvecx=Select[dvec, (#>=cut)&];
               len=Length[dvecx];
               cutx=Round[cut 1000]/1000//N;
               Return[{cutx,len}]]
  
 
 
 
(*----------------support functions-----------------------*)

SelectColumns[x_,indexvec_]:=
Module[{x1,x2,x3},
x1=Transpose[x];
x2=x1[[indexvec]];
x3=Transpose[x2];
Return[x3]]
  
TakeColumns[x_,len_]:= Transpose@Take[Transpose[x],len];
 
 GenTable[{d_,frac_,dif_,se_,m0_,m1_,n0_,n1_},z_]:=
 Module[{low,upp,difr,lowr,uppr,dr,fracr,matr,hear},
          low=dif-z se;
          upp=dif+z se;
          difr=round@dif;
          ser=round@se;
          lowr=round@low;
          uppr=round@upp;
          fracr=Round[frac 1000]/1000//N;
          dr=round@d;
         matr=Transpose[{dr,fracr,m0,m1,n0,n1,difr,ser,lowr,uppr}];
 Return[matr]]
 
 
round[x_]:=Round[x 1000]/1000//N;	
InvCDF[alpha_]:= InverseNormal[0,1,alpha]
InverseNormal[mu_, sigma_, z_]:= mu + Sqrt[2] sigma InverseErf[2 z - 1]
 

   UnivariateFilter[xdata_,ydata_,xname_,numfilter_,showprog_:False]:=
    Module[{t,g,set,tlist,posall,xnametop,len,yF}, 
        t=TStat[xdata,ydata];
      (*take largest ordered smallest to largest*) 
 	    g=Length[t];
 	    set=Sort@Transpose[{t,Range[g],xname}];
             {tlist,posall,xnametop}=Transpose[Take[set,-numfilter]]; 
             If[showprog,
	               tr=Round[t 100]/100//N;
	               setr=Sort@Transpose[{tr,Range[g],xname}];
	               settop=Reverse@Take[setr,-5];
	               Print["    ",TableForm[settop,TableHeadings->{Automatic,{"t-statistic", "position","variable"}}]]];
  Return[{tlist,posall,xnametop}]]





TStat[xdata_,ydata_]:=
      Module[{g,n,posvec0,posvec1, x0,x1, m0,v0,m1,v1, set,g0,n0,g1,n1},
              (*position of outcome y=0*)    
               posvec0=Flatten@Position[ydata,0];
          (*position of outcome y=1*)
              {g,n}=Dimensions[xdata];
               posvec1=Complement[Range[n],posvec0];
         (*gene by person matrix for y=0*);
                x0= Transpose@(Transpose[xdata])[[posvec0]];
          (*gene by person matrix for y=1*);
                x1= Transpose@(Transpose[xdata])[[posvec1]];
          (*mean and variance*)
                m0=Mean[#]& /@ x0;
                v0=Variance[#]& /@  x0;
                m1=Mean[#]& /@ x1;
                v1=Variance[#]& /@ x1;
           (*ASOLUTE VALUE t-stat of difference in control group*)
            {g0,n0}=Dimensions[x0];
	     {g1,n1}=Dimensions[x1];
	        t=Abs@(m1-m0)/Sqrt[v0/n0+v1/n1]//N;
            Return[t]]
 


GenColor[model_]:=
Module[{name,tune,color},
{name,tune}=model;
If[name=="RD",color=Red];
If[name=="RDB",color=Orange];
If[name=="RDC",color=Brown];
If[name=="Cadit",color=Blue];
If[name=="CaditB",color=Purple];
If[name=="Vote",color=Green];
If[name=="Max",color=Gray];
If[name=="Resp",color=Magenta];
Return[color]]


GenStoredName[datasetname_,method_,lenmod_,numcut_,numsplit_]:=
Module[{numcuts,lenmods,methods,numsplits,storedname},
      numcuts=ToString[numcut];
      numsplits=ToString[numsplit];
      lenmods=ToString[lenmod];
      methods=ToString[method];
      storedname=StringJoin["predsurvSTORE", datasetname,methods,lenmods,numcuts,numsplits,".m"];
  Return[storedname]]  
 
 GenStoredName3[datasetname_,method_,lenmod_,numcut_,numsplit_,seed_]:=
 Module[{numcuts,lenmods,methods,numsplits,storedname,seeds},
       numcuts=ToString[numcut];
       numsplits=ToString[numsplit];
       lenmods=ToString[lenmod];
       methods=ToString[method];
       seeds=ToString[seed];
       storedname=StringJoin["predsurvSTORE", datasetname,methods,lenmods,numcuts,numsplits,seeds,".m"];
    Return[storedname]]  

PrintMod[name_,level_,showprog_,showtemp_]:=
Module[{temp},
    temp=PrintTemporary["    fitting model ",name," ",level];      
     Pause[2];
    NotebookDelete[temp];
    If[showprog==True || showtab==True, Print[" "]; Print[nam," ",level]];
Return[Null]]



End[] 
EndPackage[]

