
(*Mathematica:: Version 8.0      *)
(*:Context:: "survfit`"        *)
(*:Title::        TrialFitSurv *)
(*:References::                  *)
(*Date   2014 Stuart G. Baker *)
(*Input
GenStoredName	survfitibasic.m
PlotInfoModel		survfitbasic.m
TrialFitModel		survfitmodel.m
GenDataSplit		survfitsplit.m
GenDatasetSurv        survfitsurv.m
TrialFitParameters	survfitinputcheck.m*)

(*Package List
   survfit.m 		   	calls all files and input check
   survfitinputcheck.m	checks input
    survfitmodel.m 	evaluate models in test sample
  (*Models*)
   survfitRD.m		      	
   survfitRDtrain.m	   
   survfitRDtest.m    		

  (*support*)
  survfitsplit.m			data splitting
   survfitbasic.m		       key support functions
   survfitlogit.m 		   	fit logistic regression 
   survfitplot.m		   	plotting results
   survfitboot.m		   	bootstrap test sample       
   survfitbootci.m	   	   simultaneous confidence interval algorithm for boostrap
  (*data*)
  survfitsim.m		   	generate simulated data
   survfitdata.m			format data from breast cancer trial (not publicly available) 
  *)

 (*Key Function 
 TrialFitSurv[dataset] where
     dataset={x0,x1,{t0,c0},{t1,c1},xname,datasetname} where
       x0 is g x n matrix of baseline variables for randomization group 0
      x1 is g x n matrix of baseline variables for randomization group 1
      t0 is length n list of survival times for randomization group 0
      t1 is length n list of survival times for randomization group 1
      c0 is length n list of censoring indicator (1= censored, 0 not)  for randomization group 0
      c1 is length n list of censoring indicator (1= censored, 0 not)  for randomization group 1
       xname= a length g list of names of baseline variables 
      datasetname=name of dataset*)
      
   
 
BeginPackage["survfit`","survfitinputcheck`",
"survfitmodel`",
"survfitRD`", "survfitRDtrain`","survfitRDtest`",
"survfitbasic`","survfitsplit`","survfitbasictest`",
"survfitlogit`", "survfitplot`","survfitboot`", "survfitbootci`","survfitsurv`",
 "survfitsim`"]

TrialFitSurv::usage="TrialFitSurv[data,options]"


Clear[TrialFitSurv]

Options[TrialFitSurv]=
 {FractionSplit->.5,
  Time->.1,
  PlotFormat->"quantiles",
   ModelSet->"Basic",
  NewFitQ->True,
  ShowProgQ->False,
  ShowTabQ->False,
  MinimumSubgroupSize->100,
  NumCut->8,
  NumFilter->20,
  MaxBoot->5}



NewFitQ::usage="true or false for using stored parameter estimates"
FractionSplit::usage="fraction split into test sample (between .2 and .8)"
Time::usage="time of analysis of survival data"
MinimumSubgroupSize="miniumum sample size for subgroup"
NumCut::usage="number of cutpoints for subgroups (1 to 10) "
ShowProgQ::usage="show information about progress of fitting"
ShowTabQ::usage="show data and results tables"
NumFilter::usage="number in initial univariate filter"
MaxBoot::usage="number of bootstrap iterations"
PlotFormat::usage=" quantiles or score for horzontal axis"

Begin["Private`"]	  

 TrialFitSurv[dataset0_,options___Rule]:=
    Module[{optionvec,check,parameterset,method,split,time,datacore,modelset0,modelset,indexm,indexc,dataset,
      plotinfoset,ymin,ymax},
         optionvec= {FractionSplit,Time,NumCut,NumFilter,NewFitQ,
                             ShowProgQ,ShowTabQ, MaxBoot, 
                              MinimumSubgroupSize,PlotFormat,ModelSet}/. {options}/.Options[TrialFitSurv]; 
      (*MODIFIED DATA SET FOR ANALYSIS TIME*)
      time=optionvec[[2]];
        datasetname=dataset0[[-1]];
        Print["DATA SET ",datasetname];
          Print["ANALYSIS TIME ",time];  
          
          (*KEY STEP*)
   
           dataset=GenDatasetSurv[dataset0,time];
           
           (*KEY TRANSFORMATION FOR TRAINIG SAMPLE FITTING:
            dataset={x0,x1,{t0,y0,c0},{t1,y1,c1},xname,dataname};
            where  y=1 if survive, 
                       y=0 if death
                       y=Survival to specified time | survive to observed time of censoring*)
                       
      (*MODEL SET*)
         modelset0=optionvec[[-1]];
             If[modelset0==="Basic",
                modelset={{"RD","F"},{"RD","M"},{"RD","X"}},
          modelset=modelset0];      
     Print["MODELSET: ",modelset];
           
      {check,parameterset,plotspec}=TrialFitParameters[dataset,optionvec];
        
          split=optionvec[[1]];
           datasetname=dataset[[-1]]; 
      plotmat=Null;  
   (*computation*)  
    If[check,
    seed=19;
           {datacore,datainfo}=GenDataSplit[dataset,split,seed];  
           
           (*HELPFUL NOTE
            {dataTRAIN,dataTEST,nTEST0,nTEST1}=datacore;
	     dataTRAIN={xTRAIN0,xTRAIN1,yTRAIN0,yTRAIN1};
	     dataTEST={xTEST0,xTEST1,yTEST0,yTEST1,cTEST0,cTEST1}; 
	     where yTEST0, yTEST1 are predicted survival
                 *)
           
           
         
            mca3=False; (*no mulitple comparison adjustment for different types of models*)
            TrialFitMethod1[dataset,datainfo,datacore,modelset,parameterset,datasetname,plotspec,mca3]];
    
        Return[Null]]
    

 




               
 TrialFitMethod1[dataset_,datainfo_,datacore_,modelset_,parameterset_,datasetname_,plotspec_,mca_]:= 
 Module[{input,method,newfitQ,fracmax,maxboot,tuningparameters,check,numcvsplits,numsplit,plotformat,
             yminvec,ymaxvec,plotvec0,ymin,ymax,plotvec,ncol,mat,
             plotmat,plot,plotvec1},
             {input,method,tuningparameters,check,numcvsplits,plotformat,time}=parameterset;
           numcut=input[[8]];
           fracmax=input[[9]];
           newfitQ=input[[10]];
          split=input[[12]];
          numsplit=Round[split 100];
          ReportRun[input,datainfo,modelset];
           (*FIT MODELS*)
           lenmod=Length[modelset];
          storedname=GenStoredName[datasetname,2,lenmod,numcut,numsplit];
	    If[newfitQ==False,
	                          mat=Quiet@Drop[ReadList[storedname],1][[1]];
	                           Print["   importing stored parameter estimates from ",storedname]];
	             If[newfitQ==True,
	                       Print["Fitting benefit functions"];
	                         mat=TrialFitModel[datacore,#,parameterset]& /@ modelset;   
	                        Print["    exporting training sample fits ",storedname];
                     Export[storedname,mat]];  
          If[lenmod==1,ncol=1];
          If[lenmod==2,ncol=2];
          If[lenmod==3, ncol=3]; 
          showparameterestimates=True;
           PlotFromModelFit[mat,fracmax,plotspec,ncol,plotformat,"all",mca,showparameterestimates];       
 Return[Null]]  
 

 
PlotFromModelFit[mat_,fracmax_,plotspec_,ncol_,plotformatx_,plotname_,mca_,showparameterestimates_]:=
Module[{resset,xvecset,parset,pair,xvec,tri1,numcomp,plotinfovec,plotx},
(*input*)
    {modelset,resset,xvecset,parset}=Transpose[mat];
(*print paramters*)
If[showparameterestimates,
    pair=Transpose[{parset,modelset}];
    Print["PARAMETER ESTIMATES FOR LOGISTIC REGRESSION WITH BINARY ENDPOINT"];
    Print[" based on survival data input"];
    PrintParameter[#]& /@pair]; 
(*plot set*)
    xvec=xvecset[[1]];
     tri1=Transpose[{resset,modelset}];
    numcomp=Length[modelset];
    plotinfovec=PlotInfoModel[#,fracmax,xvec,plotspec,numcomp,mca]& /@ tri1;
     plotx=PlotGrid[plotinfovec,ncol,plotformatx];
     If[plotformatx=="quantiles",add="Q"];
      If[plotformatx=="quantileonly",add="R"];
     If[plotformatx=="score",add="S"];
     namex=StringJoin["TEST",add,plotname];     
    ExportPlot[namex,datasetname,plotx];
Return[mat]]

PrintParameter[{tab_,model_}]:=
Module[{len,tab0,tab1},
  Print[model];
  len=Length[tab];
  If[len==1, Print["  ",tab[[1]]]];
  If[len==2, {tab0,tab1}=tab;
  Print["  ",tab0];
  Print["  ",tab1]];
Return[Null]]

 PlotGrid[plotinfovec_,ncol_,plotformatx_]:=
 Module[{yminvec,ymaxvec,i,len,rem,nullvec,plotvecadd,plotvec,plotmat,plot},
    {yminvec,ymaxvec,plotvec0}=Transpose[plotinfovec];
      ymin=Min[yminvec];
     ymax=Max[ymaxvec];
     plotformat=parameterset[[-1]];
     If[ncol==1,
        plotvec=PlotCut[#,{ymin,ymax},"score",0,ncol]& /@ plotvec0;
       plot=Show[plotvec]];
     If[ncol>1,
        plotvec=PlotCut[#,{ymin,ymax},plotformatx,1,ncol]& /@ plotvec0;
        plot=PlotGridFormat[plotvec,ncol]];
    Return[plot]]
 
 PlotGridFormat[plotvec_,ncol_]:=
 Module[{len,rem,plotvecadd,nullvec,plotmat,plot},
       len=Length[plotvec];
      rem=Mod[len,ncol];
     If[rem==0,
         plotvecadd=plotvec,
         nullvec=Table[Null,{i,1,ncol-rem}];
        plotvecadd=Join[plotvec,nullvec]];
     (*partition*)
     plotmat=Partition[plotvecadd,ncol];
      plot=Show[GraphicsGrid[plotmat],ImageSize->Large];
 Return[plot]]
 



  
 
 (*-------------------------------------------------Suppport-----------------------------------------------*)
     
  ExportPlot[plotnamecore_,datasetname_,plot_]:=
  Module[{ },
        Print[plot];
        plotname=StringJoin["survfit",datasetname,"FIG",plotnamecore,".eps"];
        Print["exporting ",plotname];
  	Export[plotname,plot];
     Return[Null]]; 


ReportRun[input_,datainfo_,modelset_]:=
Module[{fracmax,numfilter,maxboot,numcut,aucdif1,aucdif2,numchoose1,numchoose2,
             datasetname,nvar,nALL0,nALL1,split},
         fracmax=input[[9]];
        numfilter=input[[13]];
         maxboot=input[[2]];
         numcut=input[[8]];
        {datasetname,nvar,nALL0,nALL1,split}=datainfo;
	Print["   sample  sizes in groups 0 and 1:  ", {nALL0,nALL1}];
	Print["   initial number of variables = ",nvar];
        Print["   fraction split into training sample = ",split];
	Print["   number in univariate filter =",numfilter];
	Print["   number of bootstraps for confdience interval in test sample =",maxboot];
        Print["   quantiles:  largest = ",fracmax, " number cutpoints= ",numcut];
   Return[Null]]



End[] 
EndPackage[]


