(*Mathematica:: Version 7.0 *)
(*:Context:: "surrogate`" *)
(*:Title:: core estimates*)
(*Requirements:*)
 (*Date   2017 Stuart G. Baker *)  					
(*SFitPlot  sfitplot.m*)


BeginPackage["sfitsimplot`","sfitplot`","sfitlik`"]  


SFitSimPlot::usage="SFitSimPlot[]"


Clear[SFitSimPlot]

Begin["Private`"]

SFitSimPlot[show_:False]:=
Module[{plotvec,plotmat,rvec,set,bmat,vmat,headings, matB,matTm,len,plotx,x,datanum,dataset},
F=1; (*size of new trial/median size of trials*)
sizetype=1;
datanum={1,2,3, 4};

dataset=GenDataSim[#,sizetype,F,show]& /@ datanum;
set=SFitSim[#,x,F,show]& /@ dataset;
{plot,SSM,SSMest,SSMmle,best,bmle,bslope, sigmaBest,sigmaBmle,sigmaB,sigmaTest,sigmaT,k}=Transpose[set]//N;

(*parameter estimates*)
showpar=False;
If[showpar,
(*slopes*)
  Print["Slopes"];
  headingsS={Automatic, {"num trials", "True", "est", "mle"}};
  matS=Transpose[{k, bslope,best,bmle}];
  Print@TableForm[matS,TableHeadings->headingsS];
(*between SE*)
  Print["Between SE"];
  headings={Automatic, {"num trials", "True", "est", "mle"}};
  matB=Transpose[{k,sigmaB,sigmaBest,sigmaBmle}];
  Print@TableForm[matB,TableHeadings->headings];
(*within SSM*)
  Print["SSM"];
  headings={Automatic, {"num trials","True", "est", "mle"}};
  matT=Transpose[{k, SSM,SSMest,SSMmle}];
  Print@TableForm[matT,TableHeadings->headings]];
  
  
 (*plot*)
 len=Length[plot];
 If[OddQ[len], plotx=Join[plot,{Null}], plotx=plot];
plotmat=Partition[plotx,2];
plotx=Show[GraphicsGrid[plotmat],ImageSize->Large];
ExportPlot[plotx,"fig1"];


Return[Null]]



SFitSim[data_,x_,F_,show_]:=
Module[{xvec,yvec,nvec,wvec,sigmaB,sigmaT,bslope,name,dataname,
             plot,best,vest,bmle,vmle,wNEW,nmean,sigmaBest,sigmaBmle,sigmaTest,nNEW},
{xvec,yvec,nvec,wvec,name,sigmaB,sigmaT,bslope,dataname}=data;      
nNEW=F Median[nvec];
{plot,SSMest, SSMmle,best,bmle,vest,vmle,wNEW,k}=SFitPlot[{xvec,yvec,nvec,wvec,name,nNEW},x,show];
(*true values*)
  sigmaBest=Sqrt@vest;
  sigmaBmle=Sqrt@vmle;
  nmean=Mean[nvec];
sigmaTest=Sqrt[wNEW];
vB=sigmaB^2;
varvec=vB+wvec;
 varb= 1/Total[xvec^2 /varvec];
  xmean=Mean[xvec];
  nmean=Mean[nvec]; 
  wNEW=Mean[wvec nvec]/nNEW;
    varpred=  xmean^2 varb + vB + wNEW;
    SSM=Sqrt[varpred/wNEW];
      res={plot,SSM,SSMest,SSMmle,best,bmle,bslope, sigmaBest,sigmaBmle,sigmaB,sigmaTest,sigmaT,k};
Return[res]]


GenDataSim[datanum_,sizetype_,F_,show_]:=
Module[{len,sigmaT, ntype,difSvec,input,res1,res2,res3,res,wvec,seratio,n,name},
b=.7;
n=100;
seW=3;
sigmaT=Sqrt[n] seW;
If[datanum==1, len=10;  b=.9;   sigmaB=5;    name0="(a) "];
If[datanum==2,  len=10; b=.9;  sigmaB=2;     name0="(b) "];
If[datanum==3,  len=10; b=2;   sigmaB=5;    name0="(c) "];
If[datanum==4,  len=10; b=2;   sigmaB=2;    name0="(d) "];
If[datanum==5, len=30;  b=.9;   sigmaB=2;    name0="(e) "];
If[datanum==6,  len=30; b=.9;  sigmaB=5;    name0="(f) "];
If[datanum==7,  len=30; b=2;   sigmaB=2;    name0="(g) "];
If[datanum==8,  len=30; b=2;   sigmaB=.5;   name0="(h) "];

difSvec=Range[len];
If[sizetype==1, ntype="constant size";  nvec0=Table[n,len]];
If[sizetype==2, ntype="increasing size"; nvec0=(.2 + Range[len]/len) n];
If[sizetype==3, ntype="deceasing size"; nvec0=Reverse@(.2+ Range[len]/len) n];
If[sizetype==4, ntype="random size"; SeedRandom[18]; nvec0=n Table[.5 + Random[], len]];
If[show,
 name=StringJoin["Hypothetical slope = ",ToString[b],"  sigmaB = ",ToString[sigmaB], " seW = ",ToString[seW], " factor= ",ToString[F]],
 name=StringJoin["Hypothetical data ",name0]];

 nvec=Round[nvec0];
 varT=sigmaB^2+(sigmaT^2)/nvec;
 seT=Sqrt[varT]//N;
 SeedRandom[18];
 errorT=(RandomVariate[NormalDistribution[0,#]])&  /@ seT;
 difTvec=b difSvec;
 difTvecR=difTvec+errorT;
wvec=(sigmaT^2)/nvec//N;
seratio=sigmaB/sigmaT//N;

res={difSvec,difTvecR,nvec,wvec,name, sigmaB, seW,b,name};
Return[res]]





End[] 
EndPackage[]

Print["SFitSimPlot[]"];

