(*Mathematica:: Version 7.0 *)
(*:Context:: "surrogate`" *)
(*:Title:: core estimates*)
(*Requirements:*)
 (*Date   2017 Stuart G. Baker *)  					
(*Input
FitLin   sfitlik.m
FitLik   sfitlik.m*)

BeginPackage["sfitsim`","sfitlik`"]  


SFitSim::usage="SFitSim[maxiter]"


Clear[SFitSiim]

Begin["Private`"]




SFitSim[maxiter_,sizetype_:1]:=
Module[{numtrialsvec,sigmaBvec,bvec0,sigmaTvec0,x,n,
         lenvec,ntypevec,b,sigmaT,set0,set,kvec,kvecs,matS,colnameS},
show=False;
sizenewtrialvec={1,.2};
numtrialsvec={10,30};
sigmaBvec={5,2};
b=2;
n=100;
seW=3;
sigmaT=seW Sqrt[n]//N;
Print["number of iterations ",maxiter];
Print["slope b = ",b];
Print["seW = ",seW];
Print["sigmaT = ",sigmaT];
set0=Outer[List,sizenewtrialvec,numtrialsvec,sigmaBvec];
set=Partition[Flatten[set0],3];
Print[set];

mat=GenSimCore[x,{b,sigmaT,sizetype,n},#,maxiter,show]& /@ set;
matr=Round[mat 100]/100//N;
 colname={"sizenewfactor", "num trials", "sigmaB","sest","smle","b","best","bmle", "cover pred",  "cover true"};
  Print@TableForm[matr, TableHeadings->{None, colname}];
Return[matr]]


GenSimCore[x_,{b_,sigmaT_,sizetype_,n_},{sizenew_,len_,sigmaB_},maxiter_,show_]:=
Module[{ntype,xvec,input,res1,res2,res3,res,coverageS,coverageT,coverageC,SSM,SSMest,SSMmle,best,bmle,sest,smle},
If[sizetype==1, ntype="constant size";  nvec=Table[n,len]];
If[sizetype==2, ntype="increasing size"; nvec=n/2+2 n (Range[len]/len)];
If[sizetype==3, ntype="random size"; SeedRandom[18]; nvec=Round[n/2 + 2 n (Table[Random[], len])]];
(*
Print["size distribution ",ntype, " with mininum and maximum numbers per arm of ",{Min[nvec],Max[nvec]}];
Print["sizenew factor ",sizenew];
*)
xvec=Range[len];
{coverageS,coverageT,coverageC,SSM,SSMest,SSMmle,best,bmle,sest,smle}=GenSimOneSet[x,{xvec,b,sigmaB,sigmaT,nvec,sizenew},maxiter,show];
resx={sizenew,len,sigmaB,sest,smle,b,best,bmle,SSM,SSMest,SSMmle,coverageS,coverageT};
resx={sizenew,len,sigmaB,sest,smle,b,best,bmle,coverageS,coverageT};

Print[resx];
Return[resx]]


GenSimOneSet[x_,{xvec_,b_,sigmaB_,sigmaT_,nvec_,sizenew_},maxiter_,show_]:=
Module[{mat,mean,i},
SeedRandom[10];
mat=Table[GenSimOne[i,x,{xvec,b,sigmaB,sigmaT,nvec,sizenew},show],{i,1,maxiter}];
mean=Mean[mat];
meanr=Round[mean 10]/10//N;
Return[mean]]


GenSimOne[i_,x_,{xvec_,b_,sigmaB_,sigmaT_,nvec_,sizenew_},show_]:=
Module[{varT,seT,errorR,yvec,xNEW,nNEW,
       yNEW,seTnew,yNEWR, estX,lowX,uppX,varpredX,SSM,
     lowA,uppA,wA,indA, estZ,lowZ,uppZ,indC,hmean,wmean,v,
      lowB,uppB,wB,indB,resA,resB,res},
(*TRUE VECTOR*)
   varT=sigmaB^2 + (sigmaT^2)/nvec;
   wvec=sigmaT^2/nvec;
   seT=Sqrt[varT];
(*RANDOM TRUE FOR MODEL FITTING*)   
   errorT=(RandomVariate[NormalDistribution[0,#]])&  /@ seT;
   yvec= b xvec+errorT;
 (*NEW SAMPLE*)
     xNEW=Median[xvec];
    nNEW=sizenew Round@Median[nvec];
 
 
 (*TRUE VALUE WITH RANDOM BETWEEN TRIAL VARIANCE*)
   yNEW= b xNEW + RandomVariate[NormalDistribution[0,sigmaB]]; 
 
 
(*COVERAGE OF PREDICTED CONFIDENCE INTERVAL*)
    {estX,lowX,uppX, varpedX,varb, varR,SSMest,SSMmle,best,bmle,vest,vmle,wm,hmean,wmean,v}=FitLik[{xvec,yvec,nvec,wvec,nNEW},x];    
   lowA=lowX /. x->xNEW;
   uppA=uppX /. x->xNEW;
   If[yNEW < uppA && yNEW > lowA, indA=1, indA=0];
  wA=uppA-lowA;

(*COVERAGE OF CI FOR TRUE EFFECT*)
   seTnew=sigmaT/Sqrt[nNEW];
   yNEWR=yNEW+ RandomVariate[NormalDistribution[0,seTnew]]; 
   lowB=yNEWR - 1.96 seTnew;
  uppB=yNEWR + 1.96 seTnew;
  If[yNEW < uppB && yNEW > lowB, indB=1, indB=0];


(*PREDICTED CONFIDENCE INTERVAL STANDARD MODEL*)
    {estZ,lowZ,uppZ,varbZ,varRz,MSE}=FitLin[{xvec,yvec,nvec,wvec,nNEW},x];    
   yNEW= b xNEW + RandomVariate[NormalDistribution[0,sigmaB]]; 
   lowC=lowZ /. x->xNEW;
   uppC=uppZ /. x->xNEW;
   If[yNEW < uppC && yNEW > lowC, indC=1, indC=0];




(*RESULT*)
  sest=Sqrt[vest];
  smle=Sqrt[vmle];
  SSM=(xNEW^2 varb +sigmaB^2 + (sigmaT^2)/nNEW)/ (sigmaT^2/nNEW);
  SEM=Sqrt[SSM];
  SEMest=Sqrt[SSMest];
  SEMmle=Sqrt[SSMmle];
  res={indA,indB,indC,SEM,SEMest,SEMmle,best,bmle,sest,smle}//N;
 
  res={indA,indB,indC,SEM,SEMest,SEMmle,best,bmle,sest,smle}//N;
 
 Return[res]]




End[] 
EndPackage[]

Print["SFitSim[maxiter]"];

