(*Mathematica:: Version 7.0 *)
(*:Context:: "surrogate`" *)
(*:Title:: core estimates*)
(*Requirements:*)
 (*Date   2010 Stuart G. Baker *)  					
(*Input 
FitLik      sfitlik.m*)

BeginPackage["sfitplot`","sfitlik`"]  


SFitPlot::usage="SFitPlot[{xvec,yvec,nvec,wvec,name,nNEW},x]"
ExportPlot::usage="ExportPlot"

Clear[SFitPlot,ExportPlot]

Begin["Private`"]


SFitPlot[{xvec_,yvec_,nvec_,wvec_,name_,nNEW_},x_,show_:False]:=
Module[{plotvec1,ymin1,ymax1,plotvec2,ymin2,ymax2,ymin,ymax,xdif,xmin0,xmax0,ydif,ymin0,ymax0,low0,low1,upp0,upp1,
           name1,name2,range,plot1,plot2,plot,SSMvec1,SSMvec2,varpredMED,plineY,hmean,wmean,MSE,
           head,seratio,seratior,seratios,sigmaB,sigmaT,v,wm,j,k},
           
{plotvec,varb,varR,low0,upp0,low1,upp1,ymin,ymax,varpredMED,SSMest, SSMmle,best,bMLE,vest,vMLE,wm,hmean,wmean,v}
=SFitPlotLik[{xvec,yvec,nvec,wvec,nNEW},x,show];
xmin=Min[xvec];
xmax=Max[xvec];
xdif=xmax-xmin;
xmin0=xmin-.05 xdif;
xmax0=xmax+.05 xdif;
ydif=ymax-ymin;
ymin0=ymin-.05 ydif;
ymax0=ymax+.50 ydif;
range={{xmin0-.02 xdif,xmax0+.02 xdif},{ymin0,ymax0}};

(*prediction separation score*)
  PIndex= best xdif/ (2 1.96 Sqrt[varpredMED]);
 PIndexr=Round[PIndex 100]/100//N;
   PIndexs=ToString[PIndexr];
   PIndexx=StringJoin["prediction separation score = ",PIndexs];
  textPIndex=Graphics@Text[PIndexx,{xmin +.01 xdif, ymax+ .35 ydif}, {-1,0}];

(*standard error  multiplier*)
SEMest=Sqrt[SSMest];
     SEMr=Round[SEMest 100]/100//N;
   SEMs=ToString[SEMr];
   SEMx=StringJoin["standard error multiplier = ",SEMs];
   textSEM=Graphics@Text[SEMx,{xmin +.01 xdif, ymax+ .25 ydif}, {-1,0}];


(*sample size  multiplier*)
     SSMr=Round[SSMest 100]/100//N;
   SSMs=ToString[SSMr];
   SSMx=StringJoin["sample size multiplier = ",SSMs];
   textSSM=Graphics@Text[SSMx,{xmin +.01 xdif, ymax+ .45 ydif}, {-1,0}];


(*correlation*)
corr=Correlation[xvec,yvec];
   corrr=Round[corr 100]/100//N;
   corrs=ToString[corrr];
   corrx=StringJoin["trial-level correlation coefficient = ",corrs];
   textcorr=Graphics@Text[corrx,{xmin +.01 xdif, ymax+ .25 ydif}, {-1,0}];

(**prediction separation line*)
plineY= (upp0 + low1)/2;
pline=Graphics@{Thickness[.01],Green,Dashing[{.01,.01}],Line[{{xmin0,plineY},{xmax0,plineY}}]};
vline0=Graphics@{Thickness[.01],Red,Dashing[{.01,.01}],Line[{{xmin0,low0},{xmin0,upp0}}]};
vline1=Graphics@{Thickness[.01],Red,Dashing[{.01,.01}],Line[{{xmax0,low1},{xmax0,upp1}}]};

(*
(*p-value for slope *)
seb=Sqrt[varb];
z= best/seb;
pval=PValue[z];
Print[{best,seb,z}];
pvalr=Round[pval 10000]/10000//N;
pvals=ToString[pval];
pvalx=StringJoin["p-value for slope = ",pvals];
textpval=Graphics@Text[pvalx,{xmin +.01 xdif, ymax+ .15 ydif}, {-1,0}];
*)


 
(*sample size  previous *)
   nMEDr=Round[Median[nvec]100]/100//N;
   nMEDs=ToString[nMEDr];
   nMEDx=StringJoin["median size of previous trials = ",nMEDs];
   textnMED=Graphics@Text[nMEDx,{xmin +.01 xdif, ymax+ .15 ydif}, {-1,0}];
   
   
   (*sample size new *)
      nNEWr=Round[nNEW 100]/100//N;
      nNEWs=ToString[nNEWr];
      nNEWx=StringJoin["size of new trial = ",nNEWs];
   textnNEW=Graphics@Text[nNEWx,{xmin +.01 xdif, ymax+ .05 ydif}, {-1,0}];
   
  (*INCLUDE NAIVE CONFIDENCE INTERVALS*) 
   {plotLin,varbLin,varRLin,MSE}=SFitPlotLin[{xvec,yvec,nvec,wvec,nNEW},x];
   xmean=Mean[xvec];
   varbx=xmean^2 varb;
  varbLinx= xmean^2 varbLin;
  If[show,
Print["  random effects   varb, varremainder wm,hmean,wmean v ",  {varbx,varR,wm,hmean,wmean,v}];
Print["   fixed effects,       varb, MSE/nNEW=varremainder          ",  {varbLinx, varRLin}]];

(*plot*)
  If[show,
  plot=Show[plotvec,plotLin, textSSM,textPIndex,textcorr, textnNEW,textnMED,pline,Frame->True,
      FrameLabel->{"effect of treatment on the surrogate endpoint", "effect of treatment on the true endpoint", name,None},
     	  PlotRange->range,Axes->False,AspectRatio->1],
  
  plot=Show[plotvec, textSSM,textPIndex, pline, vline0,vline1,textcorr,
     Frame->True,
    FrameLabel->{"effect of treatment on the surrogate endpoint", "effect of treatment on the true endpoint", name,None},
     	  PlotRange->range,Axes->False,AspectRatio->1]];
     	 k=Length[xvec];
Return[{plot,SSMest, SSMmle,best,bMLE,vest,vMLE,wm,k}]]




SFitPlotLik[{xvec_,yvec_,nvec_,wvec_,nNEW_},x_,show_]:=
Module[{res,xmin,xmax,pair,plotpoints,plotlines,plotvec,plot,plot1,plot2,plot3,est,low,upp,varpred,varb,varR,hmean,wmean,v,
 ymin1,ymin2,ymin3,ymin,ymax1,ymax2,ymax3,ymax,xMED,varpredMED},
{est,low,upp,varpred,varb,varR,SSMest, SSMmle,best,bMLE,vest,vMLE,wm,hmean,wmean,v}=FitLik[{xvec,yvec,nvec,wvec,nNEW},x,show];
xmin=Min[xvec];
xmax=Max[xvec];
pair=Transpose[{xvec,yvec}];
plotlines=Flatten@GenLines[{xvec,yvec,nvec,wvec}]; 
 color=Blue;   
 dash=Dashing[{.03,.03}];
  plot1=Plot[est,{x,xmin,xmax},PlotStyle->Blue];
  plot2=Plot[low,{x,xmin,xmax},PlotRange->All,PlotStyle->{color,dash}];
 plot3=Plot[upp,{x,xmin,xmax},PlotRange->All,PlotStyle->{color,dash}];
 plot=Show[plotlines,plot1,plot2,plot3,PlotRange->All,AspectRatio->1];
 (*for plotting*)
 ymin1=low/.x->xmin;
 ymin2=low/.x->xmax;
 ymin3=Min[yvec-1.96 Sqrt[wvec]];
 ymin=Min[ymin1,ymin2,ymin3];
 ymax1=upp/.x->xmin;
  ymax2=upp/.x->xmax;
 ymax3=Max[yvec+1.96 Sqrt[wvec]];
  ymax=Max[ymax1,ymax2,ymax3]; 
  xMED=Median[xvec];
  varpredMED=varpred/.x->xMED;
  upp0=upp/.x->xmin;
  low0=low/.x->xmin;
  upp1=upp/.x->xmax;
  low1=low/.x->xmax;
Return[{plot,varb,varR,low0,upp0,low1,upp1,ymin,ymax,varpredMED,SSMest, SSMmle,best,bMLE,vest,vMLE,wm,hmean,wmean,v}]]


SFitPlotLin[{xvec_,yvec_,nvec_,wvec_,nNEW_},x_]:=
Module[{res,xmin,xmax,pair,plotpoints,plotlines,plotvec,plot,plot1,plot2,plot3,est,low,upp,varpred,MSE,
 ymin1,ymin2,ymin3,ymin,ymax1,ymax2,ymax3,ymax,xMED,varpredMED,varb,varR},
{est,low,upp,varb,varR,MSE}=FitLin[{xvec,yvec,nvec,wvec,nNEW},x];
xmin=Min[xvec];
xmax=Max[xvec];
pair=Transpose[{xvec,yvec}];
plotlines=Flatten@GenLines[{xvec,yvec,nvec,wvec}]; 
 color=Green;   
 dash=Dashing[{.03,.03}];
  plot1=Plot[est,{x,xmin,xmax},PlotStyle->color];
  plot2=Plot[low,{x,xmin,xmax},PlotRange->All,PlotStyle->{color,dash}];
 plot3=Plot[upp,{x,xmin,xmax},PlotRange->All,PlotStyle->{color,dash}];
 plot=Show[plotlines,plot1,plot2,plot3,PlotRange->All,AspectRatio->1];
Return[{plot,varb,varR,MSE}]]





GenLines[{xvec_,yvec_,nvec_,wvec_}]:=
Module[{dvec,tri,set},
tri=Transpose[{xvec,yvec,nvec,wvec}];
set=GenLineOne[#]& /@tri;
Return[set]]


GenLineOne[{x_,y_,n_,w_}]:=
Module[{se,line,d,botline,topline,res},
se=Sqrt[w];
line=Graphics@ Line[{{x,y-1.96 se},{x, y+1.96 se}}];
d=.02;
topline=Graphics@ Line[{{x-d/2,y+1.96 se},{x+d/2, y+1.96 se}}];
botline=Graphics@ Line[{{x-d/2,y-1.96 se},{x+d/2, y-1.96 se}}];
point=Graphics@{PointSize[d], Point[{x, y}]};
(*
point=Graphics[Circle[{x,y},d], AspectRatio->1];
*)
res ={line,topline,botline,point};
res={line,point};
Return[res]]


ExportPlot[plot_,figname_]:=
	  Module[{plotname},
	 plotname=StringJoin["sfit",figname,".eps"];    
	 Export[plotname,plot]; 
	 Print["    exporting ",plotname];
	 Print[plot];
 Return[Null]]



 CDFNormal[mu_,sigma_,x_]:=N[(Erf[(x-mu)/(Sqrt[2] sigma)] + 1) / 2]
 CDFNormal01[x_]:=CDFNormal[0,1,x]
 PValue[x_]:= 1-CDFNormal01[x]

End[] 
EndPackage[]


