(*Mathematica:: Version 7.0 *)
(*:Context:: "surrogate`" *)
(*:Title:: core estimates*)
(*Requirements:*)
 (*Date   2010 Stuart G. Baker *)  					
(*Input 
FitLik      surrlik.m*)

BeginPackage["sfitlik`"]  



FitLik::usage="FitLik[{xvec_,yvec_,nvec_,wvec_,nNEW_},x_]"
FitLin::usage="FitLin[{xvec_,yvec_,nvec_,wvec_,nNEW_},x_]"

Clear[FitLik,FitLin]

Begin["Private`"]


FitLik[{xvec_,yvec_,nvec_,wvec_,nNEW_},x_,show_:False]:=
Module[{best,bmle, vest,vmle, est,low,upp,SSM0,wNEW, varb,varb1,
      est1,low1,upp1,SSM1,wNEW1,xNEW, SSMest,SSMmle},
     {{best,bmle},{vest,vmle},hmean,wNEWean}=SurrModel[{xvec,yvec,nvec,wvec}];
    {est,low,upp,varpred,varb,varR,SSM0,wNEW,v}=FitLikCore[x,best,vest,{xvec,yvec,nvec,wvec,nNEW},"est",show];
    {est1,low1,upp1,varpred1,varb1,varR1,SSM1,wNEW1,v1}=FitLikCore[x,bmle,vmle,{xvec,yvec,nvec,wvec,nNEW},"MLE",False];
    xNEW=Median[xvec];
    SSMest=SSM0/.x->xNEW;
    SSMmle=SSM1/.x->xNEW;    
 Return[{est,low,upp,varpred,varb,varR,SSMest, SSMmle,best,bmle,vest,vmle,wNEW,hmean,wNEWean,v}]]   



FitLikCore[x_,b_,v_,{xvec_,yvec_,nvec_,wvec_,nNEW_},estimate_,show_:False]:=
Module[{hvec,varb,varR,w,varpred,sepred,est,upp,low,SSM,res},
    hvec=(yvec-b xvec)^2;
    varb= 1/Total[xvec^2 /hvec];
    If[show,
      Print["  nvec ",nvec];
      Print["  nNEW ",nNEW];
      Print["   wvec ",wvec]];
    wNEW=Mean[wvec nvec]/nNEW;
    varpred=  x^2 varb + v + wNEW;
    sepred=Sqrt[varpred];
    est= b x;
    upp=est+ 1.96 sepred;
    low=est-1.96 sepred;
    SSM=varpred/wNEW;
    varR=v+wNEW;
   res={est,low,upp,varpred,varb,varR,SSM,wNEW,v};
 Return[res]]



SurrModel[{xvec_,yvec_,nvec_,wvec_}]:=
Module[{k,b0,v0,cvec0,b1,v1,cvec1,b2,v2,cvec2,b3,v3,cvec3, mse,lik,rule,v,bmle,vmle,hmean,wNEWean},
    k=Length[xvec];
    b0=Total[xvec yvec]/Total[xvec^2];
    
     hmean=Total[(yvec-b0 xvec)^2]/k;
     wNEWean=Total[wvec]/k;
    
    vest=Max[Total[(yvec-b0 xvec)^2]/k - Total[wvec]/k,0];
    hvec=(yvec-b0 xvec)^2;
     best=Total[xvec yvec/ hvec] /Total[xvec^2/hvec];
     lik=- Apply[Plus, Log[v+wvec]] -Apply[Plus,(yvec-b xvec)^2/(v + wvec)];
        rule=Quiet@FindMaximum[{lik, v>=0},{b,best},{v,vest}];
       {bmle,vmle}={b,v}/.Last[rule]; 
     Return[{{best,bmle},{vest,vmle},hmean,wNEWean}]]



FitLin[{xvec_,yvec_,nvec_,wvec_,nNEW_},x_]:=
Module[{bhat,k,mse,xm,varpred,sepred, est,low,upp,res,varb,varR},
   bhat=Apply[Plus, xvec nvec yvec]/ Apply[Plus, nvec xvec^2]//N;
k=Length[xvec];
mse= Apply[Plus,nvec (yvec- bhat xvec)^2]/(k-1)//N;
xm=Mean[xvec];
varb= mse  / Apply[Plus, nvec xvec^2];
varR= mse/nNEW;
varpred= x^2 varb + varR;
sepred=Sqrt[varpred];
est= bhat x;
upp=est+ 1.96 sepred;
low=est-1.96 sepred;
res={est,low,upp,varb,varR,mse};
Return[res]]


End[] 
EndPackage[]


