
(*Mathematica:: Version 7.0 *)
(*:Context:: "surrogate`" *)
(*:Title:: core estimates*)
(*Requirements:*)
 (*Date   2017 Stuart G. Baker *)  					

(*need surrtalkdata.m*)

BeginPackage["sfitdata`"]  



GenCancerData::usage="GenCancerData[datanum,show], where datanum =1, 2,3"


Clear[GenCancerData]



Begin["Private`"]



GenCancerData[datanum_,show_:False]:=
Module[{mat,triset,xvec,yvec,wvec,nvec,name,res},
{mat,treat0,treat1}=GenCancerDataCore[datanum,show];
triset=GenOne[#]& /@ mat;
trisets=Sort[triset];
{xvec,yvec,nvec0,wvec}=Transpose[trisets];
(*TWO ARM SAMPLE SIZE*)
nvec=2 nvec0;
range=Range@Length[xvec];
matp=Transpose[{range,treat0,treat1,xvec,yvec, nvec,wvec}];

If[datanum==1, name="(a) Early colorectal cancer\nsurrogate endpoint = 3 year recurrence\ntrue endpoint = 5 year mortality"];
If[datanum==2, name="(b) Advanced colorectal cancer\n surrogate endpoint = 6 month recurrence\ntrue endpoint= 12 month mortality"];
If[datanum==3, name="(c) Advanced colorectal cancer\n surrogate endpoint= tumor response\ntrue endpoint = 12 month mortality"];

If[show,
  colname={"trial i", "treatment for\nfirst group", "treatment for\nsecond group","surrogate endpiont\ndifference", "true endpoint\ndifference",
   "sample size\none arm", "variance of\n true endpoint"};
   Print[name]
    Print@TableForm[matp,TableHeadings->{None,colname}]];
res={xvec,yvec,nvec,wvec,name};
Return[res]]



GenOne[vec_]:=
Module[{trial,n, xC00,xC01,xC10,xC11,xE00,xE01,xE10,xE11, pC,fC,pE,fE,difS,difT,varT,nE,nC,varC,varE,var},
{xC00,xC01,xC10,xC11,xE00,xE01,xE10,xE11}=vec;
{pC,fC,nC,varC}=GenArm[xC00,xC01,xC10,xC11];
{pE,fE,nE,varE}=GenArm[xE00,xE01,xE10,xE11];
difS=pE-pC;
difT=fE-fC;
n=Round[(nC+nE)/2];
var=varC+varE;
Return[{difS,difT,n,var}]]


GenArm[x00_,x01_,x10_,x11_]:=
Module[{n,x0,x1,y0,y1,p,f,varf},
n=x00+x01+x10+x11;
x0=x00+x01;
x1=x10+x11;
(*true*)
y0=x00+x10;
y1=x01+x11;
p=x1/n;
f=y1/n;
var=p (1-p)/n;
(*NEW FOR TRUE ENDPOINT*)
var =f (1-f)/n;
Return[{p,f,n,var}]]





GenCancerDataCore[datanum_,show_:True]:=
Module[{data1,data2,data3,a,b,c,d,
  mat4,vec4a,vec4b,vec4c,set4,
  mat5,vec5a,vec5b,vec5c,set5},
data1={{{122.3, 11.7, 22.7, 218.3, 101.2, 5.8, 21.2, 220.8}, {52., 5., 4., 
   65., 36., 4., 7., 74.}, {164.1, 28., 14., 262.9, 126., 11., 14., 
   306.}, {104.5, 13.9, 26.1, 313.5, 88.8, 10.5, 8.7, 330.}, {152.5, 
   16.5, 18.1, 335.9, 110.6, 18.6, 10.3, 379.5}, {84.3, 8., 9.1, 
   128.6, 58.2, 15.1, 10.2, 141.6}, {171.7, 23.8, 27.5, 470., 150.9, 
   19.9, 23.6, 502.5}, {46.3, 5., 9.2, 92.5, 63., 8.2, 15.2, 
   168.6}, {219.5, 35.6, 26.6, 788.4, 208.6, 31.3, 27.9, 
   798.1}, {115.2, 17.2, 18.5, 286.1, 111.7, 15.1, 13.2, 301.}}, {{1, 
   1, 1, 1, 1, 0, 1, 1, 1, 0}, {"Surgery Only", "Surgery Only", 
   "Surgery Only", "Surgery Only", "MOF", "5FU+LEV x 6 mos", 
   "5FU+LEV", "Surgery Only", "5FU+LV", "High LEV + 5FU/CF"}, {"MOF", 
   "5FU+LEV", "5FU+LEV", "PVI of 5FU", "5FU+LV", "5FU+LEV+LV x 6 mos",
    "5FU+LV+LEV", "5FU+LV", "5FU+LV+Interferon", 
   "Standard LEV+5FU/CF"}, 3, 5, "years", "survival"}, "data11"};
 data2={{{32., 0.1, 16., 1., 31., 0.1, 46., 22.}, {42., 5., 3., 19., 52., 
   14., 14., 57.}, {46., 4., 13., 28., 41., 5., 7., 41.}, {67.6, 38., 
   10.1, 48.3, 127.5, 62.5, 26.9, 109.}, {73., 22., 12., 71., 35., 
   13., 5., 40.}, {50., 0.1, 39., 68., 31., 2., 43., 76.}, {29.1, 8.5,
    3.3, 26.2, 16., 10., 7., 35.}, {118.9, 62.1, 21., 44., 105.3, 51.,
    23.2, 63.5}, {121.7, 45.3, 14.2, 34.9, 83., 41.3, 15.5, 
   66.2}, {110.2, 41.7, 19.4, 50.7, 106.1, 36.8, 18.3, 50.8}}, {{0, 0,
    0, 0, 1, 0, 0, 0, 0, 0}, {"FU+LV", "FU+LV", "FU+LV", "FU+LV", 
   "FU", "FU+LV", "FU+LV", "FU+LV", "FU+LV", "FU+LV"}, {"FU", "FU", 
   "FU", "FU", "FU+LV", "FU", "FU", "RA", "RA", "RA"}, 6, 12, 
  "months", "survival"}, "data21"};
   data3={{{83.9, 50.1, 5., 23., 63., 54., 7., 38.}, {46., 22., 1., 9., 41., 
   16., 3., 17.}, {41., 36., 0.1, 8., 36., 26., 7., 19.}, {7., 7., 
   0.1, 1., 7., 3., 1., 0.1}, {18., 11., 1., 5., 12., 11., 5., 
   11.}, {18., 11., 1., 5., 12., 11., 5., 11.}, {17., 10., 0.1, 5., 
   9., 10., 1., 12.}, {58., 26., 1., 5., 55., 29., 2., 9.}, {41., 39.,
    1., 8., 37., 35., 4., 15.}, {43., 24., 0.1, 6., 36., 23., 3., 
   13.}, {42., 18., 1., 3., 30., 15., 3., 18.}, {18., 17., 0.1, 5., 
   12., 12., 5., 10.}, {13., 8., 1., 1., 12., 6., 5., 7.}, {22., 7., 
   1., 0.1, 18., 7., 0.1, 9.}, {2., 1., 0.1, 3., 0.1, 2., 2., 
   5.}, {61., 40., 4., 8., 123., 88., 18., 40.}, {54., 34., 6., 13., 
   23., 22., 4., 6.}, {40., 39., 2., 10., 36., 40., 2., 12.}, {84., 
   52., 7., 11., 63., 62., 7., 20.}, {103., 21., 1., 2., 77., 25., 6.,
    14.}, {33., 32., 1., 12., 44., 22., 2., 18.}, {23., 22., 4., 6., 
   46., 38., 5., 14.}, {36., 18., 3., 4., 28., 19., 4., 13.}, {16., 
   17., 0.1, 0.1, 15., 8., 1., 4.}, {17., 11., 1., 4., 11., 9., 1., 
   5.}, {15., 7., 0.1, 1., 13., 8., 1., 1.}, {79., 80., 1., 22., 73., 
   78., 0.1, 23.}}, {{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
   0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1}, {"CII", "CII", "CII", "CII", 
   "HAI", "HAI", "HAI", "CII", "5FU+L", "5FU+L", "5FU+L", "5FU+L", 
   "5FU+L", "5FU+L", "HAI", "5FU+L", "ST", "ST", "5FU+M", "5FU+M+L", 
   "5FU+M+L", "5FU+M+L", "5FU+M+L", "5FU+M+L", "5FU+M+L", "ST", 
   "CII"}, {"ST", "ST", "ST", "ST", "ST", "ST", "ST", "ST", "ST", 
   "ST", "ST", "ST", "ST", "ST", "ST", "ST", "5FU+L", "5FU+L", "ST", 
   "ST", "ST", "ST", "ST", "ST", "ST", "5FU+M", "ST"}, 0, 1, "years", 
  "binary"}, "data31"};
  If[datanum==1,datacore=data1];
  If[datanum==2,datacore=data2];
  If[datanum==3,datacore=data3];
   {xmat,infovec,dataname}=datacore;
  	  {arm, treat0,treat1,times,timet,units,datatype}=infovec;
    res={xmat,treat0,treat1};   
Return[res]]





End[] 
EndPackage[]


Print["dataMANU"];

show=False;
dataMANU=GenCancerData[#,show]& /@ {1,2,3};
