(*Mathematica:: Version 7.0 *)
(*:Context:: "surrogate`" *)
(*:Title:: core estimates*)
(*Requirements:*)
 (*Date   2017 Stuart G. Baker *)  					
(*Input 
SFitPlot    sfitplot.m*)





BeginPackage["sfit`", "sfitsimplot`", "sfitplot`","sfitdata`","sfitsim`","sfitlik`"]  

SFit::usage="SFit[data,x]"

Options[SFit]= {SizeOneArmNewTrial->Automatic,ShowCalc->False}
 

SizeOneArmNewTrial::usage="Sample size of  one amr for New Trial"
ShowCalc::usage="Show calculations"

Clear[SFit]

Begin["Private`"]


SFit[data_,options___Rule]:=
Module[{res,dim,lendim,x,sizenew,plot},
 {sizenew,show}={SizeOneArmNewTrial,ShowCalc}/.{options}/.Options[SFit];
 If[InputCheckAll[sizenew,showcalc,data],
   dim=Dimensions[data];
    lendim=Length[dim];
    If[lendim==1, plot=SFitCoreOne[data,x,sizenew,show]];
    If[lendim==2, plot=SFitCoreMany[data,x,sizenew,show]];
  ExportPlot[plot,"fig2"]];  
Return[Null]]




SFitCoreOne[data_,x_,sizenew_,show_]:=
Module[{res,plot},
res=SFitCore[data,x,sizenew,show];
plot=res[[1]];
Return[plot]]



SFitCoreMany[dataset_,x_,sizenew_,show_]:=
Module[{plotvec,plotmat,plot,set,rvec,bmat,vmat,k,len,plotx},
set=SFitCore[#,x,sizenew,show]& /@ dataset;
{plot,SEMest, SEMmle,best,bmle,vest,vmle,wm,k}=Transpose[set];
showpar=False;
If[showpar,
(*slopes*)
  Print["Slopes"];
  headingsS={Automatic, {"num trials", "est", "mle"}};
  matS=Transpose[{k, best,bmle}];
  Print@TableForm[matS,TableHeadings->headingsS];
(*between SE*)
  Print["Between SE"];
  headings={Automatic, {"num trials","est", "mle"}};
  matB=Transpose[{k,Sqrt[vest],Sqrt[vmle]}];
  Print@TableForm[matB,TableHeadings->headings];
(*within SEM*)
  Print["SEM"];
  headings={Automatic, {"num trials", "est", "mle"}};
  matT=Transpose[{k, SEMest,SEMmle}];
  Print@TableForm[matT,TableHeadings->headings]];
 (*plot*) 
 len=Length[plot];
 If[OddQ[len], plotx=Join[plot,{Null}], plotx=plot];
plotmat=Partition[plotx,2];
plotx=Show[GraphicsGrid[plotmat],ImageSize->Large];
Return[plotx]]



SFitCore[data_,x_,sizenew_,show_]:=
Module[{check, name,xvec,yvec,nvec,plot,SEMest, SEMmle,best,bmle,vest,vmle,wm,k,nnew},
{xvec,yvec,nvec,wvec,name}=data;
If[sizenew===Automatic, 
   Print["using median size for new trial "];   nnew=Median[nvec],
   Print["using new trial size ",sizenew];    nnew=sizenew];
 {plot,SEMest, SEMmle,best,bmle,vest,vmle,wm,k}=SFitPlot[{xvec,yvec,nvec,wvec,name,nnew},x,show];
res={plot,SEMest, SEMmle,best,bmle,vest,vmle,wm,k};
Return[res]]





InputCheckAll[sizenew_,showcalc_,data_]:=
Module[{check1,check2,check3, check,len,xvec,yvec,wvec,nvec,name,lenx,leny,lenn,lenw},
 If[sizenew===Automatic || (NumberQ[sizenew] && sizenew>0), check1 =True, check1=False];
 If[show==True || show==False, check2=True, check2==False];
 If[check1 ==False, Print["invalid size"]];
 If[check2 ==False, Print["show calc"]];
  dim=Dimensions[data];
  lendim=Length[dim];
   If[lendim ==0 || lendim>1, check3 =False];
   If[lendim==1, check3=InputCheck[data]];
   If[lendim==2, check3vec=InputCheck[#]& /@ data; 
          check3=Apply[And,check3vec]];
If[check3==False, Print["Invalid data input"]];
check=check1 && check2 && check3;
Return[check]]

InputCheck[data_]:=
Module[{type,xvec,yvec,nvec,wvec,name, len,len0,lenx,lenw},
len=Length[data];
If[len=!=5,go=False; Print["invalid input length"]];
If[len==5,
{xvec,yvec,nvec,wvec,name}=data;
{lenx,leny,lenn, lenw, len1}=Length[#]& /@ data;
If[lenx> 1 && lenx==leny && lenx==lenn && lenx==lenw, go=True,go=False; Print["invalid input"]]];
Return[go]]




End[] 
EndPackage[]

Print["SFit[data]"];
